/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.util.Collection;
import weblogic.application.ApplicationFactoryManager;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.internal.DeploymentHandler;
import weblogic.management.internal.DeploymentHandlerContext;
import weblogic.management.internal.DeploymentHandlerHome;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.MembershipControllerImpl;
import weblogic.servlet.internal.WarDeploymentFactory;
import weblogic.servlet.internal.WarLibraryFactory;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppModuleFactory;
import weblogic.utils.Debug;
import weblogic.utils.collections.ConcurrentHashMap;

public final class WebService
extends AbstractServerService
implements DeploymentHandler {
    private static HttpServer defaultHttpServer = null;
    private static WebService singleton;
    private static final ConcurrentHashMap httpServers;
    private static final ConcurrentHashMap virtualHostsVsNames;
    private static final ConcurrentHashMap virtualHostsVsChannels;
    public static final String INTERNAL_WEB_APP_CONTEXT_PATH = "/bea_wls_internal";
    public static final String MGMT_WEB_APP_CONTEXT_PATH = "/wl_management_internal";

    private void initialize() throws ServiceFailureException {
        HTTPLogger.logHTTPInit();
        WebService.initWebServers();
        ApplicationFactoryManager applicationFactoryManager = ApplicationFactoryManager.getApplicationFactoryManager();
        applicationFactoryManager.addLibraryFactory(new WarLibraryFactory());
        applicationFactoryManager.addDeploymentFactory(new WarDeploymentFactory());
        applicationFactoryManager.addModuleFactory(new WebAppModuleFactory());
    }

    public String getName() {
        return "Servlet Container";
    }

    public String getVersion() {
        return "Servlet 2.5, JSP 2.1";
    }

    public void start() throws ServiceFailureException {
        singleton = this;
        this.initialize();
        HTTPLogger.logWebInit();
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID).getServer().getCluster();
        if (clusterMBean != null) {
            MembershipControllerImpl membershipControllerImpl = (MembershipControllerImpl)MembershipControllerImpl.getInstance();
            membershipControllerImpl.startService();
        }
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("start/resume web servers");
        }
        WebService.startWebServers();
        Debug.assertion((defaultHttpServer != null ? 1 : 0) != 0);
        DeploymentHandlerHome.addDeploymentHandler(this);
    }

    public void stop() throws ServiceFailureException {
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID).getServer().getCluster();
        if (clusterMBean != null) {
            MembershipControllerImpl membershipControllerImpl = (MembershipControllerImpl)MembershipControllerImpl.getInstance();
            membershipControllerImpl.stopService();
        }
    }

    public void halt() throws ServiceFailureException {
    }

    private static void initWebServers() throws ServiceFailureException {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(WebAppConfigManager.KERNEL_ID);
        ServerMBean serverMBean = runtimeAccess.getServer();
        WebServerMBean webServerMBean = serverMBean.getWebServer();
        try {
            WebService.initWebServer(webServerMBean);
        }
        catch (DeploymentException deploymentException) {
            throw new ServiceFailureException("Error starting web service", (Throwable)((Object)deploymentException));
        }
    }

    private static void startWebServers() {
        for (HttpServer httpServer : httpServers.values()) {
            httpServer.start();
            if (!HTTPDebugLogger.isEnabled()) continue;
            HTTPDebugLogger.debug("started web server " + httpServer);
        }
    }

    public static WebService getWebService() {
        return singleton;
    }

    public static final HttpServer defaultHttpServer() {
        return defaultHttpServer;
    }

    public static final HttpServer getHttpServer(String string) {
        HttpServer httpServer = (HttpServer)httpServers.get((Object)string);
        return httpServer;
    }

    public static final Collection getHttpServers() {
        return httpServers.values();
    }

    public static final HttpServer getVirtualHost(String string) {
        return (HttpServer)virtualHostsVsNames.get((Object)string.toLowerCase());
    }

    public static final HttpServer getVirtualHost(ServerChannel serverChannel) {
        return (HttpServer)virtualHostsVsChannels.get((Object)serverChannel.getChannelName());
    }

    public static final HttpServer findHttpServer(String string) {
        if (string == null) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug(HTTPLogger.logNoHostInHeaderLoggable().getMessage());
            }
            return WebService.defaultHttpServer();
        }
        HttpServer httpServer = WebService.getVirtualHost(string);
        if (httpServer == null) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug(HTTPLogger.logHostNotFoundLoggable((String)string).getMessage());
            }
            httpServer = WebService.defaultHttpServer();
        } else if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(HTTPLogger.logDispatchRequestLoggable((String)string).getMessage());
        }
        return httpServer;
    }

    public static final String getInternalWebAppContextPath() {
        return INTERNAL_WEB_APP_CONTEXT_PATH;
    }

    public static final String getManagementContextPath() {
        return MGMT_WEB_APP_CONTEXT_PATH;
    }

    private static HttpServer initWebServer(WebServerMBean webServerMBean) throws DeploymentException {
        HttpServer httpServer;
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(HTTPLogger.logInitWebLoggable((String)webServerMBean.getName()).getMessage());
        }
        if ((httpServer = (HttpServer)httpServers.get((Object)webServerMBean.getName())) != null) {
            return httpServer;
        }
        httpServer = new HttpServer(webServerMBean);
        if (webServerMBean instanceof VirtualHostMBean) {
            WebService.registerVirtualHost(webServerMBean, httpServer);
        } else {
            HTTPLogger.logDefaultName((String)httpServer.getName());
            if (defaultHttpServer != null) {
                throw new DeploymentException("Could not load web server " + httpServer.getName() + " as the default web server, web server " + defaultHttpServer.getName() + " is already deployed as the default " + "web server.");
            }
            defaultHttpServer = httpServer;
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug(webServerMBean + " is the default web server");
            }
        }
        httpServers.put((Object)webServerMBean.getName(), (Object)httpServer);
        httpServer.initialize();
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("initialized web server " + webServerMBean);
        }
        return httpServer;
    }

    private static void registerVirtualHost(WebServerMBean webServerMBean, HttpServer httpServer) throws DeploymentException {
        String string;
        VirtualHostMBean virtualHostMBean = (VirtualHostMBean)webServerMBean;
        String[] stringArray = virtualHostMBean.getVirtualHostNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                HTTPLogger.logRegisterVirtualHost((String)stringArray[i]);
                WebService.validateHostName(stringArray[i], webServerMBean);
                virtualHostsVsNames.put((Object)stringArray[i].toLowerCase(), (Object)httpServer);
            }
        }
        if ((string = virtualHostMBean.getNetworkAccessPoint()) != null) {
            HTTPLogger.logRegisterVirtualHost((String)(" with server ServerChannelName: " + string));
            WebService.validateChannel(string, webServerMBean);
            virtualHostsVsChannels.put((Object)string, (Object)httpServer);
        }
    }

    private static void validateHostName(String string, WebServerMBean webServerMBean) throws DeploymentException {
        HttpServer httpServer = (HttpServer)virtualHostsVsNames.get((Object)string.toLowerCase());
        if (httpServer != null) {
            Loggable loggable = HTTPLogger.logVirtualHostNameAlreadyUsedLoggable((String)string, (String)webServerMBean.getName(), (String)httpServer.getName());
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
    }

    private static void validateChannel(String string, WebServerMBean webServerMBean) throws DeploymentException {
        HttpServer httpServer = (HttpServer)virtualHostsVsChannels.get((Object)string);
        if (httpServer != null) {
            Loggable loggable = HTTPLogger.logVirtualHostServerChannelNameAlreadyUsedLoggable((String)string, (String)webServerMBean.getName(), (String)httpServer.getName());
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
        if (ServerChannelManager.findLocalServerChannel((String)string) == null) {
            Loggable loggable = HTTPLogger.logVirtualHostServerChannelUndefinedLoggable((String)string, (String)webServerMBean.getName());
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
    }

    public void prepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
        if (deploymentMBean instanceof WebServerMBean) {
            WebService.initWebServer((WebServerMBean)deploymentMBean);
        }
    }

    public void activateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
        WebServerMBean webServerMBean;
        HttpServer httpServer;
        if (deploymentMBean instanceof WebServerMBean && (httpServer = (HttpServer)httpServers.get((Object)(webServerMBean = (WebServerMBean)deploymentMBean).getName())) != null) {
            httpServer.start();
        }
    }

    public void deactivateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
        if (deploymentMBean instanceof WebServerMBean) {
            WebServerMBean webServerMBean = (WebServerMBean)deploymentMBean;
            if (webServerMBean.getName().equals(WebService.defaultHttpServer().getName())) {
                throw new UndeploymentException("Cannot undeploy default HTTP server");
            }
            HttpServer httpServer = (HttpServer)httpServers.get((Object)webServerMBean.getName());
            if (httpServer != null) {
                httpServer.shutdown();
            }
        }
    }

    public void unprepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
        if (deploymentMBean instanceof WebServerMBean) {
            WebServerMBean webServerMBean = (WebServerMBean)deploymentMBean;
            if (webServerMBean.getName().equals(WebService.defaultHttpServer().getName())) {
                throw new UndeploymentException("Cannot undeploy default HTTP server");
            }
            httpServers.remove((Object)webServerMBean.getName());
            if (webServerMBean instanceof VirtualHostMBean) {
                String string;
                VirtualHostMBean virtualHostMBean = (VirtualHostMBean)webServerMBean;
                String[] stringArray = virtualHostMBean.getVirtualHostNames();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string2 = stringArray[i];
                        if (string2 == null) continue;
                        virtualHostsVsNames.remove((Object)stringArray[i].toLowerCase());
                    }
                }
                if ((string = virtualHostMBean.getNetworkAccessPoint()) != null) {
                    virtualHostsVsChannels.remove((Object)string);
                }
            }
        }
    }

    static {
        httpServers = new ConcurrentHashMap();
        virtualHostsVsNames = new ConcurrentHashMap();
        virtualHostsVsChannels = new ConcurrentHashMap();
    }
}

