/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.VersionMunger;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.servlet.internal.JSPManager;
import weblogic.servlet.internal.session.SessionConfigManager;

public class WlsWebAppReader2
extends VersionMunger {
    private static final Map nameChanges = new HashMap(2);
    private boolean inSessionParam = false;
    private boolean inJspParam = false;
    private boolean inContainerDescriptor = false;
    private String containerDescName = null;
    private final StringBuffer containerDescValue = new StringBuffer();
    private final List containerDescElements = new ArrayList();
    private Map servletDescriptors = new HashMap();
    private boolean inDeletedElement = false;
    private boolean isDeprecated = false;
    private boolean lookupFailed = false;
    boolean inParamName = false;
    String lastParamName = null;

    public WlsWebAppReader2(InputStream inputStream, AbstractDescriptorLoader2 abstractDescriptorLoader2) throws XMLStreamException {
        super(inputStream, abstractDescriptorLoader2, "weblogic.j2ee.descriptor.wl.WeblogicWebAppBeanImpl$SchemaHelper2", nameChanges, "http://xmlns.oracle.com/weblogic/weblogic-web-app");
    }

    public String getNamespaceURI() {
        String string = super.getNamespaceURI();
        if (string == null || string == "") {
            return this.getDtdNamespaceURI();
        }
        return string;
    }

    protected VersionMunger.Continuation onStartElement(String string) {
        if ("reference-descriptor".equals(string)) {
            return this.SKIP;
        }
        if ("preprocessor".equals(string) || "preprocessor-mapping".equals(string)) {
            this.inDeletedElement = true;
        }
        if (this.inDeletedElement) {
            return this.SKIP;
        }
        if ("session-param".equals(string)) {
            this.inSessionParam = true;
            return this.SKIP;
        }
        if ("jsp-param".equals(string)) {
            this.inJspParam = true;
            return this.SKIP;
        }
        if ("param-name".equals(string)) {
            this.inParamName = true;
            return this.SKIP;
        }
        if ("param-value".equals(string)) {
            if (this.isDeprecated) {
                J2EELogger.logDeprecatedWeblogicParam((String)this.currentEvent.getParent().getElementName(), (String)this.lastParamName);
                return this.SKIP;
            }
            if (this.lookupFailed) {
                J2EELogger.logUnknownWeblogicParam((String)this.currentEvent.getParent().getElementName(), (String)this.lastParamName);
                if (this.inSessionParam) {
                    return this.SKIP;
                }
            }
            this.currentEvent.setElementName(this.lastParamName);
            this.currentEvent.setDiscard(false);
            return CONTINUE;
        }
        return CONTINUE;
    }

    protected VersionMunger.Continuation onCharacters(String string) {
        if (this.inDeletedElement) {
            return this.SKIP;
        }
        if (this.inParamName) {
            this.lastParamName = this.getSessionElementName2(string);
            return this.SKIP;
        }
        return CONTINUE;
    }

    String getSessionElementName2(String string) {
        String string2 = null;
        if (string != null) {
            if (string.trim().toLowerCase().length() == 0) {
                return string.trim();
            }
            if (this.inSessionParam && (string2 = (String)SessionConfigManager.SESSION_ELEMENTS_MAP.get(string.trim().toLowerCase())) == null) {
                this.lookupFailed = true;
            }
            if (this.inJspParam) {
                string2 = (String)JSPManager.JSP_DESC_ELEMENTS_MAP.get(string.trim().toLowerCase());
                if (string2 == "warning") {
                    this.isDeprecated = true;
                }
                if (string2 == null) {
                    this.lookupFailed = true;
                }
            }
        }
        return string2 == null ? string.trim() : string2;
    }

    protected VersionMunger.Continuation onEndElement(String string) {
        if ("reference-descriptor".equals(string)) {
            return this.SKIP;
        }
        if (this.inParamName && "param-name".equals(string)) {
            this.inParamName = false;
            return this.SKIP;
        }
        if ("param-value".equals(string)) {
            this.currentEvent.setElementName(this.lastParamName);
            this.isDeprecated = false;
            this.lookupFailed = false;
            this.lastParamName = null;
            return CONTINUE;
        }
        if (this.inDeletedElement) {
            if ("preprocessor".equals(string) || "preprocessor-mapping".equals(string)) {
                this.inDeletedElement = false;
            }
            return this.SKIP;
        }
        if ("session-param".equals(string)) {
            this.inSessionParam = false;
            return this.SKIP;
        }
        if ("jsp-param".equals(string)) {
            this.inJspParam = false;
            return this.SKIP;
        }
        if ("session-descriptor".equals(string)) {
            this.lastEvent.orderChildren();
        }
        if ("jsp-descriptor".equals(string)) {
            this.lastEvent.orderChildren();
        }
        return CONTINUE;
    }

    public static void main(String[] stringArray) throws Exception {
        AbstractDescriptorLoader2 abstractDescriptorLoader2;
        String string;
        if (stringArray.length == 0) {
            WlsWebAppReader2.usage();
            System.exit(-1);
        }
        String string2 = stringArray[0];
        String string3 = stringArray.length > 1 && stringArray[1].endsWith("plan.xml") ? stringArray[1] : null;
        File file = new File(string2);
        Object var4_4 = null;
        File file2 = new File(".");
        DeploymentPlanBean deploymentPlanBean = null;
        String string4 = string = stringArray.length > 2 ? stringArray[2] : null;
        if (string3 != null) {
            if (string == null) {
                WlsWebAppReader2.usage();
                System.exit(-1);
            }
            abstractDescriptorLoader2 = new AbstractDescriptorLoader2(new File(string3), string3){};
            deploymentPlanBean = (DeploymentPlanBean)abstractDescriptorLoader2.loadDescriptorBean();
        }
        abstractDescriptorLoader2 = new AbstractDescriptorLoader2(file, file2, deploymentPlanBean, string, string2){

            protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
                return new WlsWebAppReader2(inputStream, this);
            }
        };
        System.out.println("stamp out version munger...");
        System.out.flush();
        DescriptorBean descriptorBean = abstractDescriptorLoader2.loadDescriptorBean();
        Descriptor descriptor = descriptorBean.getDescriptor();
        descriptor.toXML((OutputStream)System.out);
    }

    private static void usage() {
        System.out.print("java weblogic.servlet.internal.WlsWebAppReader2 <dd-filename> || <dd-filename> <plan-filename> <module-name>");
    }

    static {
        nameChanges.put("global-role", "externally-defined");
        nameChanges.put("resource-env-descriptor", "resource-env-description");
        nameChanges.put("res-env-ref-name", "resource-env-ref-name");
    }
}

