/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.AuthConstraintMBean;
import weblogic.management.descriptors.webapp.SecurityRoleMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.SecurityRoleDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.internal.dd.WebAppDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class AuthConstraintDescriptor
extends BaseServletDescriptor
implements ToXML,
AuthConstraintMBean {
    private static final long serialVersionUID = -6323007461514307324L;
    private static final String ROLE_NAME = "role-name";
    private static final String DESCRIPTION = "description";
    private String description;
    private SecurityRoleMBean[] roles;

    public AuthConstraintDescriptor(WebAppDescriptor webAppDescriptor, Element element) throws DOMProcessingException {
        List list;
        this.description = DOMUtils.getOptionalValueByTagName(element, DESCRIPTION);
        List list2 = DOMUtils.getOptionalElementsByTagName(element, ROLE_NAME);
        if (list2 != null && !list2.isEmpty() && (list = DOMUtils.getTextDataValues(list2)) != null && !list.isEmpty()) {
            SecurityRoleMBean[] securityRoleMBeanArray = webAppDescriptor.getSecurityRoles();
            Hashtable<String, SecurityRoleMBean> hashtable = new Hashtable<String, SecurityRoleMBean>();
            for (int i = 0; i < securityRoleMBeanArray.length; ++i) {
                hashtable.put(securityRoleMBeanArray[i].getRoleName(), securityRoleMBeanArray[i]);
            }
            ArrayList<SecurityRoleMBean> arrayList = new ArrayList<SecurityRoleMBean>();
            for (String string : list) {
                SecurityRoleMBean securityRoleMBean;
                if (!string.equals("*")) {
                    securityRoleMBean = (SecurityRoleMBean)hashtable.get(string);
                    if (securityRoleMBean == null) {
                        HTTPLogger.logBadSecurityRoleInAC((String)string);
                        continue;
                    }
                    arrayList.add(securityRoleMBean);
                    continue;
                }
                securityRoleMBean = new SecurityRoleDescriptor();
                securityRoleMBean.setRoleName("*");
                arrayList.add(securityRoleMBean);
            }
            this.roles = arrayList.toArray(new SecurityRoleMBean[0]);
        }
    }

    public AuthConstraintDescriptor() {
        this.roles = new SecurityRoleMBean[0];
    }

    public AuthConstraintDescriptor(AuthConstraintMBean authConstraintMBean) {
        this.setDescription(authConstraintMBean.getDescription());
        this.setRoles(authConstraintMBean.getRoles());
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
        SecurityRoleMBean[] securityRoleMBeanArray = this.getRoles();
        if (securityRoleMBeanArray == null || securityRoleMBeanArray.length == 0) {
            this.addDescriptorError("NO_ROLE_NAMES");
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public void setRoles(SecurityRoleMBean[] securityRoleMBeanArray) {
        SecurityRoleMBean[] securityRoleMBeanArray2 = this.roles;
        this.roles = securityRoleMBeanArray;
        if (!AuthConstraintDescriptor.comp(securityRoleMBeanArray2, this.roles)) {
            this.firePropertyChange("roles", securityRoleMBeanArray2, this.roles);
        }
    }

    public SecurityRoleMBean[] getRoles() {
        return this.roles;
    }

    public void addRole(SecurityRoleMBean securityRoleMBean) {
        SecurityRoleMBean[] securityRoleMBeanArray = this.getRoles();
        if (securityRoleMBeanArray == null) {
            securityRoleMBeanArray = new SecurityRoleMBean[]{securityRoleMBean};
            this.setRoles(securityRoleMBeanArray);
            return;
        }
        SecurityRoleMBean[] securityRoleMBeanArray2 = new SecurityRoleMBean[securityRoleMBeanArray.length + 1];
        System.arraycopy(securityRoleMBeanArray, 0, securityRoleMBeanArray2, 0, securityRoleMBeanArray.length);
        securityRoleMBeanArray2[securityRoleMBeanArray.length] = securityRoleMBean;
        this.setRoles(securityRoleMBeanArray2);
    }

    public void removeRole(SecurityRoleMBean securityRoleMBean) {
        SecurityRoleMBean[] securityRoleMBeanArray = this.getRoles();
        if (securityRoleMBeanArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < securityRoleMBeanArray.length; ++i) {
            if (!securityRoleMBeanArray[i].equals(securityRoleMBean)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            SecurityRoleMBean[] securityRoleMBeanArray2 = new SecurityRoleMBean[securityRoleMBeanArray.length - 1];
            System.arraycopy(securityRoleMBeanArray, 0, securityRoleMBeanArray2, 0, n);
            System.arraycopy(securityRoleMBeanArray, n + 1, securityRoleMBeanArray2, n, securityRoleMBeanArray.length - (n + 1));
            this.setRoles(securityRoleMBeanArray2);
        }
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!AuthConstraintDescriptor.comp(string2, string)) {
            this.firePropertyChange(DESCRIPTION, string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<auth-constraint>\n";
        n += 2;
        if (this.description != null && this.description.length() > 0) {
            string = string + this.indentStr(n) + "<description>" + this.description + "</description>\n";
        }
        for (int i = 0; this.roles != null && i < this.roles.length; ++i) {
            if (this.roles[i] == null) continue;
            String string2 = this.roles[i].getRoleName();
            string = string + this.indentStr(n) + "<role-name>" + string2 + "</role-name>\n";
        }
        string = string + this.indentStr(n -= 2) + "</auth-constraint>\n";
        return string;
    }

    public String toString() {
        String string = "AuthConstraintDescriptor(";
        String string2 = "{";
        for (int i = 0; i < this.roles.length; ++i) {
            string2 = string2 + this.roles[i].getRoleName();
            string2 = i == this.roles.length - 1 ? string2 + "}" : string2 + ",";
        }
        string = string + "roles=" + string2 + ",";
        string = string + ")";
        return string;
    }
}

