/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.ArrayList;
import java.util.List;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.WebElementMBean;
import weblogic.management.descriptors.XMLElementMBeanDelegate;
import weblogic.servlet.internal.dd.DescriptorError;
import weblogic.utils.io.XMLWriter;

public abstract class BaseServletDescriptor
extends XMLElementMBeanDelegate {
    private static final long serialVersionUID = -1306936740447325550L;
    private List errorList = null;

    public void addDescriptorError(String string) {
        this.addDescriptorError(new DescriptorError(string));
    }

    public void addDescriptorError(String string, String string2) {
        this.addDescriptorError(new DescriptorError(string, string2));
    }

    public void addDescriptorError(String string, String string2, String string3) {
        this.addDescriptorError(new DescriptorError(string, string2, string3));
    }

    public void addDescriptorError(DescriptorError descriptorError) {
        if (this.errorList == null) {
            this.errorList = new ArrayList();
        }
        if (descriptorError != null) {
            this.errorList.add(descriptorError);
        }
    }

    public void removeDescriptorError(String string) {
        if (string == null || this.errorList == null) {
            return;
        }
        for (DescriptorError descriptorError : this.errorList) {
            if (!string.equals(descriptorError.getError())) continue;
            this.errorList.remove(descriptorError);
            break;
        }
    }

    public void addDescriptorError(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addDescriptorError(stringArray[i]);
        }
    }

    public void removeDescriptorErrors() {
        this.errorList = new ArrayList();
    }

    public void setDescriptorErrors(String[] stringArray) {
        this.removeDescriptorErrors();
        this.addDescriptorError(stringArray);
    }

    public String[] getDescriptorErrors() {
        if (this.errorList == null || this.errorList.size() == 0) {
            return null;
        }
        DescriptorError[] descriptorErrorArray = this.errorList.toArray(new DescriptorError[this.errorList.size()]);
        String[] stringArray = new String[descriptorErrorArray.length];
        for (int i = 0; i < descriptorErrorArray.length; ++i) {
            stringArray[i] = descriptorErrorArray[i].toString();
        }
        return stringArray;
    }

    protected String indentStr(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public abstract void validate() throws DescriptorValidationException;

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (DescriptorValidationException descriptorValidationException) {
            return false;
        }
    }

    protected boolean check(WebElementMBean webElementMBean) {
        if (webElementMBean.isValid()) {
            return true;
        }
        this.addDescriptorError(webElementMBean.getDescriptorErrors());
        return false;
    }

    public void toXML(XMLWriter xMLWriter) {
        xMLWriter.println(this.toXML());
    }

    public String toXML() {
        return this.toXML(0);
    }

    public abstract String toXML(int var1);

    protected String arrayToString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        String string = "{";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + stringArray[i];
        }
        string = string + "}";
        return string;
    }
}

