/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webappext.CharsetMappingMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class CharsetMapping
extends BaseServletDescriptor
implements CharsetMappingMBean {
    private static final long serialVersionUID = -5431702633984221708L;
    private static String IANA_NAME = "iana-charset-name";
    private static String JAVA_NAME = "java-charset-name";
    String ianaName;
    String javaName;

    public String getIANACharsetName() {
        return this.ianaName;
    }

    public void setIANACharsetName(String string) {
        String string2 = this.ianaName;
        this.ianaName = string;
        if (!CharsetMapping.comp(string2, string)) {
            this.firePropertyChange("IANACharsetName", string2, string);
        }
    }

    public String getJavaCharsetName() {
        return this.javaName;
    }

    public void setJavaCharsetName(String string) {
        String string2 = this.javaName;
        this.javaName = string;
        if (!CharsetMapping.comp(string2, string)) {
            this.firePropertyChange("JavaCharsetName", string2, string);
        }
    }

    public CharsetMapping() {
    }

    public CharsetMapping(Element element) throws DOMProcessingException {
        this.ianaName = DOMUtils.getValueByTagName(element, IANA_NAME);
        this.javaName = DOMUtils.getValueByTagName(element, JAVA_NAME);
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.indentStr(n));
        stringBuffer.append("<charset-mapping>\n");
        stringBuffer.append(this.indentStr(n += 2));
        stringBuffer.append("<iana-charset-name>");
        stringBuffer.append(this.ianaName);
        stringBuffer.append("</iana-charset-name>\n");
        stringBuffer.append(this.indentStr(n));
        stringBuffer.append("<java-charset-name>" + this.javaName + "</java-charset-name>\n");
        stringBuffer.append(this.indentStr(n -= 2));
        stringBuffer.append("</charset-mapping>\n");
        return stringBuffer.toString();
    }
}

