/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webappext.CharsetMappingMBean;
import weblogic.management.descriptors.webappext.CharsetParamsMBean;
import weblogic.management.descriptors.webappext.InputCharsetDescriptorMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.CharsetMapping;
import weblogic.servlet.internal.dd.InputCharsetDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class CharsetParams
extends BaseServletDescriptor
implements CharsetParamsMBean {
    private static final long serialVersionUID = 1946096778263982155L;
    private static final String INPUT_CHARSET = "input-charset";
    private static final String CHARSET_MAPPING = "charset-mapping";
    private CharsetMappingMBean[] charsetMappings;
    private InputCharsetDescriptorMBean[] inputCharsets;

    public CharsetParams() {
    }

    public CharsetParams(Element element) throws DOMProcessingException {
        Object object;
        List<InputCharsetDescriptor> list;
        List list2 = DOMUtils.getOptionalElementsByTagName(element, INPUT_CHARSET);
        if (list2 != null) {
            list = new ArrayList();
            object = list2.iterator();
            while (object.hasNext()) {
                ((ArrayList)list).add(new InputCharsetDescriptor((Element)object.next()));
            }
            this.inputCharsets = ((ArrayList)list).toArray((InputCharsetDescriptorMBean[])new InputCharsetDescriptorMBean[0]);
        }
        if ((list = DOMUtils.getOptionalElementsByTagName(element, CHARSET_MAPPING)) != null) {
            object = new ArrayList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((ArrayList)object).add(new CharsetMapping((Element)iterator.next()));
            }
            this.charsetMappings = ((ArrayList)object).toArray(new CharsetMappingMBean[0]);
        }
    }

    public InputCharsetDescriptorMBean[] getInputCharsets() {
        return this.inputCharsets;
    }

    public void setInputCharsets(InputCharsetDescriptorMBean[] inputCharsetDescriptorMBeanArray) {
        InputCharsetDescriptorMBean[] inputCharsetDescriptorMBeanArray2 = this.inputCharsets;
        this.inputCharsets = inputCharsetDescriptorMBeanArray;
        if (!CharsetParams.comp(inputCharsetDescriptorMBeanArray2, inputCharsetDescriptorMBeanArray)) {
            this.firePropertyChange("inputCharsets", inputCharsetDescriptorMBeanArray2, inputCharsetDescriptorMBeanArray);
        }
    }

    public void addInputCharset(InputCharsetDescriptorMBean inputCharsetDescriptorMBean) {
        InputCharsetDescriptorMBean[] inputCharsetDescriptorMBeanArray = this.getInputCharsets();
        if (inputCharsetDescriptorMBeanArray == null) {
            inputCharsetDescriptorMBeanArray = new InputCharsetDescriptor[]{inputCharsetDescriptorMBean};
            this.setInputCharsets(inputCharsetDescriptorMBeanArray);
            return;
        }
        InputCharsetDescriptorMBean[] inputCharsetDescriptorMBeanArray2 = new InputCharsetDescriptorMBean[inputCharsetDescriptorMBeanArray.length + 1];
        System.arraycopy(inputCharsetDescriptorMBeanArray, 0, inputCharsetDescriptorMBeanArray2, 0, inputCharsetDescriptorMBeanArray.length);
        inputCharsetDescriptorMBeanArray2[inputCharsetDescriptorMBeanArray.length] = inputCharsetDescriptorMBean;
        this.setInputCharsets(inputCharsetDescriptorMBeanArray2);
    }

    public void removeInputCharset(InputCharsetDescriptorMBean inputCharsetDescriptorMBean) {
        InputCharsetDescriptorMBean[] inputCharsetDescriptorMBeanArray = this.getInputCharsets();
        if (inputCharsetDescriptorMBeanArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < inputCharsetDescriptorMBeanArray.length; ++i) {
            if (!inputCharsetDescriptorMBeanArray[i].equals(inputCharsetDescriptorMBean)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            InputCharsetDescriptorMBean[] inputCharsetDescriptorMBeanArray2 = new InputCharsetDescriptorMBean[inputCharsetDescriptorMBeanArray.length - 1];
            System.arraycopy(inputCharsetDescriptorMBeanArray, 0, inputCharsetDescriptorMBeanArray2, 0, n);
            System.arraycopy(inputCharsetDescriptorMBeanArray, n + 1, inputCharsetDescriptorMBeanArray2, n, inputCharsetDescriptorMBeanArray.length - (n + 1));
            this.setInputCharsets(inputCharsetDescriptorMBeanArray2);
        }
    }

    public CharsetMappingMBean[] getCharsetMappings() {
        if (this.charsetMappings == null) {
            this.charsetMappings = new CharsetMappingMBean[0];
        }
        return this.charsetMappings;
    }

    public void setCharsetMappings(CharsetMappingMBean[] charsetMappingMBeanArray) {
        CharsetMappingMBean[] charsetMappingMBeanArray2 = this.charsetMappings;
        this.charsetMappings = charsetMappingMBeanArray;
        if (!CharsetParams.comp(charsetMappingMBeanArray2, charsetMappingMBeanArray)) {
            this.firePropertyChange("charsetMappings", charsetMappingMBeanArray2, charsetMappingMBeanArray);
        }
    }

    public void addCharsetMapping(CharsetMappingMBean charsetMappingMBean) {
        CharsetMappingMBean[] charsetMappingMBeanArray = this.getCharsetMappings();
        if (charsetMappingMBeanArray == null) {
            charsetMappingMBeanArray = new CharsetMappingMBean[]{charsetMappingMBean};
            this.setCharsetMappings(charsetMappingMBeanArray);
            return;
        }
        CharsetMappingMBean[] charsetMappingMBeanArray2 = new CharsetMappingMBean[charsetMappingMBeanArray.length + 1];
        System.arraycopy(charsetMappingMBeanArray, 0, charsetMappingMBeanArray2, 0, charsetMappingMBeanArray.length);
        charsetMappingMBeanArray2[charsetMappingMBeanArray.length] = charsetMappingMBean;
        this.setCharsetMappings(charsetMappingMBeanArray2);
    }

    public void removeCharsetMapping(CharsetMappingMBean charsetMappingMBean) {
        CharsetMappingMBean[] charsetMappingMBeanArray = this.getCharsetMappings();
        if (charsetMappingMBeanArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < charsetMappingMBeanArray.length; ++i) {
            if (!charsetMappingMBeanArray[i].equals(charsetMappingMBean)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            CharsetMappingMBean[] charsetMappingMBeanArray2 = new CharsetMappingMBean[charsetMappingMBeanArray.length - 1];
            System.arraycopy(charsetMappingMBeanArray, 0, charsetMappingMBeanArray2, 0, n);
            System.arraycopy(charsetMappingMBeanArray, n + 1, charsetMappingMBeanArray2, n, charsetMappingMBeanArray.length - (n + 1));
            this.setCharsetMappings(charsetMappingMBeanArray2);
        }
    }

    public void validate() throws DescriptorValidationException {
        int n;
        this.removeDescriptorErrors();
        boolean bl = true;
        if (this.inputCharsets != null) {
            for (n = 0; n < this.inputCharsets.length; ++n) {
                bl &= this.check(this.inputCharsets[n]);
            }
        }
        if (this.charsetMappings != null) {
            for (n = 0; n < this.charsetMappings.length; ++n) {
                bl &= this.check(this.charsetMappings[n]);
            }
        }
        if (!bl) {
            String[] stringArray = this.getDescriptorErrors();
            throw new DescriptorValidationException(this.arrayToString(stringArray));
        }
    }

    public String toXML(int n) {
        int n2;
        String string = "";
        boolean bl = false;
        if (this.inputCharsets != null && this.inputCharsets.length > 0) {
            for (n2 = 0; n2 < this.inputCharsets.length; ++n2) {
                string = string + this.inputCharsets[n2].toXML(n + 2);
            }
            bl = true;
        }
        if (this.charsetMappings != null && this.charsetMappings.length > 0) {
            for (n2 = 0; n2 < this.charsetMappings.length; ++n2) {
                string = string + this.charsetMappings[n2].toXML(n + 2);
            }
            bl = true;
        }
        if (bl) {
            return this.indentStr(n) + "<charset-params>\n" + string + this.indentStr(n) + "</charset-params>\n";
        }
        return "";
    }
}

