/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webappext.ContainerDescriptorMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class ContainerDescriptor
extends BaseServletDescriptor
implements ContainerDescriptorMBean {
    private static final String CHECK_AUTH_ON_FORWARD = "check-auth-on-forward";
    private static final String REDIRECT_WITH_ABSOLUTE_URL = "redirect-with-absolute-url";
    private static final String INDEX_DIRECTORY_ENABLED = "index-directory-enabled";
    private static final String FILTER_DISPATCHED_REQUESTS_ENABLED = "filter-dispatched-requests-enabled";
    private static final String SERVLET_RELOAD_CHECK_SECS = "servlet-reload-check-secs";
    private static final String SINGLE_THREADED_MODEL_POOLSIZE = "single-threaded-servlet-pool-size";
    private static final String SESSION_MONITORING_ENABLED = "session-monitoring-enabled";
    private static final String PREFER_WEBINF_CLASSES = "prefer-web-inf-classes";
    private static final String INDEX_DIRECTORY_SORT_BY = "index-directory-sort-by";
    private static final String SAVE_SESSIONS_ENABLED = "save-sessions-enabled";
    private static final String DEFAULT_MIME_TYPE = "default-mime-type";
    private boolean checkAuthOnForward = false;
    private boolean redirectWithAbsoluteURL = true;
    private boolean preferWebInfClasses = false;
    private boolean filterDispatchedRequestsEnabled = true;
    private boolean indexDirectoryEnabled = false;
    private String indexDirectorySortBy = null;
    private boolean sessionMonitoringEnabled = false;
    private boolean saveSessionsEnabled = false;
    private int servletReloadCheckSecs = 1;
    private int singleThreadedServletPoolSize = 5;
    private boolean filterDispatchedRequestsEnabledSet = false;
    private boolean indexDirectoryEnabledSet = false;
    private boolean sessionMonitoringEnabledSet = false;
    private boolean saveSessionsEnabledSet = false;
    private boolean servletReloadCheckSecsSet = false;
    private boolean singleThreadedServletPoolSizeSet = false;
    private boolean preferWebInfClassesSet = false;
    private String defaultMimeType = null;

    public ContainerDescriptor() {
    }

    public ContainerDescriptor(Element element) throws DOMProcessingException {
        String string = DOMUtils.getOptionalValueByTagName(element, CHECK_AUTH_ON_FORWARD);
        if (string != null && (string.equals("") || string.equalsIgnoreCase("true"))) {
            this.checkAuthOnForward = true;
        }
        if ((string = DOMUtils.getOptionalValueByTagName(element, REDIRECT_WITH_ABSOLUTE_URL)) != null && string.equalsIgnoreCase("false")) {
            this.redirectWithAbsoluteURL = false;
        }
        if ((string = DOMUtils.getOptionalValueByTagName(element, PREFER_WEBINF_CLASSES)) != null) {
            this.preferWebInfClasses = string.equalsIgnoreCase("true");
            this.preferWebInfClassesSet = true;
        }
        if ((string = DOMUtils.getOptionalValueByTagName(element, FILTER_DISPATCHED_REQUESTS_ENABLED)) != null) {
            this.filterDispatchedRequestsEnabledSet = true;
            this.filterDispatchedRequestsEnabled = string.equalsIgnoreCase("true");
        }
        if ((string = DOMUtils.getOptionalValueByTagName(element, INDEX_DIRECTORY_ENABLED)) != null) {
            this.indexDirectoryEnabledSet = true;
            this.indexDirectoryEnabled = string.equalsIgnoreCase("true");
        }
        if ((string = DOMUtils.getOptionalValueByTagName(element, SAVE_SESSIONS_ENABLED)) != null) {
            this.saveSessionsEnabledSet = true;
            this.saveSessionsEnabled = string.equalsIgnoreCase("true");
        }
        this.indexDirectorySortBy = DOMUtils.getOptionalValueByTagName(element, INDEX_DIRECTORY_SORT_BY);
        if (this.indexDirectorySortBy != null) {
            if (this.indexDirectorySortBy.equalsIgnoreCase("NAME")) {
                this.indexDirectorySortBy = "NAME";
            } else if (this.indexDirectorySortBy.equalsIgnoreCase("LAST_MODIFIED")) {
                this.indexDirectorySortBy = "LAST_MODIFIED";
            } else if (this.indexDirectorySortBy.equalsIgnoreCase("SIZE")) {
                this.indexDirectorySortBy = "SIZE";
            } else {
                HTTPLogger.logInvalidIndexDirectorySortBy((String)this.indexDirectorySortBy);
                throw new DOMProcessingException("Invalid value assigned for element index-directory-sort-by in weblogic.xml: " + this.indexDirectorySortBy);
            }
        }
        if ((string = DOMUtils.getOptionalValueByTagName(element, SESSION_MONITORING_ENABLED)) != null) {
            this.sessionMonitoringEnabledSet = true;
            this.sessionMonitoringEnabled = string.equalsIgnoreCase("true");
        }
        if ((string = DOMUtils.getOptionalValueByTagName(element, SERVLET_RELOAD_CHECK_SECS)) != null) {
            try {
                this.servletReloadCheckSecs = Integer.parseInt(string);
                this.servletReloadCheckSecsSet = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.servletReloadCheckSecs = 1;
            }
        }
        if ((string = DOMUtils.getOptionalValueByTagName(element, SINGLE_THREADED_MODEL_POOLSIZE)) != null) {
            try {
                this.singleThreadedServletPoolSize = Integer.parseInt(string);
                this.singleThreadedServletPoolSizeSet = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.singleThreadedServletPoolSize = 5;
            }
        }
        this.defaultMimeType = DOMUtils.getOptionalValueByTagName(element, DEFAULT_MIME_TYPE);
    }

    public boolean isCheckAuthOnForwardEnabled() {
        return this.checkAuthOnForward;
    }

    public void setCheckAuthOnForwardEnabled(boolean bl) {
        boolean bl2 = this.checkAuthOnForward;
        this.checkAuthOnForward = bl;
        if (bl2 != bl) {
            this.firePropertyChange("checkAuthOnForwardEnabled", new Boolean(!bl), new Boolean(bl));
        }
    }

    public String getRedirectContentType() {
        return null;
    }

    public void setRedirectContentType(String string) {
    }

    public String getRedirectContent() {
        return null;
    }

    public void setRedirectContent(String string) {
    }

    public boolean isRedirectWithAbsoluteURLEnabled() {
        return this.redirectWithAbsoluteURL;
    }

    public void setRedirectWithAbsoluteURLEnabled(boolean bl) {
        boolean bl2 = this.redirectWithAbsoluteURL;
        this.redirectWithAbsoluteURL = bl;
        if (bl2 != bl) {
            this.firePropertyChange("redirectWithAbsoluteURLEnabled", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isFilterDispatchedRequestsEnabled() {
        return this.filterDispatchedRequestsEnabled;
    }

    public void setFilterDispatchedRequestsEnabled(boolean bl) {
        boolean bl2 = this.filterDispatchedRequestsEnabled;
        this.filterDispatchedRequestsEnabled = bl;
        if (bl2 != bl) {
            this.firePropertyChange("filterDispatchedRequestsEnabled", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isIndexDirectoryEnabled() {
        return this.indexDirectoryEnabled;
    }

    public void setIndexDirectoryEnabled(boolean bl) {
        boolean bl2 = this.indexDirectoryEnabled;
        this.indexDirectoryEnabled = bl;
        if (bl2 != bl) {
            this.firePropertyChange("indexDirectoryEnabled", new Boolean(!bl), new Boolean(bl));
        }
    }

    public String getIndexDirectorySortBy() {
        return this.indexDirectorySortBy;
    }

    public void setIndexDirectorySortBy(String string) {
        String string2 = this.indexDirectorySortBy;
        this.indexDirectorySortBy = string;
        if (!ContainerDescriptor.comp(string2, string)) {
            this.firePropertyChange("indexDirectorySortBy", string2, string);
        }
    }

    public boolean isSessionMonitoringEnabled() {
        return this.sessionMonitoringEnabled;
    }

    public void setSessionMonitoringEnabled(boolean bl) {
        boolean bl2 = this.sessionMonitoringEnabled;
        this.sessionMonitoringEnabled = bl;
        if (bl2 != bl) {
            this.firePropertyChange("sessionMonitoringEnabled", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isSaveSessionsEnabled() {
        return this.saveSessionsEnabled;
    }

    public void setSaveSessionsEnabled(boolean bl) {
        boolean bl2 = this.saveSessionsEnabled;
        this.saveSessionsEnabled = bl;
        if (bl2 != bl) {
            this.firePropertyChange("saveSessionsEnabled", new Boolean(!bl), new Boolean(bl));
        }
    }

    public int getServletReloadCheckSecs() {
        return this.servletReloadCheckSecs;
    }

    public void setServletReloadCheckSecs(int n) {
        int n2 = this.servletReloadCheckSecs;
        this.servletReloadCheckSecs = n;
        if (n2 != n) {
            this.firePropertyChange("servletReloadCheckSecs", new Integer(n2), new Integer(n));
        }
    }

    public int getSingleThreadedServletPoolSize() {
        return this.singleThreadedServletPoolSize;
    }

    public void setSingleThreadedServletPoolSize(int n) {
        int n2 = this.singleThreadedServletPoolSize;
        this.singleThreadedServletPoolSize = n;
        if (n2 != n) {
            this.firePropertyChange("singleThreadedServletPoolSize", new Integer(n2), new Integer(n));
        }
    }

    public boolean isPreferWebInfClasses() {
        return this.preferWebInfClasses;
    }

    public void setPreferWebInfClasses(boolean bl) {
        boolean bl2 = this.preferWebInfClasses;
        this.preferWebInfClasses = bl;
        if (bl2 != bl) {
            this.firePropertyChange("preferWebInfClasses", new Boolean(!bl), new Boolean(bl));
        }
    }

    public void setDefaultMimeType(String string) {
        String string2 = this.defaultMimeType;
        this.defaultMimeType = string;
        if (!ContainerDescriptor.comp(string2, string)) {
            this.firePropertyChange("defaultMimeType", string2, string);
        }
    }

    public boolean isFilterDispatchedRequestsEnabledSet() {
        return this.filterDispatchedRequestsEnabledSet;
    }

    public boolean isIndexDirectoryEnabledSet() {
        return this.indexDirectoryEnabledSet;
    }

    public boolean isSaveSessionsEnabledSet() {
        return this.saveSessionsEnabledSet;
    }

    public boolean isSessionMonitoringEnabledSet() {
        return this.sessionMonitoringEnabledSet;
    }

    public boolean isServletReloadCheckSecsSet() {
        return this.servletReloadCheckSecsSet;
    }

    public boolean isSingleThreadedServletPoolSizeSet() {
        return this.singleThreadedServletPoolSizeSet;
    }

    public boolean isPreferWebInfClassesSet() {
        return this.preferWebInfClassesSet;
    }

    public String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
        if (!(this.indexDirectorySortBy == null || this.indexDirectorySortBy.equals("NAME") || this.indexDirectorySortBy.equals("LAST_MODIFIED") || this.indexDirectorySortBy.equals("SIZE"))) {
            HTTPLogger.logInvalidIndexDirectorySortBy((String)this.indexDirectorySortBy);
            throw new DescriptorValidationException("Invalid value assigned for element index-directory-sort-by in weblogic.xml: " + this.indexDirectorySortBy);
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        boolean bl = false;
        if (this.checkAuthOnForward) {
            string = string + this.indentStr(n + 2) + "<" + CHECK_AUTH_ON_FORWARD + "/>\n";
            bl = true;
        }
        if (!this.filterDispatchedRequestsEnabled) {
            string = string + this.indentStr(n + 2) + "<" + FILTER_DISPATCHED_REQUESTS_ENABLED + ">" + this.filterDispatchedRequestsEnabled + "</" + FILTER_DISPATCHED_REQUESTS_ENABLED + ">\n";
            bl = true;
        }
        if (!this.redirectWithAbsoluteURL) {
            string = string + this.indentStr(n + 2) + "<" + REDIRECT_WITH_ABSOLUTE_URL + ">" + this.redirectWithAbsoluteURL + "</" + REDIRECT_WITH_ABSOLUTE_URL + ">\n";
            bl = true;
        }
        if (this.indexDirectoryEnabled) {
            string = string + this.indentStr(n + 2) + "<" + INDEX_DIRECTORY_ENABLED + ">" + this.indexDirectoryEnabled + "</" + INDEX_DIRECTORY_ENABLED + ">\n";
            bl = true;
        }
        if (this.indexDirectorySortBy != null) {
            string = string + this.indentStr(n + 2) + "<" + INDEX_DIRECTORY_SORT_BY + ">" + this.indexDirectorySortBy + "</" + INDEX_DIRECTORY_SORT_BY + ">\n";
            bl = true;
        }
        if (this.servletReloadCheckSecs != 1) {
            string = string + this.indentStr(n + 2) + "<" + SERVLET_RELOAD_CHECK_SECS + ">" + this.servletReloadCheckSecs + "</" + SERVLET_RELOAD_CHECK_SECS + ">\n";
            bl = true;
        }
        if (this.singleThreadedServletPoolSize != 5) {
            string = string + this.indentStr(n + 2) + "<" + SINGLE_THREADED_MODEL_POOLSIZE + ">" + this.singleThreadedServletPoolSize + "</" + SINGLE_THREADED_MODEL_POOLSIZE + ">\n";
            bl = true;
        }
        if (this.sessionMonitoringEnabled) {
            string = string + this.indentStr(n + 2) + "<" + SESSION_MONITORING_ENABLED + ">" + this.sessionMonitoringEnabled + "</" + SESSION_MONITORING_ENABLED + ">\n";
            bl = true;
        }
        if (this.saveSessionsEnabled) {
            string = string + this.indentStr(n + 2) + "<" + SAVE_SESSIONS_ENABLED + ">" + this.saveSessionsEnabled + "</" + SAVE_SESSIONS_ENABLED + ">\n";
            bl = true;
        }
        if (this.preferWebInfClasses) {
            string = string + this.indentStr(n + 2) + "<" + PREFER_WEBINF_CLASSES + ">" + this.preferWebInfClasses + "</" + PREFER_WEBINF_CLASSES + ">\n";
            bl = true;
        }
        if (this.defaultMimeType != null) {
            string = string + this.indentStr(n + 2) + "<" + DEFAULT_MIME_TYPE + ">" + this.defaultMimeType + "</" + DEFAULT_MIME_TYPE + ">\n";
            bl = true;
        }
        if (bl) {
            return this.indentStr(n) + "<container-descriptor>\n" + string + this.indentStr(n) + "</container-descriptor>\n";
        }
        return "";
    }
}

