/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.EjbRefMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class EJBReference
extends BaseServletDescriptor
implements EjbRefMBean {
    private static final long serialVersionUID = 6384556811917373836L;
    String description;
    String ejbLink;
    String ejbRefName;
    String ejbRefType;
    String home;
    String remote;
    String runAs;

    public EJBReference() {
    }

    public EJBReference(String string, String string2, String string3, String string4, String string5, String string6) {
        this.setDescription(string);
        this.setEJBRefName(string2);
        this.setEJBRefType(string3);
        this.setHomeInterfaceName(string4);
        this.setRemoteInterfaceName(string5);
        this.setEJBLinkName(string6);
    }

    public EJBReference(EjbRefMBean ejbRefMBean) {
        this.setDescription(ejbRefMBean.getDescription());
        this.setEJBLinkName(ejbRefMBean.getEJBLinkName());
        this.setEJBRefName(ejbRefMBean.getEJBRefName());
        this.setEJBRefType(ejbRefMBean.getEJBRefType());
        this.setHomeInterfaceName(ejbRefMBean.getHomeInterfaceName());
        this.setRemoteInterfaceName(ejbRefMBean.getRemoteInterfaceName());
        this.setRunAs(ejbRefMBean.getRunAs());
    }

    public EJBReference(Element element) throws DOMProcessingException {
        this.setDescription(DOMUtils.getOptionalValueByTagName(element, "description"));
        this.setEJBRefName(DOMUtils.getValueByTagName(element, "ejb-ref-name"));
        this.setEJBRefType(DOMUtils.getValueByTagName(element, "ejb-ref-type"));
        this.setHomeInterfaceName(DOMUtils.getValueByTagName(element, "home"));
        this.setRemoteInterfaceName(DOMUtils.getValueByTagName(element, "remote"));
        this.setEJBLinkName(DOMUtils.getOptionalValueByTagName(element, "ejb-link"));
        this.setRunAs(DOMUtils.getOptionalValueByTagName(element, "run-as"));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!EJBReference.comp(string2, string)) {
            this.firePropertyChange("description", string2, string);
        }
    }

    public String getEJBRefName() {
        return this.ejbRefName;
    }

    public void setEJBRefName(String string) {
        String string2 = this.ejbRefName;
        this.ejbRefName = string;
        if (!EJBReference.comp(string2, string)) {
            this.firePropertyChange("ejbRefName", string2, string);
        }
    }

    public String getEJBRefType() {
        return this.ejbRefType;
    }

    public void setEJBRefType(String string) {
        String string2 = this.ejbRefType;
        this.ejbRefType = string;
        if (!EJBReference.comp(string2, string)) {
            this.firePropertyChange("ejbRefType", string2, string);
        }
    }

    public String getHomeInterfaceName() {
        return this.home;
    }

    public void setHomeInterfaceName(String string) {
        String string2 = this.home;
        this.home = string;
        if (!EJBReference.comp(string2, string)) {
            this.firePropertyChange("homeInterfaceName", string2, string);
        }
    }

    public String getEJBLinkName() {
        return this.ejbLink;
    }

    public void setEJBLinkName(String string) {
        String string2 = this.ejbLink;
        this.ejbLink = string;
        if (!EJBReference.comp(string2, string)) {
            this.firePropertyChange("ejbLinkName", string2, string);
        }
    }

    public String getRemoteInterfaceName() {
        return this.remote;
    }

    public void setRemoteInterfaceName(String string) {
        String string2 = this.remote;
        this.remote = string;
        if (!EJBReference.comp(string2, string)) {
            this.firePropertyChange("remoteInterfaceName", string2, string);
        }
    }

    public String getRunAs() {
        return this.runAs;
    }

    public void setRunAs(String string) {
        String string2 = this.runAs;
        this.runAs = string;
        if (!EJBReference.comp(string2, string)) {
            this.firePropertyChange("runAs", string2, string);
        }
    }

    public String toString() {
        return this.getEJBRefName();
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<ejb-ref>\n";
        n += 2;
        String string2 = this.getDescription();
        if (string2 != null) {
            string = string + this.indentStr(n) + "<description>" + string2 + "</description>\n";
        }
        string = string + this.indentStr(n) + "<ejb-ref-name>" + this.getEJBRefName() + "</ejb-ref-name>\n";
        string = string + this.indentStr(n) + "<ejb-ref-type>" + this.getEJBRefType() + "</ejb-ref-type>\n";
        string = string + this.indentStr(n) + "<home>" + this.getHomeInterfaceName() + "</home>\n";
        string = string + this.indentStr(n) + "<remote>" + this.getRemoteInterfaceName() + "</remote>\n";
        String string3 = this.getEJBLinkName();
        if (string3 != null) {
            string = string + this.indentStr(n) + "<ejb-link>" + string3 + "</ejb-link>\n";
        }
        string = string + this.indentStr(n -= 2) + "</ejb-ref>\n";
        return string;
    }

    public boolean isLocalLink() {
        return false;
    }
}

