/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.EnvEntryMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class EnvironmentEntry
extends BaseServletDescriptor
implements EnvEntryMBean {
    private static final long serialVersionUID = -4909291169304419758L;
    private String description;
    private String name;
    private String value;
    private String type;

    public EnvironmentEntry() {
    }

    public EnvironmentEntry(EnvEntryMBean envEntryMBean) {
    }

    public EnvironmentEntry(Element element) throws DOMProcessingException {
        this.setDescription(DOMUtils.getOptionalValueByTagName(element, "description"));
        this.setEnvEntryName(DOMUtils.getValueByTagName(element, "env-entry-name"));
        this.setEnvEntryValue(DOMUtils.getOptionalValueByTagName(element, "env-entry-value"));
        this.setEnvEntryType(DOMUtils.getValueByTagName(element, "env-entry-type"));
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!EnvironmentEntry.comp(string2, string)) {
            this.firePropertyChange("description", string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setEnvEntryName(String string) {
        String string2 = this.name;
        this.name = string;
        if (!EnvironmentEntry.comp(string2, string)) {
            this.firePropertyChange("envEntryName", string2, string);
        }
    }

    public String getEnvEntryName() {
        return this.name;
    }

    public void setEnvEntryValue(String string) {
        String string2 = this.value;
        this.value = string;
        if (!EnvironmentEntry.comp(string2, string)) {
            this.firePropertyChange("envEntryValue", string2, string);
        }
    }

    public String getEnvEntryValue() {
        return this.value;
    }

    public void setEnvEntryType(String string) {
        String string2 = this.type;
        this.type = string;
        if (!EnvironmentEntry.comp(string2, string)) {
            this.firePropertyChange("envEntryType", string2, string);
        }
    }

    public String getEnvEntryType() {
        return this.type;
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toString() {
        return "EnvironmentEntry(" + this.hashCode() + "," + this.getEnvEntryName() + ")";
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<env-entry>\n";
        n += 2;
        String string2 = this.getDescription();
        if (string2 != null) {
            string = string + this.indentStr(n) + "<description>" + string2 + "</description>\n";
        }
        string = string + this.indentStr(n) + "<env-entry-name>" + this.getEnvEntryName() + "</env-entry-name>\n";
        String string3 = this.getEnvEntryValue();
        if (string3 != null) {
            string = string + this.indentStr(n) + "<env-entry-value>" + string3 + "</env-entry-value>\n";
        }
        string = string + this.indentStr(n) + "<env-entry-type>" + this.getEnvEntryType() + "</env-entry-type>\n";
        string = string + this.indentStr(n -= 2) + "</env-entry>\n";
        return string;
    }
}

