/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.io.OutputStream;
import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.ErrorPageMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.utils.io.XMLWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class ErrorPageDescriptor
extends BaseServletDescriptor
implements ToXML,
ErrorPageMBean {
    private static final long serialVersionUID = -1138390047099452104L;
    private static final String ERROR_CODE = "error-code";
    private static final String EXCEPTION_TYPE = "exception-type";
    private static final String LOCATION = "location";
    private String eCode;
    private String eType;
    private String location;

    public ErrorPageDescriptor() {
    }

    public ErrorPageDescriptor(ErrorPageMBean errorPageMBean) {
        this(errorPageMBean.getErrorCode(), errorPageMBean.getExceptionType(), errorPageMBean.getLocation());
    }

    public ErrorPageDescriptor(String string, String string2, String string3) {
        this.eCode = string;
        this.eType = string2;
        this.location = string3;
    }

    public ErrorPageDescriptor(Element element) throws DOMProcessingException {
        this.eCode = DOMUtils.getOptionalValueByTagName(element, ERROR_CODE);
        if (this.eCode == null) {
            this.eType = DOMUtils.getOptionalValueByTagName(element, EXCEPTION_TYPE);
        }
        this.location = DOMUtils.getValueByTagName(element, LOCATION);
    }

    public void validate() throws DescriptorValidationException {
        String string;
        boolean bl = true;
        this.removeDescriptorErrors();
        String string2 = this.getErrorCode();
        String string3 = this.getExceptionType();
        if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            this.addDescriptorError("MULTIPLE_DEFINES_ERROR_PAGE", string2, string3);
            bl = false;
        }
        if (string2 != null && string2.length() > 0) {
            this.eCode = string2.trim();
            try {
                Integer.parseInt(this.eCode);
            }
            catch (Exception exception) {
                this.addDescriptorError("INVALID_ERROR_CODE", this.eCode);
                bl = false;
            }
        }
        if ((string = this.getLocation()) == null || string.trim().length() == 0) {
            this.addDescriptorError("NO_ERROR_PAGE_LOCATION");
            bl = false;
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public void setError(String string) {
        try {
            string = string.trim();
            Integer.parseInt(string);
            this.setErrorCode(string);
            this.setExceptionType(null);
        }
        catch (Exception exception) {
            this.setErrorCode(null);
            this.setExceptionType(string);
        }
    }

    public String getError() {
        return this.eCode != null && this.eCode.length() > 0 ? this.eCode : this.eType;
    }

    public String getErrorCode() {
        return this.eCode;
    }

    public void setErrorCode(String string) {
        String string2 = this.eCode;
        this.eCode = string;
        if (!ErrorPageDescriptor.comp(string2, string)) {
            this.firePropertyChange("errorCode", string2, string);
        }
    }

    public String getExceptionType() {
        return this.eType;
    }

    public void setExceptionType(String string) {
        String string2 = this.eType;
        this.eType = string;
        if (!ErrorPageDescriptor.comp(string2, string)) {
            this.firePropertyChange("exceptionType", string2, string);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        String string2 = this.location;
        this.location = string;
        if (!ErrorPageDescriptor.comp(string2, string)) {
            this.firePropertyChange(LOCATION, string2, string);
        }
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<error-page>\n";
        string = this.eCode != null ? string + this.indentStr(n) + "<error-code>" + this.eCode + "</error-code>\n" : string + this.indentStr(n += 2) + "<exception-type>" + this.eType + "</exception-type>\n";
        string = string + this.indentStr(n) + "<location>" + this.location + "</location>\n";
        string = string + this.indentStr(n -= 2) + "</error-page>\n";
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        ErrorPageDescriptor errorPageDescriptor = new ErrorPageDescriptor("401", null, "/404.jsp");
        XMLWriter xMLWriter = new XMLWriter((OutputStream)System.out);
        errorPageDescriptor.toXML(xMLWriter);
        xMLWriter.flush();
    }
}

