/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.FilterMBean;
import weblogic.management.descriptors.webapp.ParameterMBean;
import weblogic.management.descriptors.webapp.UIMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ParameterDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.internal.dd.UIDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class FilterDescriptor
extends BaseServletDescriptor
implements ToXML,
FilterMBean {
    private static final long serialVersionUID = 1549772288002198411L;
    private static final String FILTER_NAME = "filter-name";
    private static final String FILTER_CLASS = "filter-class";
    private static final String INIT_PARAM = "init-param";
    private String filterName;
    private String filterClass;
    private List initParams;
    private UIMBean uiData;

    public FilterDescriptor() {
        this.uiData = new UIDescriptor();
    }

    public FilterDescriptor(Element element) throws DOMProcessingException {
        this.filterName = DOMUtils.getValueByTagName(element, FILTER_NAME);
        this.filterClass = DOMUtils.getOptionalValueByTagName(element, FILTER_CLASS);
        this.uiData = new UIDescriptor(element);
        List list = DOMUtils.getOptionalElementsByTagName(element, INIT_PARAM);
        Iterator iterator = list.iterator();
        this.initParams = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.initParams.add(new ParameterDescriptor((Element)iterator.next()));
        }
    }

    public void validate() throws DescriptorValidationException {
        String string;
        boolean bl = true;
        this.removeDescriptorErrors();
        String string2 = this.getFilterName();
        if (string2 == null || (string2 = string2.trim()).length() == 0) {
            this.addDescriptorError("NO_FILTER_NAME");
            bl = false;
        } else {
            this.setFilterName(string2);
        }
        string2 = this.getFilterClass();
        if (string2 != null) {
            string2 = string2.trim();
            this.setFilterClass(string2);
        }
        if ((string = this.getFilterClass()) == null || string.length() == 0) {
            this.addDescriptorError("NO_FILTER_CLASS", this.getFilterName());
            bl = false;
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public String toString() {
        return this.getFilterName();
    }

    public String getFilterName() {
        return this.filterName != null ? this.filterName : "";
    }

    public void setFilterName(String string) {
        String string2 = this.filterName;
        this.filterName = string;
        if (!FilterDescriptor.comp(string2, string)) {
            this.firePropertyChange("filterName", string2, string);
        }
    }

    public UIMBean getUIData() {
        return this.uiData;
    }

    public void setUIData(UIMBean uIMBean) {
        this.uiData = uIMBean;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String string) {
        String string2 = this.filterClass;
        this.filterClass = string;
        if (!FilterDescriptor.comp(string2, string)) {
            this.firePropertyChange("filterClass", string2, string);
        }
    }

    public ParameterMBean[] getInitParams() {
        if (this.initParams == null) {
            return new ParameterDescriptor[0];
        }
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[this.initParams.size()];
        this.initParams.toArray(parameterDescriptorArray);
        return parameterDescriptorArray;
    }

    public void setInitParams(ParameterMBean[] parameterMBeanArray) {
        ParameterMBean[] parameterMBeanArray2 = this.getInitParams();
        this.initParams = new ArrayList();
        if (parameterMBeanArray == null) {
            return;
        }
        for (int i = 0; i < parameterMBeanArray.length; ++i) {
            this.initParams.add(parameterMBeanArray[i]);
        }
        if (!FilterDescriptor.comp(parameterMBeanArray2, parameterMBeanArray)) {
            this.firePropertyChange("initParams", parameterMBeanArray2, parameterMBeanArray);
        }
    }

    public void addInitParam(ParameterMBean parameterMBean) {
        if (this.initParams == null) {
            this.initParams = new ArrayList();
        }
        this.initParams.add(parameterMBean);
    }

    public void removeInitParam(ParameterMBean parameterMBean) {
        if (this.initParams == null) {
            return;
        }
        this.initParams.remove(parameterMBean);
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<filter>\n";
        n += 2;
        if (this.uiData != null) {
            String string2 = this.uiData.getSmallIconFileName();
            Object object = this.uiData.getLargeIconFileName();
            if (string2 != null || object != null) {
                string = string + this.indentStr(n) + "<icon>\n";
                if (string2 != null) {
                    string = string + this.indentStr(n + 2) + "<small-icon>" + (String)string2 + "</small-icon>\n";
                }
                if (object != null) {
                    string = string + this.indentStr(n + 2) + "<large-icon>" + (String)object + "</large-icon>\n";
                }
                string = string + this.indentStr(n) + "</icon>\n";
            }
        }
        string = string + this.indentStr(n) + "<filter-name>" + this.filterName + "</filter-name>\n";
        if (this.uiData != null) {
            if (this.uiData.getDisplayName() != null) {
                string = string + this.indentStr(n) + "<display-name>" + this.uiData.getDisplayName() + "</display-name>\n";
            }
            if (this.uiData.getDescription() != null) {
                string = string + this.indentStr(n) + "<description>" + this.uiData.getDescription() + "</description>\n";
            }
        }
        string = string + this.indentStr(n) + "<filter-class>" + this.filterClass + "</filter-class>\n";
        if (this.initParams != null) {
            for (Object object : this.initParams) {
                string = string + this.indentStr(n) + "<init-param>\n";
                string = string + this.indentStr(n += 2) + "<param-name>" + ((ParameterDescriptor)object).getParamName() + "</param-name>\n";
                string = string + this.indentStr(n) + "<param-value>" + ((ParameterDescriptor)object).getParamValue() + "</param-value>\n";
                String string3 = ((ParameterDescriptor)object).getDescription();
                if (string3 != null) {
                    string = string + this.indentStr(n) + "<description>" + string3 + "</description>\n";
                }
                string = string + this.indentStr(n -= 2) + "</init-param>\n";
            }
        }
        string = string + this.indentStr(n -= 2) + "</filter>\n";
        return string;
    }
}

