/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.FilterMBean;
import weblogic.management.descriptors.webapp.FilterMappingMBean;
import weblogic.management.descriptors.webapp.ServletMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.internal.dd.WebAppDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class FilterMappingDescriptor
extends BaseServletDescriptor
implements ToXML,
FilterMappingMBean {
    private static final long serialVersionUID = 3697699795239081065L;
    private static final String FILTER_NAME = "filter-name";
    private static final String URL_PATTERN = "url-pattern";
    private static final String SERVLET_NAME = "servlet-name";
    private FilterMBean filter;
    private String urlPattern;
    private ServletMBean servlet;
    private String servletNameLink;

    public FilterMappingDescriptor() {
    }

    public FilterMappingDescriptor(FilterMappingMBean filterMappingMBean) {
        this.setFilter(filterMappingMBean.getFilter());
        this.setUrlPattern(filterMappingMBean.getUrlPattern());
        this.setServlet(filterMappingMBean.getServlet());
    }

    public FilterMappingDescriptor(WebAppDescriptor webAppDescriptor, Element element) throws DOMProcessingException {
        String string = DOMUtils.getValueByTagName(element, FILTER_NAME);
        FilterMBean[] filterMBeanArray = webAppDescriptor.getFilters();
        if (filterMBeanArray != null) {
            for (int i = 0; i < filterMBeanArray.length; ++i) {
                if (!filterMBeanArray[i].getFilterName().equals(string)) continue;
                this.filter = filterMBeanArray[i];
            }
        }
        this.urlPattern = DOMUtils.getOptionalValueByTagName(element, URL_PATTERN);
        String string2 = DOMUtils.getOptionalValueByTagName(element, SERVLET_NAME);
        ServletMBean[] servletMBeanArray = webAppDescriptor.getServlets();
        if (servletMBeanArray != null) {
            for (int i = 0; i < servletMBeanArray.length; ++i) {
                if (!servletMBeanArray[i].getServletName().equals(string2)) continue;
                this.servlet = servletMBeanArray[i];
            }
        } else {
            this.servletNameLink = string2;
        }
        if (this.urlPattern != null && this.urlPattern.length() > 0 && (this.servlet != null || this.servletNameLink != null)) {
            this.addDescriptorError("MULTIPLE_DEFINES_FILTER_MAPPING", string);
        }
        if ((this.urlPattern == null || this.urlPattern.length() == 0) && this.servlet == null && this.servletNameLink == null) {
            this.addDescriptorError("NO_FILTER_MAPPING_DEF", string);
        }
    }

    public FilterMBean getFilter() {
        return this.filter;
    }

    public void setFilter(FilterMBean filterMBean) {
        FilterMBean filterMBean2 = this.filter;
        this.filter = filterMBean;
        if (!FilterMappingDescriptor.comp(filterMBean2, filterMBean)) {
            this.firePropertyChange("filter", filterMBean2, filterMBean);
        }
    }

    public ServletMBean getServlet() {
        return this.servlet;
    }

    public void setServlet(ServletMBean servletMBean) {
        ServletMBean servletMBean2 = this.servlet;
        this.servlet = servletMBean;
        if (!FilterMappingDescriptor.comp(servletMBean2, servletMBean)) {
            this.firePropertyChange("servet", servletMBean2, servletMBean);
        }
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String string) {
        String string2 = this.urlPattern;
        this.urlPattern = string;
        if (!FilterMappingDescriptor.comp(string2, this.urlPattern)) {
            this.firePropertyChange("urlPattern", string2, this.urlPattern);
        }
    }

    public void validate() throws DescriptorValidationException {
        boolean bl = true;
        this.removeDescriptorErrors();
        if (this.getFilter() == null) {
            this.addDescriptorError("NO_FILTER_NAME");
            bl = false;
        }
        ServletMBean servletMBean = this.getServlet();
        String string = this.getUrlPattern();
        if ((servletMBean != null || this.servletNameLink != null) && string != null && string.length() > 0) {
            this.addDescriptorError("MULTIPLE_DEFINES_FILTER_MAPPING", servletMBean.getServletName());
            bl = false;
        }
        if (servletMBean == null && this.servletNameLink == null && (string == null || string.length() == 0)) {
            this.addDescriptorError("NO_FILTER_MAPPING_DEF");
            bl = false;
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        ServletMBean servletMBean;
        String string = "";
        string = string + this.indentStr(n) + "<filter-mapping>\n";
        n += 2;
        FilterMBean filterMBean = this.getFilter();
        if (filterMBean != null) {
            string = string + this.indentStr(n) + "<filter-name>" + filterMBean.getFilterName() + "</filter-name>\n";
        }
        if ((servletMBean = this.getServlet()) != null) {
            String string2 = servletMBean.getServletName();
            string = string + this.indentStr(n) + "<servlet-name>" + string2 + "</servlet-name>\n";
        } else {
            string = this.servletNameLink != null ? string + this.indentStr(n) + "<servlet-name>" + this.servletNameLink + "</servlet-name>\n" : string + this.indentStr(n) + "<url-pattern>" + this.getUrlPattern() + "</url-pattern>\n";
        }
        string = string + this.indentStr(n -= 2) + "</filter-mapping>\n";
        return string;
    }
}

