/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.ServletMBean;
import weblogic.management.descriptors.webappext.InitAsMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.WebAppDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class InitAsDescriptor
extends BaseServletDescriptor
implements InitAsMBean {
    private String servletName;
    private String principalName;
    private ServletMBean servlet;
    private WebAppDescriptor wad;

    public InitAsDescriptor(WebAppDescriptor webAppDescriptor, Element element) throws DOMProcessingException {
        this.wad = webAppDescriptor;
        this.setServletName(DOMUtils.getValueByTagName(element, "servlet-name"));
        this.setPrincipalName(DOMUtils.getValueByTagName(element, "principal-name"));
    }

    public void setServletName(String string) throws DOMProcessingException {
        ServletMBean[] servletMBeanArray;
        String string2 = this.servletName;
        this.servletName = string;
        if (!InitAsDescriptor.comp(string2, string)) {
            this.firePropertyChange("servletName", string2, string);
        }
        if ((servletMBeanArray = this.wad.getServlets()) == null) {
            HTTPLogger.logServletNotFound((String)string);
            throw new DOMProcessingException("Servlet with name " + string + " not defined in web.xml");
        }
        for (int i = 0; i < servletMBeanArray.length; ++i) {
            if (servletMBeanArray[i] == null || !string.equals(servletMBeanArray[i].getServletName())) continue;
            this.servlet = servletMBeanArray[i];
            break;
        }
        if (this.servlet == null) {
            HTTPLogger.logServletNotFound((String)string);
            throw new DOMProcessingException("Servlet with name " + string + " not defined in web.xml");
        }
        this.setIdentity();
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServlet(ServletMBean servletMBean) {
        this.servlet = servletMBean;
        this.servletName = servletMBean.getName();
        this.setIdentity();
    }

    public ServletMBean getServlet() {
        return this.servlet;
    }

    public void setPrincipalName(String string) {
        String string2 = this.principalName;
        this.principalName = string;
        if (!InitAsDescriptor.comp(string2, string)) {
            this.firePropertyChange("principalName", string2, string);
        }
        this.setIdentity();
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setIdentity() {
        if (this.servlet != null && this.principalName != null) {
            this.servlet.setInitAs(this.principalName);
        }
    }

    public String toString() {
        return this.getServletName();
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<init-as>\n";
        string = string + this.indentStr(n += 2) + "<servlet-name>" + this.getServletName() + "</servlet-name>\n";
        string = string + this.indentStr(n) + "<principal-name>" + this.getPrincipalName() + "</principal-name>\n";
        string = string + this.indentStr(n -= 2) + "</init-as>\n";
        return string;
    }
}

