/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webappext.InputCharsetDescriptorMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class InputCharsetDescriptor
extends BaseServletDescriptor
implements InputCharsetDescriptorMBean {
    private static final long serialVersionUID = 379779722485658071L;
    private static String RESOURCE_PATH = "resource-path";
    private static String JAVA_NAME = "java-charset-name";
    String resourcePath;
    String javaName;

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String string) {
        String string2 = this.resourcePath;
        this.resourcePath = string;
        if (!InputCharsetDescriptor.comp(string2, string)) {
            this.firePropertyChange("resourcePath", string2, string);
        }
    }

    public String getJavaCharsetName() {
        return this.javaName;
    }

    public void setJavaCharsetName(String string) {
        String string2 = this.javaName;
        this.javaName = string;
        if (!InputCharsetDescriptor.comp(string2, string)) {
            this.firePropertyChange("javaCharsetName", string2, string);
        }
    }

    public InputCharsetDescriptor() {
    }

    public InputCharsetDescriptor(Element element) throws DOMProcessingException {
        this.resourcePath = DOMUtils.getValueByTagName(element, RESOURCE_PATH);
        this.javaName = DOMUtils.getValueByTagName(element, JAVA_NAME);
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.indentStr(n));
        stringBuffer.append("<input-charset>\n");
        stringBuffer.append(this.indentStr(n += 2));
        stringBuffer.append("<resource-path>");
        stringBuffer.append(this.resourcePath);
        stringBuffer.append("</resource-path>\n");
        stringBuffer.append(this.indentStr(n));
        stringBuffer.append("<java-charset-name>");
        stringBuffer.append(this.javaName);
        stringBuffer.append("</java-charset-name>\n");
        stringBuffer.append(this.indentStr(n -= 2));
        stringBuffer.append("</input-charset>\n");
        return stringBuffer.toString();
    }
}

