/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.ListenerMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class ListenerDescriptor
extends BaseServletDescriptor
implements ToXML,
ListenerMBean {
    private static final long serialVersionUID = 9012728722776252126L;
    private static final String LISTENER_CLASS = "listener-class";
    private String listenerClassName;

    public ListenerDescriptor() {
    }

    public ListenerDescriptor(ListenerMBean listenerMBean) {
        this(listenerMBean.getListenerClassName());
    }

    public ListenerDescriptor(String string) {
        this.listenerClassName = string;
    }

    public ListenerDescriptor(Element element) throws DOMProcessingException {
        this.listenerClassName = DOMUtils.getValueByTagName(element, LISTENER_CLASS);
    }

    public String getListenerClassName() {
        return this.listenerClassName;
    }

    public void setListenerClassName(String string) {
        String string2 = this.listenerClassName;
        this.listenerClassName = string;
        if (!ListenerDescriptor.comp(string2, string)) {
            this.firePropertyChange("listenerClassName", string2, string);
        }
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
        if (this.listenerClassName == null) {
            this.addDescriptorError("NO_LISTENER_CLASS");
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        if (this.listenerClassName != null) {
            string = string + this.indentStr(n) + "<listener>\n";
            string = string + this.indentStr(n += 2) + "<listener-class>" + this.listenerClassName + "</listener-class>\n";
            string = string + this.indentStr(n -= 2) + "</listener>\n";
        }
        return string;
    }
}

