/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.LoginConfigMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class LoginDescriptor
extends BaseServletDescriptor
implements ToXML,
LoginConfigMBean {
    private static final long serialVersionUID = -6175838651266572918L;
    private static final String AUTH_METHOD = "auth-method";
    private static final String REALM_NAME = "realm-name";
    private static final String FORM_LOGIN_CONFIG = "form-login-config";
    private static final String FORM_LOGIN_PAGE = "form-login-page";
    private static final String FORM_ERROR_PAGE = "form-error-page";
    public static final String AM_NONE = "";
    public static final String AM_BASIC = "BASIC";
    public static final String AM_DIGEST = "DIGEST";
    public static final String AM_FORM = "FORM";
    public static final String AM_CLIENT_CERT = "CLIENT-CERT";
    String authMethod;
    String realmName;
    String loginPage;
    String errorPage;

    public LoginDescriptor() {
    }

    public LoginDescriptor(LoginConfigMBean loginConfigMBean) {
        this.setAuthMethod(loginConfigMBean.getAuthMethod());
        this.setRealmName(loginConfigMBean.getRealmName());
        this.setLoginPage(loginConfigMBean.getLoginPage());
        this.setErrorPage(loginConfigMBean.getErrorPage());
    }

    public LoginDescriptor(Element element) throws DOMProcessingException {
        Element element2;
        this.realmName = DOMUtils.getOptionalValueByTagName(element, REALM_NAME);
        this.authMethod = DOMUtils.getOptionalValueByTagName(element, AUTH_METHOD);
        if (this.authMethod != null) {
            if (AM_BASIC.equalsIgnoreCase(this.authMethod)) {
                this.authMethod = AM_BASIC;
            } else if (AM_CLIENT_CERT.equalsIgnoreCase(this.authMethod)) {
                this.authMethod = AM_CLIENT_CERT;
            } else if (AM_DIGEST.equalsIgnoreCase(this.authMethod)) {
                this.authMethod = AM_DIGEST;
            } else if (AM_FORM.equalsIgnoreCase(this.authMethod)) {
                this.authMethod = AM_FORM;
            }
        }
        if ((element2 = DOMUtils.getOptionalElementByTagName(element, FORM_LOGIN_CONFIG)) != null) {
            this.loginPage = DOMUtils.getValueByTagName(element2, FORM_LOGIN_PAGE);
            this.errorPage = DOMUtils.getValueByTagName(element2, FORM_ERROR_PAGE);
            if (this.loginPage != null && !this.loginPage.startsWith("/")) {
                this.loginPage = "/" + this.loginPage;
            }
            if (this.errorPage != null && !this.errorPage.startsWith("/")) {
                this.errorPage = "/" + this.errorPage;
            }
        }
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String string) {
        String string2 = this.getAuthMethod();
        this.authMethod = string;
        if (!LoginDescriptor.comp(string2, this.getAuthMethod())) {
            this.firePropertyChange("authMethod", string2, this.getAuthMethod());
        }
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String string) {
        String string2 = this.realmName;
        this.realmName = string;
        if (!LoginDescriptor.comp(string2, string)) {
            this.firePropertyChange("realmName", string2, string);
        }
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public void setLoginPage(String string) {
        String string2 = this.loginPage;
        this.loginPage = string;
        if (!LoginDescriptor.comp(string2, string)) {
            this.firePropertyChange("loginPage", string2, string);
        }
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public void setErrorPage(String string) {
        String string2 = this.errorPage;
        this.errorPage = string;
        if (!LoginDescriptor.comp(string2, string)) {
            this.firePropertyChange("errorPage", string2, string);
        }
    }

    public void validate() throws DescriptorValidationException {
        boolean bl = true;
        this.removeDescriptorErrors();
        if (this.loginPage != null) {
            this.loginPage = this.loginPage.trim();
        }
        if (this.errorPage != null) {
            this.errorPage = this.errorPage.trim();
        }
        if (this.loginPage != null && this.loginPage.length() == 0) {
            this.addDescriptorError("NO_LOGIN_PAGE");
            bl = false;
        }
        if (this.errorPage != null && this.errorPage.length() == 0) {
            this.addDescriptorError("NO_LOGIN_ERROR_PAGE");
            bl = false;
        }
        if (bl) {
            if (this.loginPage != null && this.errorPage == null) {
                this.addDescriptorError("NO_LOGIN_ERROR_PAGE");
                bl = false;
            } else if (this.errorPage != null && this.loginPage == null) {
                this.addDescriptorError("NO_LOGIN_PAGE");
                bl = false;
            }
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = AM_NONE;
        String string2 = this.getAuthMethod();
        if (string2 == null && this.realmName == null && this.loginPage == null && this.errorPage == null) {
            return string;
        }
        string = string + this.indentStr(n) + "<login-config>\n";
        n += 2;
        if (string2 != null) {
            string = string + this.indentStr(n) + "<auth-method>" + string2 + "</auth-method>\n";
        }
        if (this.realmName != null) {
            string = string + this.indentStr(n) + "<realm-name>" + this.realmName + "</realm-name>\n";
        }
        if (this.authMethod == AM_FORM && this.loginPage != null && this.errorPage != null) {
            string = string + this.indentStr(n) + "<form-login-config>\n";
            string = string + this.indentStr(n += 2) + "<form-login-page>" + this.loginPage + "</form-login-page>\n";
            string = string + this.indentStr(n) + "<form-error-page>" + this.errorPage + "</form-error-page>\n";
            string = string + this.indentStr(n -= 2) + "</form-login-config>\n";
        }
        string = string + this.indentStr(n -= 2) + "</login-config>\n";
        return string;
    }

    public String toString() {
        return "LoginDescriptor(method=" + this.getAuthMethod() + ", realm=" + this.realmName + ", login=" + this.loginPage + ", error=" + this.errorPage + ")";
    }
}

