/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.MimeMappingMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class MimeMappingDescriptor
extends BaseServletDescriptor
implements ToXML,
MimeMappingMBean {
    private static final long serialVersionUID = -7123219540911766475L;
    private static final String EXTENSION = "extension";
    private static final String MIME_TYPE = "mime-type";
    private String extension;
    private String mimeType;

    public MimeMappingDescriptor() {
        this("", "");
    }

    public MimeMappingDescriptor(MimeMappingMBean mimeMappingMBean) {
        this(mimeMappingMBean.getExtension(), mimeMappingMBean.getMimeType());
    }

    public MimeMappingDescriptor(String string, String string2) {
        this.extension = string;
        this.mimeType = string2;
    }

    public MimeMappingDescriptor(Element element) throws DOMProcessingException {
        this.extension = DOMUtils.getValueByTagName(element, EXTENSION);
        this.mimeType = DOMUtils.getValueByTagName(element, MIME_TYPE);
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String string) {
        String string2 = this.extension;
        this.extension = string;
        if (!MimeMappingDescriptor.comp(string2, string)) {
            this.firePropertyChange(EXTENSION, string2, string);
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        String string2 = this.mimeType;
        this.mimeType = string;
        if (!MimeMappingDescriptor.comp(string2, string)) {
            this.firePropertyChange("mimeType", string2, string);
        }
    }

    public void validate() throws DescriptorValidationException {
        boolean bl = true;
        this.removeDescriptorErrors();
        if (this.extension == null || (this.extension = this.extension.trim()).length() == 0) {
            this.addDescriptorError("NO_MIME_EXTENSION", this.mimeType);
            bl = false;
        }
        if (this.mimeType == null || (this.mimeType = this.mimeType.trim()).length() == 0) {
            this.addDescriptorError("NO_MIME_TYPE", this.extension);
            bl = false;
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<mime-mapping>\n";
        string = string + this.indentStr(n += 2) + "<extension>" + this.extension + "</extension>\n";
        string = string + this.indentStr(n) + "<mime-type>" + this.mimeType + "</mime-type>\n";
        string = string + this.indentStr(n -= 2) + "</mime-mapping>\n";
        return string;
    }
}

