/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.ParameterMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class ParameterDescriptor
extends BaseServletDescriptor
implements ToXML,
ParameterMBean {
    private static final long serialVersionUID = 4406607312692360385L;
    private static final String PARAM_NAME = "param-name";
    private static final String PARAM_VALUE = "param-value";
    private static final String DESCRIPTION = "description";
    private String description;
    private String paramName;
    private String paramValue;

    public ParameterDescriptor() {
        this(null, null, null);
    }

    public ParameterDescriptor(ParameterMBean parameterMBean) {
        this(parameterMBean.getParamName(), parameterMBean.getParamValue(), parameterMBean.getDescription());
    }

    public ParameterDescriptor(String string, String string2, String string3) {
        this.description = string3;
        this.paramName = string;
        this.paramValue = string2;
    }

    public ParameterDescriptor(Element element) throws DOMProcessingException {
        this.description = DOMUtils.getOptionalValueByTagName(element, DESCRIPTION);
        this.paramName = DOMUtils.getValueByTagName(element, PARAM_NAME);
        this.paramValue = DOMUtils.getValueByTagName(element, PARAM_VALUE);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!ParameterDescriptor.comp(string2, string)) {
            this.firePropertyChange(DESCRIPTION, string2, string);
        }
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String string) {
        String string2 = this.paramName;
        this.paramName = string;
        if (!ParameterDescriptor.comp(string2, string)) {
            this.firePropertyChange("paramName", string2, string);
        }
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public void setParamValue(String string) {
        String string2 = this.paramValue;
        this.paramValue = string;
        if (!ParameterDescriptor.comp(string2, string)) {
            this.firePropertyChange("paramValue", string2, string);
        }
    }

    public void validate() throws DescriptorValidationException {
        boolean bl = true;
        this.removeDescriptorErrors();
        if (this.paramName == null || this.paramName.length() == 0) {
            this.addDescriptorError("NO_PARAM_NAME", this.paramValue);
            bl = false;
        }
        if (this.paramValue == null) {
            this.addDescriptorError("NO_PARAM_VALUE", this.paramName);
            bl = false;
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<context-param>\n";
        n += 2;
        String string2 = this.paramValue;
        if (string2 == null) {
            string2 = "";
        }
        string = string + this.indentStr(n) + "<param-name>" + this.paramName + "</param-name>\n";
        string = string + this.indentStr(n) + "<param-value>" + string2 + "</param-value>\n";
        if (this.description != null && this.description.length() > 0) {
            string = string + this.indentStr(n) + "<description>" + this.description + "</description>\n";
        }
        string = string + this.indentStr(n -= 2) + "</context-param>\n";
        return string;
    }
}

