/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webappext.PreprocessorMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class PreprocessorDescriptor
extends BaseServletDescriptor
implements ToXML,
PreprocessorMBean {
    private static final String PREPROCESSOR_NAME = "preprocessor-name";
    private static final String PREPROCESSOR_CLASS = "preprocessor-class";
    private static boolean debug = false;
    private String preprocessorName;
    private String preprocessorClass;

    public PreprocessorDescriptor() {
    }

    public PreprocessorDescriptor(PreprocessorMBean preprocessorMBean) {
        this.setPreprocessorName(preprocessorMBean.getPreprocessorName());
        this.setPreprocessorClass(preprocessorMBean.getPreprocessorClass());
    }

    public PreprocessorDescriptor(Element element) throws DOMProcessingException {
        this.preprocessorName = DOMUtils.getValueByTagName(element, PREPROCESSOR_NAME);
        this.preprocessorClass = DOMUtils.getValueByTagName(element, PREPROCESSOR_CLASS);
        if (this.preprocessorClass == null) {
            throw new DOMProcessingException("Preprocessor node does not contain preprocessor-class node");
        }
    }

    public String getPreprocessorName() {
        return this.preprocessorName;
    }

    public void setPreprocessorName(String string) {
        String string2 = this.preprocessorName;
        this.preprocessorName = string;
        if (!PreprocessorDescriptor.comp(string2, string)) {
            this.firePropertyChange("preprocessorName", string2, string);
        }
    }

    public String getPreprocessorClass() {
        return this.preprocessorClass;
    }

    public void setPreprocessorClass(String string) {
        String string2 = this.preprocessorClass;
        this.preprocessorClass = string;
        if (!PreprocessorDescriptor.comp(string2, string)) {
            this.firePropertyChange("preprocessorClass", string2, string);
        }
    }

    public void validate() throws DescriptorValidationException {
        boolean bl = true;
        this.removeDescriptorErrors();
        String string = this.getPreprocessorName();
        if (string == null || (string = string.trim()).length() == 0) {
            this.addDescriptorError("NO_PREPROCESSOR_NAME");
            bl = false;
        } else {
            this.setPreprocessorName(string);
        }
        string = this.getPreprocessorClass();
        if (string == null) {
            this.addDescriptorError("NO_PREPROCESSOR_CLASS", this.getPreprocessorName() == null ? "" : this.getPreprocessorName());
            bl = false;
        }
        if (string != null) {
            string = string.trim();
            this.setPreprocessorClass(string);
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.indentStr(n));
        stringBuffer.append("<preprocessor>\n");
        stringBuffer.append(this.indentStr(n + 2));
        stringBuffer.append("<preprocessor-name>");
        stringBuffer.append(this.getPreprocessorName());
        stringBuffer.append("</preprocessor-name>\n");
        stringBuffer.append(this.indentStr(n + 2));
        stringBuffer.append("<preprocessor-class>");
        stringBuffer.append(this.getPreprocessorClass());
        stringBuffer.append("</preprocessor-class>\n");
        stringBuffer.append(this.indentStr(n));
        stringBuffer.append("</preprocessor>");
        if (debug) {
            System.out.println(stringBuffer);
        }
        return stringBuffer.toString();
    }
}

