/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webappext.PreprocessorMBean;
import weblogic.management.descriptors.webappext.PreprocessorMappingMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.internal.dd.WLWebAppDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class PreprocessorMappingDescriptor
extends BaseServletDescriptor
implements PreprocessorMappingMBean,
ToXML {
    private static final String PREPROCESSOR_NAME = "preprocessor-name";
    private static final String URL_PATTERN = "url-pattern";
    private PreprocessorMBean preprocessor;
    private String urlPattern;
    private static boolean debug = true;

    public PreprocessorMappingDescriptor() {
        this.preprocessor = null;
        this.urlPattern = "";
    }

    public PreprocessorMappingDescriptor(WLWebAppDescriptor wLWebAppDescriptor, PreprocessorMappingMBean preprocessorMappingMBean) {
        this(preprocessorMappingMBean.getPreprocessor(), preprocessorMappingMBean.getURLPattern());
    }

    public PreprocessorMappingDescriptor(PreprocessorMBean preprocessorMBean, String string) {
        this.preprocessor = preprocessorMBean;
        this.urlPattern = string;
    }

    public PreprocessorMappingDescriptor(WLWebAppDescriptor wLWebAppDescriptor, Element element) throws DOMProcessingException {
        this.urlPattern = DOMUtils.getValueByTagName(element, URL_PATTERN);
        String string = DOMUtils.getValueByTagName(element, PREPROCESSOR_NAME);
        if (wLWebAppDescriptor != null) {
            this.setPreprocessor(wLWebAppDescriptor, string);
        }
    }

    public void setPreprocessor(WLWebAppDescriptor wLWebAppDescriptor, String string) {
        if (wLWebAppDescriptor == null) {
            HTTPLogger.logPreprocessorNotFound((String)string);
            return;
        }
        if (string == null) {
            HTTPLogger.logPreprocessorNotFound((String)"null");
            return;
        }
        PreprocessorMBean[] preprocessorMBeanArray = wLWebAppDescriptor.getPreprocessors();
        if (preprocessorMBeanArray == null) {
            return;
        }
        for (int i = 0; i < preprocessorMBeanArray.length; ++i) {
            if (preprocessorMBeanArray[i] == null || !string.equals(preprocessorMBeanArray[i].getPreprocessorName())) continue;
            this.preprocessor = preprocessorMBeanArray[i];
            break;
        }
        if (this.preprocessor == null) {
            HTTPLogger.logPreprocessorNotFound((String)string);
            return;
        }
    }

    public PreprocessorMBean getPreprocessor() {
        return this.preprocessor;
    }

    public void setPreprocessor(PreprocessorMBean preprocessorMBean) {
        PreprocessorMBean preprocessorMBean2 = this.preprocessor;
        this.preprocessor = preprocessorMBean;
        if (!PreprocessorMappingDescriptor.comp(preprocessorMBean2, preprocessorMBean)) {
            this.firePropertyChange("preprocessor", preprocessorMBean2, preprocessorMBean);
        }
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public void setURLPattern(String string) {
        String string2 = this.urlPattern;
        this.urlPattern = string;
        if (!PreprocessorMappingDescriptor.comp(string2, string)) {
            this.firePropertyChange("urlPattern", string2, string);
        }
    }

    public void validate() throws DescriptorValidationException {
        boolean bl = true;
        this.removeDescriptorErrors();
        PreprocessorMBean preprocessorMBean = this.getPreprocessor();
        String string = this.getURLPattern();
        if (string != null) {
            string = string.trim();
            this.setURLPattern(string);
        }
        if (string == null || string.length() == 0) {
            this.addDescriptorError("NO_PREPROCESSOR_URL_PATTERN", preprocessorMBean == null ? "" : preprocessorMBean.getPreprocessorName());
            bl = false;
        }
        if (preprocessorMBean == null) {
            this.addDescriptorError("NO_MAPPING_PREPROCESSOR_NAME", string);
            bl = false;
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        PreprocessorMBean preprocessorMBean = this.getPreprocessor();
        String string = preprocessorMBean == null ? "" : preprocessorMBean.getPreprocessorName();
        stringBuffer.append(this.indentStr(n));
        stringBuffer.append(this.indentStr(n + 2));
        stringBuffer.append("<preprocessor-mapping>\n");
        stringBuffer.append(this.indentStr(n + 2));
        stringBuffer.append("<preprocessor-name>");
        stringBuffer.append(string);
        stringBuffer.append("</preprocessor-name>\n");
        stringBuffer.append(this.indentStr(n + 2));
        stringBuffer.append("<url-pattern>");
        stringBuffer.append(this.urlPattern);
        stringBuffer.append("</url-pattern>\n");
        stringBuffer.append(this.indentStr(n));
        stringBuffer.append("</preprocessor-mapping>\n");
        if (debug) {
            System.err.println(stringBuffer);
        }
        return stringBuffer.toString();
    }
}

