/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.WebElementMBean;
import weblogic.management.descriptors.XMLElementMBean;
import weblogic.management.descriptors.webapp.EjbRefMBean;
import weblogic.management.descriptors.webapp.ResourceRefMBean;
import weblogic.management.descriptors.webappext.EjbReferenceDescriptionMBean;
import weblogic.management.descriptors.webappext.ReferenceDescriptorMBean;
import weblogic.management.descriptors.webappext.ResourceDescriptionMBean;
import weblogic.management.descriptors.weblogic.ResourceEnvDescriptionMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.EjbReferenceDescription;
import weblogic.servlet.internal.dd.ResourceDescription;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.internal.dd.WebAppDescriptor;
import weblogic.utils.AssertionError;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class ReferenceDescriptor
extends BaseServletDescriptor
implements ToXML,
ReferenceDescriptorMBean {
    private static final long serialVersionUID = 5931465487784198233L;
    private static final String EJB_REF_DESCRIPTION = "ejb-reference-description";
    private static final String EJB_REF_NAME = "ejb-ref-name";
    private static final String JNDI_NAME = "jndi-name";
    private static final String RESOURCE_DESCRIPTION = "resource-description";
    private static final String RESOURCE_ENV_DESCRIPTION = "resource-env-description";
    private static final String RES_ENV_REF_NAME = "res-env-ref-name";
    private static final String RES_REF_NAME = "res-ref-name";
    private ArrayList resRefs = new ArrayList();
    private ArrayList resEnvRefs = new ArrayList();
    private ArrayList ejbRefs = new ArrayList();
    private static String resRefErr = "Can't define resource-definition in weblogic.xml because web.xml has no matching resource-ref";
    private static String EJBRefErr = "Can't define ejb-reference-description in weblogic.xml because web.xml has no matching ejb-ref";

    public ReferenceDescriptor() {
    }

    public ReferenceDescriptor(ReferenceDescriptorMBean referenceDescriptorMBean) {
        XMLElementMBean xMLElementMBean;
        XMLElementMBean xMLElementMBean2;
        ResourceDescriptionMBean[] resourceDescriptionMBeanArray = referenceDescriptorMBean.getResourceReferences();
        this.resRefs.clear();
        for (int i = 0; i < resourceDescriptionMBeanArray.length; ++i) {
            ResourceDescriptionMBean resourceDescriptionMBean = resourceDescriptionMBeanArray[i];
            ResourceDescription resourceDescription = new ResourceDescription();
            resourceDescription.setResourceReference(resourceDescriptionMBean.getResourceReference());
            resourceDescription.setJndiName(resourceDescriptionMBean.getJndiName());
            this.resRefs.add(resourceDescription);
        }
        ResourceEnvDescriptionMBean[] resourceEnvDescriptionMBeanArray = referenceDescriptorMBean.getResourceEnvReferences();
        this.resEnvRefs.clear();
        for (int i = 0; i < resourceEnvDescriptionMBeanArray.length; ++i) {
            xMLElementMBean2 = resourceEnvDescriptionMBeanArray[i];
            xMLElementMBean = ReferenceDescriptor.newResourceEnvDescriptionMBean();
            xMLElementMBean.setResEnvRefName(xMLElementMBean2.getResEnvRefName());
            xMLElementMBean.setJNDIName(xMLElementMBean2.getJNDIName());
            this.resEnvRefs.add(xMLElementMBean);
        }
        EjbReferenceDescriptionMBean[] ejbReferenceDescriptionMBeanArray = referenceDescriptorMBean.getEjbReferences();
        this.ejbRefs.clear();
        for (int i = 0; i < ejbReferenceDescriptionMBeanArray.length; ++i) {
            xMLElementMBean2 = ejbReferenceDescriptionMBeanArray[i];
            xMLElementMBean = new EjbReferenceDescription();
            ((EjbReferenceDescription)xMLElementMBean).setEjbReference(xMLElementMBean2.getEjbReference());
            ((EjbReferenceDescription)xMLElementMBean).setJndiName(xMLElementMBean2.getJndiName());
            this.ejbRefs.add(xMLElementMBean);
        }
    }

    private static ResourceEnvDescriptionMBean newResourceEnvDescriptionMBean() {
        try {
            return (ResourceEnvDescriptionMBean)Class.forName("weblogic.management.descriptors.weblogic.ResourceEnvDescriptionMBeanImpl").newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Throwable)classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Throwable)instantiationException);
        }
    }

    public ReferenceDescriptor(WebAppDescriptor webAppDescriptor, Element element) throws DOMProcessingException {
        WebElementMBean webElementMBean;
        BaseServletDescriptor baseServletDescriptor;
        String string;
        Object object;
        List list = DOMUtils.getOptionalElementsByTagName(element, RESOURCE_DESCRIPTION);
        this.resRefs.clear();
        for (Element element2 : list) {
            object = DOMUtils.getValueByTagName(element2, RES_REF_NAME);
            string = DOMUtils.getValueByTagName(element2, JNDI_NAME);
            baseServletDescriptor = new ResourceDescription();
            webElementMBean = this.findResRef(webAppDescriptor, (String)object);
            if (webElementMBean == null) continue;
            ((ResourceDescription)baseServletDescriptor).setResourceReference((ResourceRefMBean)webElementMBean);
            ((ResourceDescription)baseServletDescriptor).setJndiName(string);
            this.resRefs.add(baseServletDescriptor);
        }
        list = DOMUtils.getOptionalElementsByTagName(element, RESOURCE_ENV_DESCRIPTION);
        this.resEnvRefs.clear();
        for (Element element2 : list) {
            object = ReferenceDescriptor.newResourceEnvDescriptionMBean();
            object.setResEnvRefName(DOMUtils.getValueByTagName(element2, RES_ENV_REF_NAME));
            object.setJNDIName(DOMUtils.getValueByTagName(element2, JNDI_NAME));
            this.resEnvRefs.add(object);
        }
        list = DOMUtils.getOptionalElementsByTagName(element, EJB_REF_DESCRIPTION);
        this.ejbRefs.clear();
        for (Element element2 : list) {
            object = DOMUtils.getValueByTagName(element2, EJB_REF_NAME);
            string = DOMUtils.getValueByTagName(element2, JNDI_NAME);
            baseServletDescriptor = new EjbReferenceDescription();
            webElementMBean = this.findEjbRef(webAppDescriptor, (String)object);
            if (webElementMBean == null) continue;
            ((EjbReferenceDescription)baseServletDescriptor).setEjbReference((EjbRefMBean)webElementMBean);
            ((EjbReferenceDescription)baseServletDescriptor).setJndiName(string);
            this.ejbRefs.add(baseServletDescriptor);
        }
    }

    private ResourceRefMBean findResRef(WebAppDescriptor webAppDescriptor, String string) {
        ResourceRefMBean[] resourceRefMBeanArray = webAppDescriptor.getResourceReferences();
        if (resourceRefMBeanArray == null) {
            HTTPLogger.logNoResourceRefs();
            return null;
        }
        for (int i = 0; i < resourceRefMBeanArray.length; ++i) {
            if (!resourceRefMBeanArray[i].getRefName().equals(string)) continue;
            return resourceRefMBeanArray[i];
        }
        HTTPLogger.logResourceRefNotFound((String)string);
        return null;
    }

    private EjbRefMBean findEjbRef(WebAppDescriptor webAppDescriptor, String string) {
        int n;
        EjbRefMBean[] ejbRefMBeanArray = webAppDescriptor.getEJBReferences();
        EjbRefMBean[] ejbRefMBeanArray2 = webAppDescriptor.getEJBLocalReferences();
        if (ejbRefMBeanArray == null && ejbRefMBeanArray2 == null) {
            HTTPLogger.logNoEjbRefs();
            return null;
        }
        for (n = 0; ejbRefMBeanArray != null && n < ejbRefMBeanArray.length; ++n) {
            if (!ejbRefMBeanArray[n].getEJBRefName().equals(string)) continue;
            return ejbRefMBeanArray[n];
        }
        for (n = 0; ejbRefMBeanArray2 != null && n < ejbRefMBeanArray2.length; ++n) {
            if (!ejbRefMBeanArray2[n].getEJBRefName().equals(string)) continue;
            return ejbRefMBeanArray2[n];
        }
        HTTPLogger.logEjbRefNotFound((String)string);
        return null;
    }

    public EjbReferenceDescriptionMBean[] getEjbReferences() {
        return this.ejbRefs.toArray(new EjbReferenceDescription[0]);
    }

    public void setEjbReferences(EjbReferenceDescriptionMBean[] ejbReferenceDescriptionMBeanArray) {
        if (ejbReferenceDescriptionMBeanArray == null || ejbReferenceDescriptionMBeanArray.length < 1) {
            return;
        }
        EjbReferenceDescriptionMBean[] ejbReferenceDescriptionMBeanArray2 = this.getEjbReferences();
        this.ejbRefs.clear();
        for (int i = 0; i < ejbReferenceDescriptionMBeanArray.length; ++i) {
            this.ejbRefs.add(ejbReferenceDescriptionMBeanArray[i]);
        }
        if (!ReferenceDescriptor.comp(ejbReferenceDescriptionMBeanArray2, ejbReferenceDescriptionMBeanArray)) {
            this.firePropertyChange("ejbReferences", ejbReferenceDescriptionMBeanArray2, ejbReferenceDescriptionMBeanArray);
        }
    }

    public void addEjbReference(EjbReferenceDescriptionMBean ejbReferenceDescriptionMBean) {
        this.ejbRefs.add(ejbReferenceDescriptionMBean);
    }

    public void removeEjbReference(EjbReferenceDescriptionMBean ejbReferenceDescriptionMBean) {
        if (this.ejbRefs != null) {
            this.ejbRefs.remove(ejbReferenceDescriptionMBean);
        }
    }

    public ResourceDescriptionMBean[] getResourceReferences() {
        return this.resRefs.toArray(new ResourceDescription[0]);
    }

    public void setResourceReferences(ResourceDescriptionMBean[] resourceDescriptionMBeanArray) {
        ResourceDescriptionMBean[] resourceDescriptionMBeanArray2 = this.getResourceReferences();
        this.resRefs.clear();
        if (resourceDescriptionMBeanArray != null) {
            for (int i = 0; i < resourceDescriptionMBeanArray.length; ++i) {
                this.resRefs.add(resourceDescriptionMBeanArray[i]);
            }
        }
        if (!ReferenceDescriptor.comp(resourceDescriptionMBeanArray2, resourceDescriptionMBeanArray)) {
            this.firePropertyChange("resourceReferences", resourceDescriptionMBeanArray2, resourceDescriptionMBeanArray);
        }
    }

    public void addResourceReference(ResourceDescriptionMBean resourceDescriptionMBean) {
        this.resRefs.add(resourceDescriptionMBean);
    }

    public void removeResourceReference(ResourceDescriptionMBean resourceDescriptionMBean) {
        if (this.resRefs != null) {
            this.resRefs.remove(resourceDescriptionMBean);
        }
    }

    public void setResourceEnvReferences(ResourceEnvDescriptionMBean[] resourceEnvDescriptionMBeanArray) {
        ResourceEnvDescriptionMBean[] resourceEnvDescriptionMBeanArray2 = this.getResourceEnvReferences();
        this.resEnvRefs.clear();
        if (resourceEnvDescriptionMBeanArray == null) {
            return;
        }
        for (int i = 0; i < resourceEnvDescriptionMBeanArray.length; ++i) {
            this.resEnvRefs.add(resourceEnvDescriptionMBeanArray[i]);
        }
        if (!ReferenceDescriptor.comp(resourceEnvDescriptionMBeanArray2, resourceEnvDescriptionMBeanArray)) {
            this.firePropertyChange("resourceEnvReferences", resourceEnvDescriptionMBeanArray2, resourceEnvDescriptionMBeanArray);
        }
    }

    public ResourceEnvDescriptionMBean[] getResourceEnvReferences() {
        return this.resEnvRefs.toArray(new ResourceEnvDescriptionMBean[this.resEnvRefs.size()]);
    }

    public void addResourceEnvReference(ResourceEnvDescriptionMBean resourceEnvDescriptionMBean) {
        this.resEnvRefs.add(resourceEnvDescriptionMBean);
    }

    public void removeResourceEnvReference(ResourceEnvDescriptionMBean resourceEnvDescriptionMBean) {
        this.resEnvRefs.remove(resourceEnvDescriptionMBean);
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public String toXML(int n) {
        String string = "";
        if (this.resRefs.size() > 0 || this.resEnvRefs.size() > 0 || this.ejbRefs.size() > 0) {
            XMLElementMBean xMLElementMBean;
            int n2;
            string = string + this.indentStr(n) + "<reference-descriptor>\n";
            n += 2;
            for (n2 = 0; n2 < this.resRefs.size(); ++n2) {
                xMLElementMBean = (ResourceDescription)this.resRefs.get(n2);
                string = string + ((ResourceDescription)xMLElementMBean).toXML(n);
            }
            for (n2 = 0; n2 < this.resEnvRefs.size(); ++n2) {
                xMLElementMBean = (ResourceEnvDescriptionMBean)this.resEnvRefs.get(n2);
                string = string + xMLElementMBean.toXML(n);
            }
            for (n2 = 0; n2 < this.ejbRefs.size(); ++n2) {
                xMLElementMBean = (EjbReferenceDescription)this.ejbRefs.get(n2);
                string = string + this.indentStr(n) + "<ejb-reference-description>\n";
                n += 2;
                EjbRefMBean ejbRefMBean = ((EjbReferenceDescription)xMLElementMBean).getEjbReference();
                if (ejbRefMBean != null) {
                    string = string + this.indentStr(n) + "<ejb-ref-name>" + ejbRefMBean.getEJBRefName() + "</ejb-ref-name>\n";
                }
                string = string + this.indentStr(n) + "<jndi-name>" + ((EjbReferenceDescription)xMLElementMBean).getJndiName() + "</jndi-name>\n";
                string = string + this.indentStr(n -= 2) + "</ejb-reference-description>\n";
            }
            string = string + this.indentStr(n -= 2) + "</reference-descriptor>\n";
        }
        return string;
    }
}

