/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.ResourceRefMBean;
import weblogic.management.descriptors.webappext.ResourceDescriptionMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;

public final class ResourceDescription
extends BaseServletDescriptor
implements ResourceDescriptionMBean {
    private static final long serialVersionUID = 1215314657449753272L;
    private static String refErr = "Can't define resource-description in weblogic.xml because web.xml has no matching resource-ref";
    private ResourceRefMBean ref;
    private String jndiName;

    public ResourceDescription() {
    }

    public ResourceDescription(ResourceDescriptionMBean resourceDescriptionMBean) {
        this.jndiName = resourceDescriptionMBean.getJndiName();
        this.ref = resourceDescriptionMBean.getResourceReference();
    }

    public void setResourceReferenceName(String string) {
        String string2 = this.getResourceReferenceName();
        this.ref.setRefName(string);
        if (!ResourceDescription.comp(string2, string)) {
            this.firePropertyChange("resourceReferenceName", string2, string);
        }
    }

    public String getResourceReferenceName() {
        return this.ref == null ? null : this.ref.getRefName();
    }

    public void setResourceReference(ResourceRefMBean resourceRefMBean) {
        ResourceRefMBean resourceRefMBean2 = this.ref;
        this.ref = resourceRefMBean;
        if (!ResourceDescription.comp(resourceRefMBean2, resourceRefMBean)) {
            this.firePropertyChange("resourceReference", resourceRefMBean2, resourceRefMBean);
        }
    }

    public ResourceRefMBean getResourceReference() {
        return this.ref;
    }

    public void setJndiName(String string) {
        String string2 = this.jndiName;
        this.jndiName = string;
        if (!ResourceDescription.comp(string2, string)) {
            this.firePropertyChange("jndiName", string2, string);
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<resource-description>\n";
        string = string + this.indentStr(n += 2) + "<res-ref-name>" + this.getResourceReferenceName() + "</res-ref-name>\n";
        string = string + this.indentStr(n) + "<jndi-name>" + this.getJndiName() + "</jndi-name>\n";
        string = string + this.indentStr(n -= 2) + "</resource-description>\n";
        return string;
    }
}

