/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.ResourceEnvRefMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class ResourceEnvRef
extends BaseServletDescriptor
implements ResourceEnvRefMBean {
    private static final long serialVersionUID = 8512993589478342470L;
    String refName;
    String refType;
    String description;

    public ResourceEnvRef() {
    }

    public ResourceEnvRef(String string, String string2, String string3) {
        this.setDescription(string);
        this.setRefName(string2);
        this.setRefType(string3);
    }

    public ResourceEnvRef(ResourceEnvRefMBean resourceEnvRefMBean) {
        this.setDescription(resourceEnvRefMBean.getDescription());
        this.setRefName(resourceEnvRefMBean.getRefName());
        this.setRefType(resourceEnvRefMBean.getRefType());
    }

    public ResourceEnvRef(Element element) throws DOMProcessingException {
        this.setDescription(DOMUtils.getOptionalValueByTagName(element, "description"));
        this.setRefName(DOMUtils.getValueByTagName(element, "resource-env-ref-name"));
        this.setRefType(DOMUtils.getValueByTagName(element, "resource-env-ref-type"));
    }

    public String getRefName() {
        return this.refName;
    }

    public void setRefName(String string) {
        String string2 = this.refName;
        this.refName = string;
        if (!ResourceEnvRef.comp(string2, string)) {
            this.firePropertyChange("refName", string2, string);
        }
    }

    public String getRefType() {
        return this.refType;
    }

    public void setRefType(String string) {
        String string2 = this.refType;
        this.refType = string;
        if (!ResourceEnvRef.comp(string2, string)) {
            this.firePropertyChange("refType", string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!ResourceEnvRef.comp(string2, string)) {
            this.firePropertyChange("description", string2, string);
        }
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<resource-env-ref>\n";
        n += 2;
        String string2 = this.getDescription();
        if (string2 != null) {
            string = string + this.indentStr(n) + "<description>" + string2 + "</description>\n";
        }
        string = string + this.indentStr(n) + "<resource-env-ref-name>" + this.getRefName() + "</resource-env-ref-name>\n";
        try {
            string = string + this.indentStr(n) + "<resource-env-ref-type>" + this.getRefType() + "</resource-env-ref-type>\n";
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = string + this.indentStr(n -= 2) + "</resource-env-ref>\n";
        return string;
    }
}

