/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.ResourceRefMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class ResourceReference
extends BaseServletDescriptor
implements ResourceRefMBean {
    private static final long serialVersionUID = -4930785984109869909L;
    String refName;
    String refType;
    String auth;
    String sharingScope;
    String description;

    public ResourceReference() {
    }

    public ResourceReference(String string, String string2, String string3, String string4) {
        this.setRefName(string2);
        this.setRefType(string3);
        this.setAuth(string4);
        this.setDescription(string);
    }

    public ResourceReference(ResourceRefMBean resourceRefMBean) {
        this.setDescription(resourceRefMBean.getDescription());
        this.setRefName(resourceRefMBean.getRefName());
        this.setRefType(resourceRefMBean.getRefType());
        this.setAuth(resourceRefMBean.getAuth());
        this.setSharingScope(resourceRefMBean.getSharingScope());
    }

    public ResourceReference(Element element) throws DOMProcessingException {
        this.setDescription(DOMUtils.getOptionalValueByTagName(element, "description"));
        this.setRefName(DOMUtils.getValueByTagName(element, "res-ref-name"));
        this.setRefType(DOMUtils.getValueByTagName(element, "res-type"));
        this.setAuth(DOMUtils.getValueByTagName(element, "res-auth"));
        this.setSharingScope(DOMUtils.getOptionalValueByTagName(element, "res-sharing-scope"));
    }

    public String getRefName() {
        return this.refName;
    }

    public void setRefName(String string) {
        String string2 = this.refName;
        this.refName = string;
        if (!ResourceReference.comp(string2, string)) {
            this.firePropertyChange("refName", string2, string);
        }
    }

    public String getRefType() {
        return this.refType;
    }

    public void setRefType(String string) {
        String string2 = this.refType;
        this.refType = string;
        if (!ResourceReference.comp(string2, string)) {
            this.firePropertyChange("refType", string2, string);
        }
    }

    public String getAuth() {
        return this.auth;
    }

    public void setAuth(String string) {
        String string2 = this.auth;
        this.auth = string;
        if (!ResourceReference.comp(string2, string)) {
            this.firePropertyChange("auth", string2, string);
        }
    }

    public String getSharingScope() {
        return this.sharingScope;
    }

    public void setSharingScope(String string) {
        String string2 = this.sharingScope;
        this.sharingScope = string;
        if (!ResourceReference.comp(string2, string)) {
            this.firePropertyChange("sharingScope", string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!ResourceReference.comp(string2, string)) {
            this.firePropertyChange("description", string2, string);
        }
    }

    public String toString() {
        return this.getRefName();
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<resource-ref>\n";
        n += 2;
        String string2 = this.getDescription();
        if (string2 != null) {
            string = string + this.indentStr(n) + "<description>" + string2 + "</description>\n";
        }
        string = string + this.indentStr(n) + "<res-ref-name>" + this.getRefName() + "</res-ref-name>\n";
        try {
            string = string + this.indentStr(n) + "<res-type>" + this.getRefType() + "</res-type>\n";
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = string + this.indentStr(n) + "<res-auth>" + this.getAuth() + "</res-auth>\n";
        if (this.sharingScope != null) {
            string = string + this.indentStr(n) + "<res-sharing-scope>" + this.getSharingScope() + "</res-sharing-scope>\n";
        }
        string = string + this.indentStr(n -= 2) + "</resource-ref>\n";
        return string;
    }
}

