/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.RunAsMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class RunAsDescriptor
extends BaseServletDescriptor
implements RunAsMBean {
    private String description;
    private String roleName;

    public RunAsDescriptor() {
    }

    public RunAsDescriptor(RunAsMBean runAsMBean) {
        this.setDescription(runAsMBean.getDescription());
        this.setRoleName(runAsMBean.getRoleName());
    }

    public RunAsDescriptor(Element element) throws DOMProcessingException {
        this.setDescription(DOMUtils.getOptionalValueByTagName(element, "description"));
        this.setRoleName(DOMUtils.getValueByTagName(element, "role-name"));
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!RunAsDescriptor.comp(string2, string)) {
            this.firePropertyChange("description", string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setRoleName(String string) {
        String string2 = this.roleName;
        this.roleName = string;
        if (!RunAsDescriptor.comp(string2, string)) {
            this.firePropertyChange("roleName", string2, string);
        }
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String toString() {
        return this.getRoleName();
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<run-as>\n";
        n += 2;
        String string2 = this.getDescription();
        if (string2 != null) {
            string = string + this.indentStr(n) + "<description>" + string2 + "</description>\n";
        }
        string = string + this.indentStr(n) + "<role-name>" + this.getRoleName() + "</role-name>\n";
        string = string + this.indentStr(n -= 2) + "</run-as>\n";
        return string;
    }
}

