/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.SecurityRoleMBean;
import weblogic.management.descriptors.webappext.RunAsRoleAssignmentMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.WebAppDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class RunAsRoleAssignment
extends BaseServletDescriptor
implements RunAsRoleAssignmentMBean {
    private static final String RUN_AS_IDENTITY = "run-as-role-assignment";
    private static final String ROLE_NAME = "role-name";
    private static final String RUN_AS_PRINCIPAL_NAME = "run-as-principal-name";
    private String runAsPrincipalName = null;
    private SecurityRoleMBean securityRole;

    public RunAsRoleAssignment(SecurityRoleMBean securityRoleMBean) {
        this.securityRole = securityRoleMBean;
        if (this.securityRole == null) {
            throw new NullPointerException();
        }
        this.runAsPrincipalName = null;
    }

    public RunAsRoleAssignment(WebAppDescriptor webAppDescriptor, Element element) throws DOMProcessingException {
        String string = DOMUtils.getValueByTagName(element, ROLE_NAME);
        this.securityRole = this.findRole(webAppDescriptor, string);
        if (this.securityRole == null) {
            throw new DOMProcessingException("SecurityRole with name " + string + " not defined in web.xml");
        }
        this.setRunAsPrincipalName(DOMUtils.getValueByTagName(element, RUN_AS_PRINCIPAL_NAME));
    }

    public void setRoleName(String string) throws DOMProcessingException {
        this.securityRole.setRoleName(string);
        this.setIdentity();
    }

    public String getRoleName() {
        return this.securityRole.getRoleName();
    }

    public void setSecurityRole(SecurityRoleMBean securityRoleMBean) {
        if (securityRoleMBean == null) {
            throw new NullPointerException();
        }
        this.securityRole = securityRoleMBean;
        this.setIdentity();
    }

    public SecurityRoleMBean getSecurityRole() {
        return this.securityRole;
    }

    public void setRunAsPrincipalName(String string) {
        String string2 = this.runAsPrincipalName;
        this.runAsPrincipalName = string;
        if (!RunAsRoleAssignment.comp(string2, string)) {
            this.firePropertyChange("runAsPrincipalName", string2, string);
        }
        this.setIdentity();
    }

    public String getRunAsPrincipalName() {
        return this.runAsPrincipalName;
    }

    private void setIdentity() {
        if (this.securityRole != null && this.runAsPrincipalName != null) {
            this.securityRole.setRunAsIdentity(this.runAsPrincipalName);
        }
    }

    private SecurityRoleMBean findRole(WebAppDescriptor webAppDescriptor, String string) {
        SecurityRoleMBean[] securityRoleMBeanArray = webAppDescriptor.getSecurityRoles();
        if (securityRoleMBeanArray == null) {
            return null;
        }
        SecurityRoleMBean securityRoleMBean = null;
        for (int i = 0; i < securityRoleMBeanArray.length; ++i) {
            if (securityRoleMBeanArray[i] == null || !string.equals(securityRoleMBeanArray[i].getRoleName())) continue;
            securityRoleMBean = securityRoleMBeanArray[i];
            break;
        }
        return securityRoleMBean;
    }

    public String toString() {
        return this.getRoleName();
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = this.getRunAsPrincipalName();
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        string = "";
        string = string + this.indentStr(n) + "<" + RUN_AS_IDENTITY + ">\n";
        string = string + this.indentStr(n += 2) + "<" + ROLE_NAME + ">" + this.getRoleName() + "</" + ROLE_NAME + ">\n";
        string = string + this.indentStr(n) + "<" + RUN_AS_PRINCIPAL_NAME + ">" + this.getRunAsPrincipalName() + "</" + RUN_AS_PRINCIPAL_NAME + ">\n";
        string = string + this.indentStr(n -= 2) + "</" + RUN_AS_IDENTITY + ">\n";
        return string;
    }
}

