/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.AuthConstraintMBean;
import weblogic.management.descriptors.webapp.SecurityConstraintMBean;
import weblogic.management.descriptors.webapp.SecurityRoleMBean;
import weblogic.management.descriptors.webapp.UserDataConstraintMBean;
import weblogic.management.descriptors.webapp.WebResourceCollectionMBean;
import weblogic.servlet.internal.dd.AuthConstraintDescriptor;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.internal.dd.UserDataConstraint;
import weblogic.servlet.internal.dd.WebAppDescriptor;
import weblogic.servlet.internal.dd.WebResourceDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class SecurityConstraint
extends BaseServletDescriptor
implements ToXML,
SecurityConstraintMBean {
    private static final long serialVersionUID = 2835803302540822938L;
    private static final String WEB_RESOURCE_COLLECTION = "web-resource-collection";
    private static final String AUTH_CONSTRAINT = "auth-constraint";
    private static final String USER_DATA_CONSTRAINT = "user-data-constraint";
    private static final String TRANSPORT_GUARANTEE = "transport-guarantee";
    private static final String DISPLAY_NAME = "display-name";
    private static final String DESCRIPTION = "description";
    public static final int TG_NONE = 0;
    public static final int TG_INTEGRAL = 1;
    public static final int TG_CONFIDENTIAL = 2;
    private String displayName;
    private WebResourceCollectionMBean[] webResources;
    private String[] methods = null;
    private AuthConstraintDescriptor authConstraint;
    private UserDataConstraintMBean userDataConstraint;

    public SecurityConstraint() {
    }

    public SecurityConstraint(WebAppDescriptor webAppDescriptor, Element element) throws DOMProcessingException {
        Element element2;
        Object object;
        this.displayName = DOMUtils.getOptionalValueByTagName(element, DISPLAY_NAME);
        List list = DOMUtils.getOptionalElementsByTagName(element, WEB_RESOURCE_COLLECTION);
        if (list != null) {
            object = list.iterator();
            this.webResources = new WebResourceDescriptor[list.size()];
            int n = 0;
            while (object.hasNext()) {
                Element element3 = (Element)object.next();
                this.webResources[n++] = new WebResourceDescriptor(element3);
            }
        }
        if ((element2 = DOMUtils.getOptionalElementByTagName(element, USER_DATA_CONSTRAINT)) != null) {
            object = DOMUtils.getOptionalValueByTagName(element2, DESCRIPTION);
            String string = DOMUtils.getValueByTagName(element2, TRANSPORT_GUARANTEE);
            if (string == null) {
                throw new DOMProcessingException("You must specify transport-guarantee inside user-data-constraint element.");
            }
            if ("INTEGRAL".equalsIgnoreCase(string)) {
                this.userDataConstraint = new UserDataConstraint();
                this.userDataConstraint.setDescription((String)object);
                this.userDataConstraint.setTransportGuarantee("INTEGRAL");
            } else if ("CONFIDENTIAL".equalsIgnoreCase(string)) {
                this.userDataConstraint = new UserDataConstraint();
                this.userDataConstraint.setDescription((String)object);
                this.userDataConstraint.setTransportGuarantee("CONFIDENTIAL");
            } else {
                this.userDataConstraint = new UserDataConstraint();
                this.userDataConstraint.setDescription((String)object);
                this.userDataConstraint.setTransportGuarantee("NONE");
            }
        }
        if ((element2 = DOMUtils.getOptionalElementByTagName(element, AUTH_CONSTRAINT)) != null) {
            this.authConstraint = new AuthConstraintDescriptor(webAppDescriptor, element2);
        }
    }

    public SecurityConstraint(SecurityConstraintMBean securityConstraintMBean) {
        this.setDisplayName(securityConstraintMBean.getDisplayName());
        this.setWebResourceCollection(securityConstraintMBean.getWebResourceCollection());
        this.setAuthConstraint(securityConstraintMBean.getAuthConstraint());
        this.setUserDataConstraint(new UserDataConstraint(securityConstraintMBean.getUserDataConstraint()));
    }

    public String[] getHttpMethods() {
        return this.methods;
    }

    public void setHttpMethods(String[] stringArray) {
        String[] stringArray2 = this.methods;
        this.methods = stringArray;
        if (!SecurityConstraint.comp(stringArray2, stringArray)) {
            this.firePropertyChange("httpMethods", stringArray2, stringArray);
        }
    }

    public boolean hasRoleConstraint() {
        if (this.authConstraint == null) {
            return false;
        }
        SecurityRoleMBean[] securityRoleMBeanArray = this.authConstraint.getRoles();
        if (securityRoleMBeanArray != null) {
            for (int i = 0; i < securityRoleMBeanArray.length; ++i) {
                if (!securityRoleMBeanArray[i].getRoleName().equals("*")) continue;
                return false;
            }
        }
        return true;
    }

    public int getTransportGuarantee() {
        if (this.userDataConstraint == null) {
            return 0;
        }
        String string = this.userDataConstraint.getTransportGuarantee();
        if ("INTEGRAL".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("CONFIDENTIAL".equalsIgnoreCase(string)) {
            return 2;
        }
        return 0;
    }

    public void setTransportGuarantee(int n) {
        int n2 = this.getTransportGuarantee();
        switch (n) {
            case 1: {
                this.userDataConstraint.setTransportGuarantee("INTEGRAL");
                break;
            }
            case 2: {
                this.userDataConstraint.setTransportGuarantee("CONFIDENTIAL");
                break;
            }
            default: {
                this.userDataConstraint.setTransportGuarantee("NONE");
            }
        }
        if (n2 != this.getTransportGuarantee()) {
            this.firePropertyChange("transportGuarantee", new Integer(this.getTransportGuarantee()), new Integer(n));
        }
    }

    public WebResourceCollectionMBean[] getWebResourceCollection() {
        return this.webResources;
    }

    public void setWebResourceCollection(WebResourceCollectionMBean[] webResourceCollectionMBeanArray) {
        WebResourceCollectionMBean[] webResourceCollectionMBeanArray2 = this.webResources;
        if (webResourceCollectionMBeanArray == null || webResourceCollectionMBeanArray.length == 0) {
            this.webResources = new WebResourceDescriptor[0];
        } else {
            WebResourceCollectionMBean[] webResourceCollectionMBeanArray3 = new WebResourceCollectionMBean[webResourceCollectionMBeanArray.length];
            for (int i = 0; i < webResourceCollectionMBeanArray.length; ++i) {
                webResourceCollectionMBeanArray3[i] = webResourceCollectionMBeanArray[i];
            }
            this.webResources = webResourceCollectionMBeanArray3;
        }
        if (!SecurityConstraint.comp(webResourceCollectionMBeanArray2, webResourceCollectionMBeanArray)) {
            this.firePropertyChange("webResourceCollection", webResourceCollectionMBeanArray2, webResourceCollectionMBeanArray);
        }
    }

    public void addWebResourceCollection(WebResourceCollectionMBean webResourceCollectionMBean) {
        WebResourceCollectionMBean[] webResourceCollectionMBeanArray = this.getWebResourceCollection();
        if (webResourceCollectionMBeanArray == null) {
            webResourceCollectionMBeanArray = new WebResourceCollectionMBean[]{webResourceCollectionMBean};
            this.setWebResourceCollection(webResourceCollectionMBeanArray);
            return;
        }
        WebResourceCollectionMBean[] webResourceCollectionMBeanArray2 = new WebResourceCollectionMBean[webResourceCollectionMBeanArray.length + 1];
        System.arraycopy(webResourceCollectionMBeanArray, 0, webResourceCollectionMBeanArray2, 0, webResourceCollectionMBeanArray.length);
        webResourceCollectionMBeanArray2[webResourceCollectionMBeanArray.length] = webResourceCollectionMBean;
        this.setWebResourceCollection(webResourceCollectionMBeanArray2);
    }

    public void removeWebResourceCollection(WebResourceCollectionMBean webResourceCollectionMBean) {
        WebResourceCollectionMBean[] webResourceCollectionMBeanArray = this.getWebResourceCollection();
        if (webResourceCollectionMBeanArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < webResourceCollectionMBeanArray.length; ++i) {
            if (!webResourceCollectionMBeanArray[i].equals(webResourceCollectionMBean)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            WebResourceCollectionMBean[] webResourceCollectionMBeanArray2 = new WebResourceCollectionMBean[webResourceCollectionMBeanArray.length - 1];
            System.arraycopy(webResourceCollectionMBeanArray, 0, webResourceCollectionMBeanArray2, 0, n);
            System.arraycopy(webResourceCollectionMBeanArray, n + 1, webResourceCollectionMBeanArray2, n, webResourceCollectionMBeanArray.length - (n + 1));
            this.setWebResourceCollection(webResourceCollectionMBeanArray2);
        }
    }

    public AuthConstraintMBean getAuthConstraint() {
        return this.authConstraint;
    }

    public void setAuthConstraint(AuthConstraintMBean authConstraintMBean) {
        AuthConstraintDescriptor authConstraintDescriptor = this.authConstraint;
        this.authConstraint = (AuthConstraintDescriptor)authConstraintMBean;
        if (!SecurityConstraint.comp(authConstraintDescriptor, authConstraintMBean)) {
            this.firePropertyChange("authConstraint", authConstraintDescriptor, authConstraintMBean);
        }
    }

    public UserDataConstraintMBean getUserDataConstraint() {
        return this.userDataConstraint;
    }

    public void setUserDataConstraint(UserDataConstraintMBean userDataConstraintMBean) {
        UserDataConstraintMBean userDataConstraintMBean2 = this.userDataConstraint;
        this.userDataConstraint = userDataConstraintMBean;
        if (!SecurityConstraint.comp(userDataConstraintMBean2, userDataConstraintMBean)) {
            this.firePropertyChange("userDataConstraint", userDataConstraintMBean2, userDataConstraintMBean);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        String string2 = this.displayName;
        this.displayName = string;
        if (!SecurityConstraint.comp(string2, string)) {
            this.firePropertyChange("displayName", string2, string);
        }
    }

    public String getDisplayString() {
        String string = this.getDisplayName();
        if (string == null || (string = string.trim()).length() == 0) {
            WebResourceCollectionMBean[] webResourceCollectionMBeanArray = this.getWebResourceCollection();
            for (int i = 0; webResourceCollectionMBeanArray != null && i < webResourceCollectionMBeanArray.length && ((string = webResourceCollectionMBeanArray[i].getResourceName()) == null || (string = string.trim()).length() <= 0); ++i) {
            }
        }
        return string;
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
        if (this.webResources == null || this.webResources.length == 0) {
            this.addDescriptorError("NO_WEB_RESOURCE");
            throw new DescriptorValidationException();
        }
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<security-constraint>\n";
        n += 2;
        if (this.getDisplayName() != null) {
            string = string + this.indentStr(n) + "<display-name>" + this.getDisplayName() + "</display-name>\n";
        }
        if (this.webResources != null) {
            for (int i = 0; i < this.webResources.length; ++i) {
                string = string + this.webResources[i].toXML(n);
            }
        }
        if (this.authConstraint != null) {
            string = string + this.authConstraint.toXML(n);
        }
        if (this.userDataConstraint != null) {
            string = string + this.userDataConstraint.toXML(n);
        }
        string = string + this.indentStr(n -= 2) + "</security-constraint>\n";
        return string;
    }

    public String toString() {
        Object object;
        String string = "SecurityConstraint(";
        string = string + "display=" + this.displayName + ",";
        String[] stringArray = this.getHttpMethods();
        if (stringArray == null) {
            string = string + "methods=null,";
        } else {
            object = "{";
            for (int i = 0; i < stringArray.length; ++i) {
                object = (String)object + stringArray[i];
                object = i == stringArray.length - 1 ? (String)object + "}" : (String)object + ",";
            }
            string = string + "methods=" + (String)object + ",";
        }
        string = string + "guarantee=" + this.getTransportGuarantee() + ",";
        string = string + "constrained=" + this.hasRoleConstraint() + ",";
        string = string + "auth=" + this.authConstraint + ",";
        object = this.getWebResourceCollection();
        if (object == null) {
            string = string + "wrc=null,";
        } else {
            String string2 = "{";
            for (int i = 0; i < ((WebResourceCollectionMBean[])object).length; ++i) {
                string2 = string2 + object[i];
                string2 = i == ((WebResourceCollectionMBean[])object).length - 1 ? string2 + "}" : string2 + ",";
            }
            string = string + "wrc=" + string2 + ",";
        }
        string = string + "auth=" + this.getAuthConstraint() + ",";
        string = string + "udc=" + this.getUserDataConstraint();
        string = string + ")";
        return string;
    }
}

