/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webappext.SecurityPermissionMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class SecurityPermissionDescriptor
extends BaseServletDescriptor
implements SecurityPermissionMBean,
ToXML {
    private static final String SECURITY_PERMISSION = "security-permission";
    private static final String SECURITY_PERMISSION_SPEC = "security-permission-spec";
    private static final String DESCRIPTION = "description";
    private String spec;
    private String desc;

    public SecurityPermissionDescriptor() {
        this.spec = null;
        this.desc = null;
    }

    public SecurityPermissionDescriptor(String string, String string2) {
        this.spec = string;
        this.desc = string2;
    }

    public SecurityPermissionDescriptor(Element element) throws DOMProcessingException {
        this.desc = DOMUtils.getOptionalValueByTagName(element, DESCRIPTION);
        this.spec = DOMUtils.getValueByTagName(element, SECURITY_PERMISSION_SPEC);
    }

    public void setDescription(String string) {
        String string2 = this.desc;
        this.desc = string;
        if (!SecurityPermissionDescriptor.comp(string2, this.desc)) {
            this.firePropertyChange(DESCRIPTION, string2, this.desc);
        }
    }

    public String getDescription() {
        return this.desc;
    }

    public void setSecurityPermissionSpec(String string) {
        String string2 = this.spec;
        this.spec = string;
        if (!SecurityPermissionDescriptor.comp(string2, this.spec)) {
            this.firePropertyChange("securityPermissionSpec", string2, this.spec);
        }
    }

    public String getSecurityPermissionSpec() {
        return this.spec;
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<" + SECURITY_PERMISSION + ">\n";
        string = string + this.indentStr(n += 2) + "<" + SECURITY_PERMISSION_SPEC + ">" + this.getSecurityPermissionSpec() + "</" + SECURITY_PERMISSION_SPEC + ">\n";
        string = string + this.indentStr(n) + "<" + DESCRIPTION + ">" + this.getDescription() + "</" + DESCRIPTION + ">\n";
        string = string + this.indentStr(n -= 2) + "</" + SECURITY_PERMISSION + ">\n";
        return string;
    }
}

