/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.SecurityRoleMBean;
import weblogic.management.descriptors.webappext.SecurityRoleAssignmentMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.WebAppDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class SecurityRoleAssignment
extends BaseServletDescriptor
implements SecurityRoleAssignmentMBean {
    private static final long serialVersionUID = -3874048726826475026L;
    private final String SECURITY_ROLE_ASSIGNMENT = "security-role-assignment";
    private final String ROLE_NAME = "role-name";
    private final String PRINCIPAL_NAME = "principal-name";
    private final String GLOBAL_ROLE = "global-role";
    private final String EXTERNALLY_DEFINED = "externally-defined";
    private SecurityRoleMBean role = null;
    private String[] principal = null;
    private boolean externallyDefined = false;
    private static String refErr = "Can't define security-role-assignment in weblogic.xml because web.xml has no matching security-role";

    public SecurityRoleAssignment() {
    }

    public SecurityRoleAssignment(WebAppDescriptor webAppDescriptor, SecurityRoleAssignmentMBean securityRoleAssignmentMBean) throws DOMProcessingException {
        this.setRole(webAppDescriptor, securityRoleAssignmentMBean.getRole().getRoleName());
        this.setPrincipalNames(securityRoleAssignmentMBean.getPrincipalNames());
        this.setExternallyDefined(securityRoleAssignmentMBean.isExternallyDefined());
    }

    public SecurityRoleAssignment(WebAppDescriptor webAppDescriptor, Element element) throws DOMProcessingException {
        String string = DOMUtils.getValueByTagName(element, "role-name");
        if (string == null) {
            throw new DOMProcessingException("You must specify a role-name element within security-role-assignment");
        }
        this.setRole(webAppDescriptor, string);
        String string2 = DOMUtils.getOptionalValueByTagName(element, "externally-defined");
        if (string2 == null) {
            string2 = DOMUtils.getOptionalValueByTagName(element, "global-role");
        }
        this.externallyDefined = string2 == null ? false : string2.equals("") || string2.equalsIgnoreCase("true");
        List list = DOMUtils.getOptionalElementsByTagName(element, "principal-name");
        if (list == null || list.size() < 1) {
            this.setPrincipalNames(new String[0]);
            if (!this.externallyDefined) {
                throw new DOMProcessingException("Neither principal-names nor  externally-defined element specified for security-role-assignment");
            }
        } else {
            Iterator iterator = list.iterator();
            String[] stringArray = new String[list.size()];
            int n = 0;
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                stringArray[n] = DOMUtils.getTextData(element2);
                ++n;
            }
            this.setPrincipalNames(stringArray);
        }
    }

    private void setRole(WebAppDescriptor webAppDescriptor, String string) throws DOMProcessingException {
        SecurityRoleMBean[] securityRoleMBeanArray = webAppDescriptor.getSecurityRoles();
        if (securityRoleMBeanArray == null) {
            HTTPLogger.logBadSecurityRoleInSRA((String)string);
        }
        for (int i = 0; i < securityRoleMBeanArray.length; ++i) {
            if (!securityRoleMBeanArray[i].getRoleName().equals(string)) continue;
            this.role = securityRoleMBeanArray[i];
            break;
        }
        if (this.role == null) {
            HTTPLogger.logBadSecurityRoleInSRA((String)string);
        }
    }

    public void setRole(SecurityRoleMBean securityRoleMBean) {
        if (this.role == null) {
            HTTPLogger.logBadSecurityRoleInSRA((String)this.getName());
        }
        SecurityRoleMBean securityRoleMBean2 = this.role;
        this.role = securityRoleMBean;
        if (!SecurityRoleAssignment.comp(securityRoleMBean2, securityRoleMBean)) {
            this.firePropertyChange("role", securityRoleMBean2, securityRoleMBean);
        }
    }

    public SecurityRoleMBean getRole() {
        return this.role;
    }

    public void setPrincipalNames(String[] stringArray) {
        String[] stringArray2 = this.principal;
        this.principal = stringArray;
        if (!SecurityRoleAssignment.comp(stringArray2, stringArray)) {
            this.firePropertyChange("principalNames", stringArray2, stringArray);
        }
    }

    public String[] getPrincipalNames() {
        return this.principal;
    }

    public void addPrincipalName(String string) {
        String[] stringArray = this.getPrincipalNames();
        if (stringArray == null) {
            stringArray = new String[]{string};
            this.setPrincipalNames(stringArray);
            return;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        this.setPrincipalNames(stringArray2);
    }

    public void removePrincipalName(String string) {
        String[] stringArray = this.getPrincipalNames();
        if (stringArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - (n + 1));
            this.setPrincipalNames(stringArray2);
        }
    }

    public void setExternallyDefined(boolean bl) {
        boolean bl2 = this.externallyDefined;
        this.externallyDefined = bl;
        if (bl2 != bl) {
            this.firePropertyChange("externallyDefined", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isExternallyDefined() {
        return this.externallyDefined;
    }

    public boolean isGlobalRole() {
        return this.isExternallyDefined();
    }

    public void setGlobalRole(boolean bl) {
        this.setExternallyDefined(bl);
    }

    public void validate() throws DescriptorValidationException {
        boolean bl = true;
        this.removeDescriptorErrors();
        if (this.role == null || this.role.getRoleName() == null) {
            this.addDescriptorError("role-name is not set in security-role-assignment");
            bl = false;
        }
        if (!(bl = this.hasEitherPrincipalOrExternal())) {
            throw new DescriptorValidationException();
        }
    }

    private boolean hasEitherPrincipalOrExternal() {
        boolean bl = false;
        if ((this.principal == null || this.principal.length == 0) && this.externallyDefined) {
            bl = true;
        }
        if (this.principal != null && this.principal.length != 0 && !this.externallyDefined) {
            bl = true;
        }
        if (this.principal != null && this.principal.length != 0 && this.externallyDefined) {
            bl = false;
        }
        if (!(this.principal != null && this.principal.length != 0 || this.externallyDefined)) {
            bl = false;
        }
        return bl;
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<" + "security-role-assignment" + ">\n";
        n += 2;
        if (this.role != null) {
            string = string + this.indentStr(n) + "<" + "role-name" + ">" + this.role.getRoleName() + "</" + "role-name" + ">\n";
        }
        if (this.principal != null) {
            for (int i = 0; i < this.principal.length; ++i) {
                string = string + this.indentStr(n) + "<" + "principal-name" + ">" + this.principal[i] + "</" + "principal-name" + ">\n";
            }
        }
        if (this.externallyDefined) {
            string = string + this.indentStr(n) + "<" + "externally-defined" + "/>\n";
        }
        string = string + this.indentStr(n -= 2) + "</" + "security-role-assignment" + ">\n";
        return string;
    }
}

