/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.SecurityRoleMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class SecurityRoleDescriptor
extends BaseServletDescriptor
implements SecurityRoleMBean {
    private static final long serialVersionUID = -1288713403285978490L;
    private String description;
    private String roleName;
    private String runAsIdentity;

    public SecurityRoleDescriptor() {
    }

    public SecurityRoleDescriptor(SecurityRoleMBean securityRoleMBean) {
        this.setDescription(securityRoleMBean.getDescription());
        this.setRoleName(securityRoleMBean.getRoleName());
    }

    public SecurityRoleDescriptor(Element element) throws DOMProcessingException {
        this.setDescription(DOMUtils.getOptionalValueByTagName(element, "description"));
        this.setRoleName(DOMUtils.getValueByTagName(element, "role-name"));
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!SecurityRoleDescriptor.comp(string2, string)) {
            this.firePropertyChange("description", string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setRoleName(String string) {
        String string2 = this.roleName;
        this.roleName = string;
        if (!SecurityRoleDescriptor.comp(string2, string)) {
            this.firePropertyChange("roleName", string2, string);
        }
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getRunAsIdentity() {
        return this.runAsIdentity;
    }

    public void setRunAsIdentity(String string) {
        String string2 = this.runAsIdentity;
        this.runAsIdentity = string;
        if (!SecurityRoleDescriptor.comp(string2, string)) {
            this.firePropertyChange("runAsIdentity", string2, string);
        }
    }

    public String toString() {
        return this.getRoleName();
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<security-role>\n";
        n += 2;
        String string2 = this.getDescription();
        if (string2 != null) {
            string = string + this.indentStr(n) + "<description>" + string2 + "</description>\n";
        }
        string = string + this.indentStr(n) + "<role-name>" + this.getRoleName() + "</role-name>\n";
        string = string + this.indentStr(n -= 2) + "</security-role>\n";
        return string;
    }
}

