/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.SecurityRoleMBean;
import weblogic.management.descriptors.webapp.SecurityRoleRefMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.internal.dd.WebAppDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class SecurityRoleRefDescriptor
extends BaseServletDescriptor
implements SecurityRoleRefMBean,
ToXML {
    private static final long serialVersionUID = 5435403745362765252L;
    private String description;
    private String roleName;
    private SecurityRoleMBean roleLink;
    private String linkName;

    public SecurityRoleRefDescriptor() {
    }

    public SecurityRoleRefDescriptor(SecurityRoleRefMBean securityRoleRefMBean) {
        this.setDescription(securityRoleRefMBean.getDescription());
        this.setRoleName(securityRoleRefMBean.getRoleName());
        this.setRoleLink(securityRoleRefMBean.getRoleLink());
    }

    public SecurityRoleRefDescriptor(WebAppDescriptor webAppDescriptor, Element element) throws DOMProcessingException {
        this.setDescription(DOMUtils.getOptionalValueByTagName(element, "description"));
        this.setRoleName(DOMUtils.getValueByTagName(element, "role-name"));
        this.linkName = DOMUtils.getOptionalValueByTagName(element, "role-link");
        SecurityRoleMBean[] securityRoleMBeanArray = webAppDescriptor.getSecurityRoles();
        for (int i = 0; i < securityRoleMBeanArray.length; ++i) {
            if (!securityRoleMBeanArray[i].getRoleName().equals(this.linkName)) continue;
            this.setRoleLink(securityRoleMBeanArray[i]);
        }
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!SecurityRoleRefDescriptor.comp(string2, string)) {
            this.firePropertyChange("description", this.description, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setRoleName(String string) {
        String string2 = this.roleName;
        this.roleName = string;
        if (!SecurityRoleRefDescriptor.comp(string2, string)) {
            this.firePropertyChange("roleName", string2, string);
        }
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleLink(SecurityRoleMBean securityRoleMBean) {
        this.linkName = null;
        SecurityRoleMBean securityRoleMBean2 = this.roleLink;
        this.roleLink = securityRoleMBean;
        if (!SecurityRoleRefDescriptor.comp(securityRoleMBean2, securityRoleMBean)) {
            this.firePropertyChange("roleLink", securityRoleMBean2, securityRoleMBean);
        }
    }

    public SecurityRoleMBean getRoleLink() {
        return this.roleLink;
    }

    public void validate() throws DescriptorValidationException {
        boolean bl = true;
        this.removeDescriptorErrors();
        if (this.roleName == null || this.roleName.length() <= 0) {
            this.addDescriptorError("NO_SECURITY_ROLE_NAME_SET");
            bl = false;
        }
        if (this.roleLink == null) {
            this.addDescriptorError("NO_SECURITY_ROLE_LINK_SET");
            bl = false;
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<security-role-ref>\n";
        n += 2;
        String string2 = this.getDescription();
        if (string2 != null) {
            string = string + this.indentStr(n) + "<description>" + string2 + "</description>\n";
        }
        string = string + this.indentStr(n) + "<role-name>" + this.getRoleName() + "</role-name>\n";
        SecurityRoleMBean securityRoleMBean = this.getRoleLink();
        if (securityRoleMBean != null) {
            string = string + this.indentStr(n) + "<role-link>" + securityRoleMBean.getRoleName() + "</role-link>\n";
        } else if (this.linkName != null && (this.linkName = this.linkName.trim()).length() != 0) {
            string = string + this.indentStr(n) + "<role-link>" + this.linkName + "</role-link>\n";
        }
        string = string + this.indentStr(n -= 2) + "</security-role-ref>\n";
        return string;
    }
}

