/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.ParameterMBean;
import weblogic.management.descriptors.webapp.RunAsMBean;
import weblogic.management.descriptors.webapp.SecurityRoleRefMBean;
import weblogic.management.descriptors.webapp.ServletMBean;
import weblogic.management.descriptors.webapp.UIMBean;
import weblogic.management.descriptors.webappext.ServletDescriptorMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ParameterDescriptor;
import weblogic.servlet.internal.dd.RunAsDescriptor;
import weblogic.servlet.internal.dd.SecurityRoleRefDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.internal.dd.UIDescriptor;
import weblogic.servlet.internal.dd.WebAppDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class ServletDescriptor
extends BaseServletDescriptor
implements ToXML,
ServletMBean {
    private static final String SERVLET_NAME = "servlet-name";
    private static final String SERVLET_CLASS = "servlet-class";
    private static final String JSP_FILE = "jsp-file";
    private static final String INIT_PARAM = "init-param";
    private static final String LOAD_ON_STARTUP = "load-on-startup";
    private static final String SECURITY_ROLE_REF = "security-role-ref";
    private static final String RUN_AS = "run-as";
    private String servletName;
    private UIMBean uiData = new UIDescriptor();
    private String servletClass;
    private String jspFile;
    private List initParams;
    private int loadSeq = -1;
    private List secRoleRefs;
    private RunAsMBean runAs;
    private String initAs;
    private String destroyAs;
    private ServletDescriptorMBean servletDescriptor = null;

    public ServletDescriptor() {
    }

    public ServletDescriptor(ServletMBean servletMBean) {
        this.setServletName(servletMBean.getServletName());
        this.setServletClass(servletMBean.getServletClass());
        this.setUIData(servletMBean.getUIData());
        this.setJspFile(servletMBean.getJspFile());
        this.setInitParams(servletMBean.getInitParams());
        this.setLoadOnStartup(servletMBean.getLoadOnStartup());
        this.setSecurityRoleRefs(servletMBean.getSecurityRoleRefs());
        this.setRunAs(servletMBean.getRunAs());
    }

    public ServletDescriptor(WebAppDescriptor webAppDescriptor, Element element) throws DOMProcessingException {
        this.servletName = DOMUtils.getValueByTagName(element, SERVLET_NAME);
        this.servletClass = DOMUtils.getOptionalValueByTagName(element, SERVLET_CLASS);
        if (this.servletClass == null) {
            this.jspFile = DOMUtils.getOptionalValueByTagName(element, JSP_FILE);
            if (this.jspFile == null) {
                throw new DOMProcessingException("Servlet node does not contain niether servlet-class nor jsp-file nodes");
            }
        }
        this.uiData = new UIDescriptor(element);
        String string = DOMUtils.getOptionalValueByTagName(element, LOAD_ON_STARTUP);
        if (string != null) {
            try {
                this.loadSeq = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.loadSeq = -1;
            }
        }
        List list = DOMUtils.getOptionalElementsByTagName(element, INIT_PARAM);
        Iterator iterator = list.iterator();
        this.initParams = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.initParams.add(new ParameterDescriptor((Element)iterator.next()));
        }
        list = DOMUtils.getOptionalElementsByTagName(element, SECURITY_ROLE_REF);
        iterator = list.iterator();
        this.secRoleRefs = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.secRoleRefs.add(new SecurityRoleRefDescriptor(webAppDescriptor, (Element)iterator.next()));
        }
        Element element2 = DOMUtils.getOptionalElementByTagName(element, RUN_AS);
        if (element2 != null) {
            this.runAs = new RunAsDescriptor(element2);
        }
    }

    public String toString() {
        return this.getServletName();
    }

    public String getServletName() {
        return this.servletName != null ? this.servletName : "";
    }

    public void setServletName(String string) {
        String string2 = this.servletName;
        this.servletName = string;
        this.checkChange("servletName", string2, string);
    }

    public UIMBean getUIData() {
        return this.uiData;
    }

    public void setUIData(UIMBean uIMBean) {
        this.uiData = uIMBean != null ? uIMBean : new UIDescriptor();
    }

    public String getServlet() {
        if (this.servletClass != null) {
            return this.servletClass;
        }
        return this.jspFile;
    }

    public void setServlet(String string) {
        if (string.endsWith(".jsp")) {
            this.setJSPFile(string);
            this.servletClass = null;
        } else {
            this.setServletClass(string);
            this.jspFile = null;
        }
    }

    public void setServletCode(String string) {
        this.setServlet(string);
    }

    public String getServletCode() {
        return this.getServlet();
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public void setServletClass(String string) {
        String string2 = this.servletClass;
        this.servletClass = string;
        if (this.servletClass != null && (this.servletClass = this.servletClass.trim()).length() > 0) {
            this.jspFile = null;
        }
        this.checkChange("servletClass", string2, string);
    }

    public String getJSPFile() {
        return this.jspFile;
    }

    public void setJSPFile(String string) {
        String string2 = this.jspFile;
        this.jspFile = string;
        if (this.jspFile != null && (this.jspFile = this.jspFile.trim()).length() > 0) {
            this.servletClass = null;
        }
        this.checkChange("jspFile", string2, string);
    }

    public ParameterMBean[] getInitParams() {
        if (this.initParams == null) {
            return new ParameterDescriptor[0];
        }
        ParameterMBean[] parameterMBeanArray = new ParameterDescriptor[this.initParams.size()];
        this.initParams.toArray(parameterMBeanArray);
        return parameterMBeanArray;
    }

    public void setInitParams(ParameterMBean[] parameterMBeanArray) {
        ParameterMBean[] parameterMBeanArray2 = this.getInitParams();
        this.initParams = new ArrayList();
        if (parameterMBeanArray == null) {
            return;
        }
        for (int i = 0; i < parameterMBeanArray.length; ++i) {
            this.initParams.add(parameterMBeanArray[i]);
        }
        this.checkChange("initParams", parameterMBeanArray2, parameterMBeanArray);
    }

    public void addInitParam(ParameterMBean parameterMBean) {
        if (this.initParams == null) {
            this.initParams = new ArrayList();
        }
        this.initParams.add(parameterMBean);
    }

    public void removeInitParam(ParameterMBean parameterMBean) {
        if (this.initParams != null) {
            this.initParams.remove(parameterMBean);
        }
    }

    public int getLoadSequence() {
        return this.loadSeq;
    }

    public void setLoadSequence(int n) {
        int n2 = this.loadSeq;
        this.loadSeq = n;
        this.checkChange("loadSequence", n2, n);
    }

    public SecurityRoleRefMBean[] getSecurityRoleRefs() {
        if (this.secRoleRefs == null) {
            return new SecurityRoleRefDescriptor[0];
        }
        SecurityRoleRefDescriptor[] securityRoleRefDescriptorArray = new SecurityRoleRefDescriptor[this.secRoleRefs.size()];
        this.secRoleRefs.toArray(securityRoleRefDescriptorArray);
        return securityRoleRefDescriptorArray;
    }

    public void setSecurityRoleRefs(SecurityRoleRefMBean[] securityRoleRefMBeanArray) {
        SecurityRoleRefMBean[] securityRoleRefMBeanArray2 = this.getSecurityRoleRefs();
        this.secRoleRefs = new ArrayList();
        if (securityRoleRefMBeanArray == null) {
            return;
        }
        for (int i = 0; i < securityRoleRefMBeanArray.length; ++i) {
            this.secRoleRefs.add(securityRoleRefMBeanArray[i]);
        }
        this.checkChange("securityRoleRefs", securityRoleRefMBeanArray2, securityRoleRefMBeanArray);
    }

    public void addSecurityRoleRef(SecurityRoleRefMBean securityRoleRefMBean) {
        if (this.secRoleRefs == null) {
            this.secRoleRefs = new ArrayList();
        }
        this.secRoleRefs.add(securityRoleRefMBean);
    }

    public void removeSecurityRoleRef(SecurityRoleRefMBean securityRoleRefMBean) {
        if (this.secRoleRefs == null) {
            return;
        }
        this.secRoleRefs.remove(securityRoleRefMBean);
    }

    public String getSmallIconFileName() {
        return this.uiData.getSmallIconFileName();
    }

    public void setSmallIconFileName(String string) {
        String string2 = this.getSmallIconFileName();
        this.uiData.setSmallIconFileName(string);
        this.checkChange("smallIconFileName", string2, string);
    }

    public String getLargeIconFileName() {
        return this.uiData.getLargeIconFileName();
    }

    public void setLargeIconFileName(String string) {
        String string2 = this.getLargeIconFileName();
        this.uiData.setLargeIconFileName(string);
        this.checkChange("largeIconFileName", string2, string);
    }

    public String getDisplayName() {
        return this.uiData.getDisplayName();
    }

    public void setDisplayName(String string) {
        String string2 = this.getDisplayName();
        this.uiData.setDisplayName(string);
        this.checkChange("displayName", string2, string);
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public void setJspFile(String string) {
        String string2 = this.jspFile;
        this.jspFile = string;
        this.checkChange("jspFile", string2, this.jspFile);
    }

    public String getDescription() {
        return this.uiData.getDescription();
    }

    public void setDescription(String string) {
        String string2 = this.getDescription();
        this.uiData.setDescription(string);
        this.checkChange("description", string2, string);
    }

    public int getLoadOnStartup() {
        return this.loadSeq;
    }

    public void setLoadOnStartup(int n) {
        int n2 = this.loadSeq;
        this.loadSeq = n;
        this.checkChange("loadOnStartup", n2, n);
    }

    public void setRunAs(RunAsMBean runAsMBean) {
        RunAsMBean runAsMBean2 = this.runAs;
        this.runAs = runAsMBean;
        this.checkChange("runAs", runAsMBean2, runAsMBean);
    }

    public RunAsMBean getRunAs() {
        return this.runAs;
    }

    public void setInitAs(String string) {
        String string2 = this.initAs;
        this.initAs = string;
        this.checkChange("initAs", string2, string);
    }

    public String getInitAs() {
        return this.initAs;
    }

    public void setServletDescriptor(ServletDescriptorMBean servletDescriptorMBean) {
        this.servletDescriptor = servletDescriptorMBean;
    }

    public ServletDescriptorMBean getServletDescriptor() {
        return this.servletDescriptor;
    }

    public void setDestroyAs(String string) {
        String string2 = this.destroyAs;
        this.destroyAs = string;
        this.checkChange("destroyAs", string2, string);
    }

    public String getDestroyAs() {
        return this.destroyAs;
    }

    public void validate() throws DescriptorValidationException {
        boolean bl = true;
        this.removeDescriptorErrors();
        String string = this.getServletName();
        if (string == null || (string = string.trim()).length() == 0) {
            this.addDescriptorError("NO_SERVLET_NAME");
            bl = false;
        } else {
            this.setServletName(string);
        }
        string = this.getServletClass();
        if (string != null) {
            string = string.trim();
            this.setServletClass(string);
        }
        if ((string = this.getJSPFile()) != null) {
            string = string.trim();
            this.setJSPFile(string);
        }
        String string2 = this.getServletClass();
        String string3 = this.getJSPFile();
        if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            this.addDescriptorError("MULTIPLE_DEFINES_SERVLET_DEF", this.getServletName());
            bl = false;
        }
        if (!(string2 != null && string2.length() != 0 || string3 != null && string3.length() != 0)) {
            this.addDescriptorError("NO_SERVLET_DEF", this.getServletName());
            bl = false;
        }
        if (this.getRunAs() != null) {
            this.setRunAs(this.getRunAs());
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public String toXML(int n) {
        Object object;
        String string = "";
        string = string + this.indentStr(n) + "<servlet>\n";
        n += 2;
        if (this.uiData != null) {
            object = this.getSmallIconFileName();
            Object object2 = this.getLargeIconFileName();
            if (object != null || object2 != null) {
                string = string + this.indentStr(n) + "<icon>\n";
                if (object != null) {
                    string = string + this.indentStr(n + 2) + "<small-icon>" + (String)object + "</small-icon>\n";
                }
                if (object2 != null) {
                    string = string + this.indentStr(n + 2) + "<large-icon>" + (String)object2 + "</large-icon>\n";
                }
                string = string + this.indentStr(n) + "</icon>\n";
            }
        }
        string = string + this.indentStr(n) + "<servlet-name>" + this.servletName + "</servlet-name>\n";
        if (this.uiData != null) {
            object = this.getDisplayName();
            if (object != null && ((String)(object = ((String)object).trim())).length() > 0) {
                string = string + this.indentStr(n) + "<display-name>" + ServletDescriptor.cdata((String)object) + "</display-name>\n";
            }
            if ((object = this.getDescription()) != null && ((String)(object = ((String)object).trim())).length() > 0) {
                string = string + this.indentStr(n) + "<description>" + ServletDescriptor.cdata((String)object) + "</description>\n";
            }
        }
        string = this.servletClass != null ? string + this.indentStr(n) + "<servlet-class>" + this.servletClass + "</servlet-class>\n" : string + this.indentStr(n) + "<jsp-file>" + this.jspFile + "</jsp-file>\n";
        if (this.initParams != null) {
            for (Object object2 : this.initParams) {
                string = string + this.indentStr(n) + "<init-param>\n";
                string = string + this.indentStr(n += 2) + "<param-name>" + ((ParameterDescriptor)object2).getParamName() + "</param-name>\n";
                string = string + this.indentStr(n) + "<param-value>" + ((ParameterDescriptor)object2).getParamValue() + "</param-value>\n";
                String string2 = ((ParameterDescriptor)object2).getDescription();
                if (string2 != null) {
                    string = string + this.indentStr(n) + "<description>" + string2 + "</description>\n";
                }
                string = string + this.indentStr(n -= 2) + "</init-param>\n";
            }
        }
        if (this.runAs != null) {
            string = string + this.runAs.toXML(n);
        }
        if (this.loadSeq != -1) {
            string = string + this.indentStr(n) + "<load-on-startup>" + this.loadSeq + "</load-on-startup>\n";
        }
        if (this.secRoleRefs != null) {
            for (Object object2 : this.secRoleRefs) {
                string = string + ((SecurityRoleRefDescriptor)object2).toXML(n);
            }
        }
        string = string + this.indentStr(n -= 2) + "</servlet>\n";
        return string;
    }
}

