/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.DescriptorConstants;
import weblogic.xml.dom.ResourceEntityResolver;

public final class ServletEntityResolver
extends ResourceEntityResolver
implements DescriptorConstants {
    private static final boolean debug = false;
    private String rootDir;

    public ServletEntityResolver() {
        this.addEntityResource("-//Sun Microsystems, Inc.//DTD Web Application 1.2//EN", "web-jar.dtd", this.getClass());
        this.addEntityResource("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "web-jar.dtd", this.getClass());
        this.addEntityResource("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "web-jar-23.dtd", this.getClass());
        this.addEntityResource("-//BEA Systems, Inc.//DTD Web Application 6.0//EN", "weblogic-web-jar.dtd", this.getClass());
        this.addEntityResource("-//BEA Systems, Inc.//DTD Web Application 6.1//EN", "weblogic-web-jar.dtd", this.getClass());
        this.addEntityResource("-//BEA Systems, Inc.//DTD Web Application 7.0//EN", "weblogic700-web-jar.dtd", this.getClass());
        this.addEntityResource("-//BEA Systems, Inc.//DTD Web Application 8.1//EN", "weblogic810-web-jar.dtd", this.getClass());
    }

    public ServletEntityResolver(String string) {
        this();
        this.rootDir = string;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        InputSource inputSource;
        if ("-//Sun Microsystems, Inc.//DTD Web Application 1.2//EN".equals(string) || "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(string)) {
            if (this.rootDir == null) {
                this.rootDir = "";
            }
            HTTPLogger.logOldPublicIDWarningWithContext((String)this.rootDir, (String)"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN");
        }
        try {
            inputSource = super.resolveEntity(string, string2);
        }
        catch (SAXException sAXException) {
            HTTPLogger.logErrorResolvingServletEntity((String)string, (String)this.rootDir, (Throwable)sAXException);
            throw sAXException;
        }
        if (inputSource == null) {
            HTTPLogger.logCouldNotResolveServletEntity((String)string, (String)this.rootDir);
        }
        return inputSource;
    }
}

