/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.ServletMBean;
import weblogic.management.descriptors.webapp.ServletMappingMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.internal.dd.WebAppDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class ServletMappingDescriptor
extends BaseServletDescriptor
implements ToXML,
ServletMappingMBean {
    private static final long serialVersionUID = -2074799428020037595L;
    private static final String refErr = "servlet-mapping references a servlet that has not been defined";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String URL_PATTERN = "url-pattern";
    private ServletMBean servlet;
    private String urlPattern;
    private String servletNameLink;

    public ServletMappingDescriptor() {
        this.servlet = null;
        this.urlPattern = "";
    }

    public ServletMappingDescriptor(WebAppDescriptor webAppDescriptor, ServletMappingMBean servletMappingMBean) {
        this(servletMappingMBean.getServlet(), servletMappingMBean.getURLPattern());
    }

    public ServletMappingDescriptor(ServletMBean servletMBean, String string) {
        this.servlet = servletMBean;
        this.urlPattern = string;
    }

    public ServletMappingDescriptor(WebAppDescriptor webAppDescriptor, String string, String string2) {
        this.setServlet(webAppDescriptor, string);
        this.urlPattern = string2;
    }

    public ServletMappingDescriptor(WebAppDescriptor webAppDescriptor, Element element) throws DOMProcessingException {
        this.urlPattern = DOMUtils.getValueByTagName(element, URL_PATTERN);
        String string = DOMUtils.getValueByTagName(element, SERVLET_NAME);
        if (webAppDescriptor != null) {
            this.setServlet(webAppDescriptor, string);
        }
    }

    private void setServlet(WebAppDescriptor webAppDescriptor, String string) {
        if (webAppDescriptor == null) {
            HTTPLogger.logServletNotFound((String)string);
            return;
        }
        if (string == null) {
            HTTPLogger.logServletNotFound((String)"null");
            return;
        }
        ServletMBean[] servletMBeanArray = webAppDescriptor.getServlets();
        if (servletMBeanArray == null) {
            HTTPLogger.logServletNotFound((String)string);
            this.servletNameLink = string;
            return;
        }
        for (int i = 0; i < servletMBeanArray.length; ++i) {
            if (servletMBeanArray[i] == null || !string.equals(servletMBeanArray[i].getServletName())) continue;
            this.servlet = servletMBeanArray[i];
            break;
        }
        if (this.servlet == null) {
            this.servletNameLink = string;
            HTTPLogger.logServletNotFound((String)string);
            return;
        }
    }

    public ServletMBean getServlet() {
        return this.servlet;
    }

    public void setServlet(ServletMBean servletMBean) {
        ServletMBean servletMBean2 = this.servlet;
        this.servlet = servletMBean;
        if (!ServletMappingDescriptor.comp(servletMBean2, servletMBean)) {
            this.firePropertyChange("servlet", servletMBean2, servletMBean);
        }
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public void setURLPattern(String string) {
        String string2 = this.urlPattern;
        this.urlPattern = string;
        if (!ServletMappingDescriptor.comp(string2, string)) {
            this.firePropertyChange("urlPattern", string2, string);
        }
    }

    public void validate() throws DescriptorValidationException {
        boolean bl = true;
        this.removeDescriptorErrors();
        ServletMBean servletMBean = this.getServlet();
        String string = this.getURLPattern();
        if (string != null) {
            string = string.trim();
            this.setURLPattern(string);
        }
        if (string == null || string.length() == 0) {
            this.addDescriptorError("NO_URL_PATTERN", servletMBean == null ? "" : servletMBean.getServletName());
            bl = false;
        }
        if (servletMBean == null) {
            this.addDescriptorError("NO_MAPPING_SERVLET_NAME", string);
            bl = false;
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        ServletMBean servletMBean = this.getServlet();
        String string2 = servletMBean == null ? this.servletNameLink : servletMBean.getServletName();
        string = string + this.indentStr(n) + "<servlet-mapping>\n";
        string = string + this.indentStr(n + 2) + "<servlet-name>" + string2 + "</servlet-name>\n";
        string = string + this.indentStr(n + 2) + "<url-pattern>" + this.urlPattern + "</url-pattern>\n";
        string = string + this.indentStr(n) + "</servlet-mapping>\n";
        return string;
    }
}

