/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.SessionConfigMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class SessionDescriptor
extends BaseServletDescriptor
implements ToXML,
SessionConfigMBean {
    private static final long serialVersionUID = 4376958427997195978L;
    private static final String SESSION_TIMEOUT = "session-timeout";
    private int sessionTimeout = -2;

    public SessionDescriptor() {
    }

    public SessionDescriptor(SessionConfigMBean sessionConfigMBean) {
        this.setSessionTimeout(sessionConfigMBean.getSessionTimeout());
    }

    public SessionDescriptor(int n) {
        this.sessionTimeout = n;
    }

    public SessionDescriptor(Element element) throws DOMProcessingException {
        String string = DOMUtils.getOptionalValueByTagName(element, SESSION_TIMEOUT);
        if (string != null) {
            try {
                this.sessionTimeout = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int n) {
        int n2 = this.sessionTimeout;
        this.sessionTimeout = n;
        if (n2 != n) {
            this.firePropertyChange("sessionTimeout", new Integer(n2), new Integer(n));
        }
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
        if (this.sessionTimeout != -2 && this.sessionTimeout < 0) {
            this.addDescriptorError("INVALID_SESSION_TIMEOUT", "" + this.sessionTimeout);
            throw new DescriptorValidationException("INVALID_SESSION_TIMEOUT");
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        if (this.sessionTimeout != -2) {
            string = string + this.indentStr(n) + "<session-config>\n";
            string = string + this.indentStr(n += 2) + "<session-timeout>" + this.sessionTimeout + "</session-timeout>\n";
            string = string + this.indentStr(n -= 2) + "</session-config>\n";
        }
        return string;
    }
}

