/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.TLDMBean;
import weblogic.management.descriptors.webapp.TagLibMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.jsp.dd.TLDDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class TaglibDescriptor
extends BaseServletDescriptor
implements ToXML,
TagLibMBean {
    private static final long serialVersionUID = -2310746458588034306L;
    private static final String TAGLIB = "taglib";
    private static final String TAGLIB_URI = "taglib-uri";
    private static final String TAGLIB_LOCATION = "taglib-location";
    private String uri;
    private String location;
    private TLDDescriptor tld;

    public TaglibDescriptor(TagLibMBean tagLibMBean) {
        this(tagLibMBean.getURI(), tagLibMBean.getLocation());
    }

    public TaglibDescriptor() {
        this("", "");
    }

    public TaglibDescriptor(String string, String string2) {
        this.uri = string;
        this.location = string2;
    }

    public TaglibDescriptor(Element element) throws DOMProcessingException {
        this.uri = DOMUtils.getValueByTagName(element, TAGLIB_URI);
        this.location = DOMUtils.getValueByTagName(element, TAGLIB_LOCATION);
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String string) {
        String string2 = this.uri;
        this.uri = string;
        if (!TaglibDescriptor.comp(string2, string)) {
            this.firePropertyChange("uri", string2, string);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        String string2 = this.location;
        this.location = string;
        if (!TaglibDescriptor.comp(string2, string)) {
            this.firePropertyChange("location", string2, string);
        }
    }

    public TLDMBean getTLD() {
        return this.tld;
    }

    public void setTLD(TLDMBean tLDMBean) {
        this.tld = (TLDDescriptor)tLDMBean;
    }

    public void validate() throws DescriptorValidationException {
        String string;
        boolean bl = true;
        this.removeDescriptorErrors();
        String string2 = this.getURI();
        if (string2 != null) {
            string2 = string2.trim();
            this.setURI(string2);
        }
        if ((string = this.getLocation()) != null) {
            string = string.trim();
            this.setLocation(string);
        }
        if (string2 == null || string2.length() == 0) {
            this.addDescriptorError("NO_TAGLIB_URI");
            bl = false;
        }
        if (string == null || string.length() == 0) {
            this.addDescriptorError("NO_TAGLIB_LOCATION", string2);
            bl = false;
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<taglib>\n";
        string = string + this.indentStr(n += 2) + "<taglib-uri>" + this.uri + "</taglib-uri>\n";
        string = string + this.indentStr(n) + "<taglib-location>" + this.location + "</taglib-location>\n";
        string = string + this.indentStr(n -= 2) + "</taglib>\n";
        return string;
    }
}

