/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.UIMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class UIDescriptor
extends BaseServletDescriptor
implements UIMBean {
    private static final long serialVersionUID = 6939835176059638336L;
    public static final String DESCRIPTION = "description";
    public static final String DISPLAY_NAME = "display-name";
    public static final String LARGE_ICON = "large-icon";
    public static final String SMALL_ICON = "small-icon";
    public static final String ICON = "icon";
    private String description;
    private String displayName;
    private String largeIconFileName;
    private String smallIconFileName;

    public UIDescriptor() {
        this(null, null, null, null);
    }

    public UIDescriptor(String string, String string2, String string3, String string4) {
        this.description = string;
        this.displayName = string2;
        this.largeIconFileName = string3;
        this.smallIconFileName = string4;
    }

    public UIDescriptor(UIMBean uIMBean) {
        this(uIMBean.getDescription(), uIMBean.getDisplayName(), uIMBean.getLargeIconFileName(), uIMBean.getSmallIconFileName());
    }

    public UIDescriptor(Element element) throws DOMProcessingException {
        Element element2;
        this.description = DOMUtils.getOptionalValueByTagName(element, DESCRIPTION);
        this.displayName = DOMUtils.getOptionalValueByTagName(element, DISPLAY_NAME);
        this.largeIconFileName = DOMUtils.getOptionalValueByTagName(element, LARGE_ICON);
        this.smallIconFileName = DOMUtils.getOptionalValueByTagName(element, SMALL_ICON);
        if (this.largeIconFileName == null && this.smallIconFileName == null && (element2 = DOMUtils.getOptionalElementByTagName(element, ICON)) != null) {
            this.largeIconFileName = DOMUtils.getOptionalValueByTagName(element2, LARGE_ICON);
            this.smallIconFileName = DOMUtils.getOptionalValueByTagName(element2, SMALL_ICON);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!UIDescriptor.comp(string2, string)) {
            this.firePropertyChange(DESCRIPTION, string2, string);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        String string2 = this.displayName;
        this.displayName = string;
        if (!UIDescriptor.comp(string2, string)) {
            this.firePropertyChange("displayName", string2, string);
        }
    }

    public String getLargeIconFileName() {
        return this.largeIconFileName;
    }

    public void setLargeIconFileName(String string) {
        String string2 = this.largeIconFileName;
        this.largeIconFileName = string;
        if (!UIDescriptor.comp(string2, string)) {
            this.firePropertyChange("largeIconFileName", string2, string);
        }
    }

    public String getSmallIconFileName() {
        return this.smallIconFileName;
    }

    public void setSmallIconFileName(String string) {
        String string2 = this.smallIconFileName;
        this.smallIconFileName = string;
        if (!UIDescriptor.comp(string2, string)) {
            this.firePropertyChange("smallIconFileName", string2, string);
        }
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        String string2 = this.getSmallIconFileName();
        String string3 = this.getLargeIconFileName();
        if (string2 != null || string3 != null) {
            string = string + this.indentStr(n) + "<icon>\n";
            if (string2 != null) {
                string = string + this.indentStr(n + 2) + "<small-icon>" + string2 + "</small-icon>\n";
            }
            if (string3 != null) {
                string = string + this.indentStr(n + 2) + "<large-icon>" + string3 + "</large-icon>\n";
            }
            string = string + this.indentStr(n) + "</icon>\n";
        }
        if (this.getDisplayName() != null) {
            string = string + this.indentStr(n) + "<display-name>" + this.getDisplayName() + "</display-name>\n";
        }
        if (this.getDescription() != null) {
            string = string + this.indentStr(n) + "<description>" + this.getDescription() + "</description>\n";
        }
        return string;
    }
}

