/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webappext.URLMatchMapMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;

public class URLMatchMapDescriptor
extends BaseServletDescriptor
implements ToXML,
URLMatchMapMBean {
    private static final String URL_MATCH_MAP = "url-match-map";
    private String mapClass;

    public URLMatchMapDescriptor() {
    }

    public URLMatchMapDescriptor(String string) {
        this.mapClass = string;
    }

    public URLMatchMapDescriptor(URLMatchMapMBean uRLMatchMapMBean) {
        if (uRLMatchMapMBean != null) {
            this.mapClass = uRLMatchMapMBean.getClassName();
        }
    }

    public void validate() throws DescriptorValidationException {
        boolean bl = true;
        this.removeDescriptorErrors();
        String string = this.getClassName();
        if (string == null || string.length() == 0) {
            this.addDescriptorError("NO_URL_MATCH_MAP_CLASS");
            bl = false;
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String getClassName() {
        return this.mapClass;
    }

    public void setClassName(String string) {
        String string2 = this.mapClass;
        this.mapClass = string;
        if (!URLMatchMapDescriptor.comp(string2, string)) {
            this.firePropertyChange("className", string2, string);
        }
    }

    public String toXML(int n) {
        if (this.mapClass != null) {
            this.mapClass = this.mapClass.trim();
            if (this.mapClass.length() == 0) {
                this.mapClass = null;
            }
        }
        if (this.mapClass != null) {
            String string = "";
            string = string + this.indentStr(n) + "<" + URL_MATCH_MAP + ">\n";
            string = string + this.indentStr(n += 2) + this.mapClass + "\n";
            string = string + this.indentStr(n -= 2) + "</" + URL_MATCH_MAP + ">\n";
            return string;
        }
        return "";
    }
}

