/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.UserDataConstraintMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;

public final class UserDataConstraint
extends BaseServletDescriptor
implements UserDataConstraintMBean {
    private static final long serialVersionUID = 4772501842036136387L;
    public static final String NONE = "NONE";
    public static final String INTEGRAL = "INTEGRAL";
    public static final String CONFIDENTIAL = "CONFIDENTIAL";
    String description;
    String transportGuarantee;

    public UserDataConstraint() {
    }

    public UserDataConstraint(UserDataConstraintMBean userDataConstraintMBean) {
        if (userDataConstraintMBean != null) {
            this.setDescription(userDataConstraintMBean.getDescription());
            this.setTransportGuarantee(userDataConstraintMBean.getTransportGuarantee());
        } else {
            this.transportGuarantee = NONE;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!UserDataConstraint.comp(string2, string)) {
            this.firePropertyChange("description", string2, string);
        }
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public void setTransportGuarantee(String string) {
        String string2 = this.transportGuarantee;
        this.transportGuarantee = string;
        if (!UserDataConstraint.comp(string2, string)) {
            this.firePropertyChange("transportGuarantee", string2, string);
        }
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toString() {
        String string = "AuthConstraintDescriptor(";
        string = string + "guarantee=" + this.transportGuarantee;
        string = string + ")";
        return string;
    }

    public String toXML(int n) {
        String string = "";
        String string2 = NONE;
        if (INTEGRAL.equals(this.getTransportGuarantee())) {
            string2 = INTEGRAL;
        } else if (CONFIDENTIAL.equals(this.getTransportGuarantee())) {
            string2 = CONFIDENTIAL;
        }
        string = string + this.indentStr(n) + "<user-data-constraint>\n";
        n += 2;
        if (this.description != null) {
            string = string + this.indentStr(n) + "<description>" + this.description + "</description>\n";
        }
        string = string + this.indentStr(n) + "<transport-guarantee>" + string2 + "</transport-guarantee>\n";
        string = string + this.indentStr(n -= 2) + "</user-data-constraint>\n";
        return string;
    }
}

