/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webappext.VirtualDirectoryMappingMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class VirtualDirectoryMappingDescriptor
extends BaseServletDescriptor
implements VirtualDirectoryMappingMBean,
ToXML {
    private static final String VIRTUAL_DIRECTORY_MAPPING = "virtual-directory-mapping";
    private static final String LOCAL_PATH = "local-path";
    private static final String URL_PATTERN = "url-pattern";
    private String localPath = null;
    private String[] urlPatterns = null;
    private static String refErr = "Invalid virtual-directory-mapping in weblogic.xml";

    public VirtualDirectoryMappingDescriptor() {
        this.localPath = null;
        this.urlPatterns = null;
    }

    public VirtualDirectoryMappingDescriptor(String string, String[] stringArray) throws DOMProcessingException {
        this.localPath = string;
        this.urlPatterns = stringArray;
    }

    public VirtualDirectoryMappingDescriptor(VirtualDirectoryMappingMBean virtualDirectoryMappingMBean) throws DOMProcessingException {
        this(virtualDirectoryMappingMBean.getLocalPath(), virtualDirectoryMappingMBean.getURLPatterns());
    }

    public VirtualDirectoryMappingDescriptor(Element element) throws DOMProcessingException {
        this.setLocalPath(DOMUtils.getOptionalValueByTagName(element, LOCAL_PATH));
        List list = DOMUtils.getValuesByTagName(element, URL_PATTERN);
        if (list == null) {
            this.setURLPatterns(new String[0]);
        } else {
            Iterator iterator = list.iterator();
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            this.setURLPatterns(stringArray);
        }
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String string) {
        String string2 = this.localPath;
        this.localPath = string;
        if (!VirtualDirectoryMappingDescriptor.comp(string2, string)) {
            this.firePropertyChange("localPath", string2, string);
        }
    }

    public String[] getURLPatterns() {
        return this.urlPatterns;
    }

    public void setURLPatterns(String[] stringArray) {
        String[] stringArray2 = this.urlPatterns;
        this.urlPatterns = stringArray;
        if (!VirtualDirectoryMappingDescriptor.comp(stringArray2, stringArray)) {
            this.firePropertyChange("urlPatterns", stringArray2, stringArray);
        }
    }

    public void validate() throws DescriptorValidationException {
        boolean bl = true;
        this.removeDescriptorErrors();
        if (this.localPath == null) {
            this.addDescriptorError("local-path is not set in virtual-directory-mapping");
            bl = false;
        }
        if (this.urlPatterns != null) {
            for (int i = 0; i < this.urlPatterns.length; ++i) {
                if (this.urlPatterns[i] != null) continue;
                this.addDescriptorError("url-pattern is null in virtual-directory-mapping");
                bl = false;
            }
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<" + VIRTUAL_DIRECTORY_MAPPING + ">\n";
        n += 2;
        if (this.localPath != null) {
            string = string + this.indentStr(n) + "<" + LOCAL_PATH + ">" + this.localPath + "</" + LOCAL_PATH + ">\n";
        }
        if (this.urlPatterns != null) {
            for (int i = 0; i < this.urlPatterns.length; ++i) {
                string = string + this.indentStr(n) + "<" + URL_PATTERN + ">" + this.urlPatterns[i] + "</" + URL_PATTERN + ">\n";
            }
        }
        string = string + this.indentStr(n -= 2) + "</" + VIRTUAL_DIRECTORY_MAPPING + ">\n";
        return string;
    }
}

