/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webappext.JspDescriptorMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ParameterDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class WLJspDescriptor
extends BaseServletDescriptor
implements ToXML,
JspDescriptorMBean {
    private static final String JSP_PARAM = "jsp-param";
    private List jspParams;

    public WLJspDescriptor() {
        this.jspParams = new ArrayList();
    }

    public WLJspDescriptor(List list) {
        this.jspParams = list;
    }

    public WLJspDescriptor(JspDescriptorMBean jspDescriptorMBean) {
        this();
        if (jspDescriptorMBean != null) {
            this.setDefaultFileName(jspDescriptorMBean.getDefaultFileName());
            this.setCompileCommand(jspDescriptorMBean.getCompileCommand());
            this.setPrecompile(jspDescriptorMBean.isPrecompile());
            this.setPrecompile(jspDescriptorMBean.isPrecompileContinue());
            this.setCompilerClass(jspDescriptorMBean.getCompilerClass());
            this.setCompileFlags(jspDescriptorMBean.getCompileFlags());
            this.setWorkingDir(jspDescriptorMBean.getWorkingDir());
            this.setVerbose(jspDescriptorMBean.isVerbose());
            this.setCompilerSupportsEncoding(jspDescriptorMBean.getCompilerSupportsEncoding());
            this.setKeepgenerated(jspDescriptorMBean.isKeepgenerated());
            this.setPageCheckSeconds(jspDescriptorMBean.getPageCheckSeconds());
            this.setEncoding(jspDescriptorMBean.getEncoding());
            this.setPackagePrefix(jspDescriptorMBean.getPackagePrefix());
            this.setSuperclass(jspDescriptorMBean.getSuperclass());
            this.setNoTryBlocks(jspDescriptorMBean.isNoTryBlocks());
            this.setDebugEnabled(jspDescriptorMBean.isDebugEnabled());
            this.setBackwardCompatible(jspDescriptorMBean.isBackwardCompatible());
            this.setPrintNulls(jspDescriptorMBean.getPrintNulls());
            this.setJspServlet(jspDescriptorMBean.getJspServlet());
            this.setJspPrecompiler(jspDescriptorMBean.getJspPrecompiler());
        }
    }

    public WLJspDescriptor(Element element) throws DOMProcessingException {
        List list = DOMUtils.getOptionalElementsByTagName(element, JSP_PARAM);
        Iterator iterator = list.iterator();
        this.jspParams = new ArrayList(list.size());
        while (iterator.hasNext()) {
            ParameterDescriptor parameterDescriptor = new ParameterDescriptor((Element)iterator.next());
            String string = parameterDescriptor.getParamName();
            if (WLJspDescriptor.isValidParam(string)) {
                this.jspParams.add(parameterDescriptor);
                continue;
            }
            if (string != null && string.length() == 0) {
                HTTPLogger.logEmptyJspParamName();
            } else {
                HTTPLogger.logInvalidJspParamName((String)string);
            }
            throw new DOMProcessingException();
        }
    }

    private static boolean isValidParam(String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("defaultFileName") || string.equalsIgnoreCase("compileCommand") || string.equalsIgnoreCase("compileFlags") || string.equalsIgnoreCase("compilerclass") || string.equalsIgnoreCase("workingDir") || string.equalsIgnoreCase("verbose") || string.equalsIgnoreCase("keepgenerated") || string.equalsIgnoreCase("compilerSupportsEncoding") || string.equalsIgnoreCase("pageCheckSeconds") || string.equalsIgnoreCase("encoding") || string.equalsIgnoreCase("packagePrefix") || string.equalsIgnoreCase("noTryBlocks") || string.equalsIgnoreCase("precompile") || string.equalsIgnoreCase("precompileContinue") || string.equalsIgnoreCase("exactMapping") || string.equalsIgnoreCase("superclass") || string.equalsIgnoreCase("debug") || string.equalsIgnoreCase("backwardCompatible") || string.equalsIgnoreCase("printNulls") || string.equalsIgnoreCase("jspServlet") || string.equalsIgnoreCase("jspPrecompiler");
    }

    private static boolean isDefaultValue(String string, String string2) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("verbose") && string2.equals("true") || string.equalsIgnoreCase("keepgenerated") && string2.equals("false") || string.equalsIgnoreCase("compilerSupportsEncoding") && string2.equals("true") || string.equalsIgnoreCase("pageCheckSeconds") && string2.equals("1") || string.equalsIgnoreCase("packagePrefix") && string2.equals("jsp_servlet") || string.equalsIgnoreCase("noTryBlocks") && string2.equals("false") || string.equalsIgnoreCase("precompile") && string2.equals("false") || string.equalsIgnoreCase("precompileContinue") && string2.equals("false") || string.equalsIgnoreCase("exactMapping") && string2.equals("true") || string.equalsIgnoreCase("superclass") && string2.equals("weblogic.servlet.jsp.JspBase") || string.equalsIgnoreCase("debug") && string2.equals("false") || string.equalsIgnoreCase("backwardCompatible") && string2.equals("false") || string.equalsIgnoreCase("printNulls") && string2.equals("true");
    }

    public String getDefaultFileName() {
        return this.getProp("defaultFilename", "index.jsp");
    }

    public void setDefaultFileName(String string) {
        String string2 = this.getDefaultFileName();
        this.setProp("defaultFilename", string);
        if (!WLJspDescriptor.comp(string2, string)) {
            this.firePropertyChange("defaultFilename", string2, string);
        }
    }

    public boolean isNoTryBlocks() {
        return "true".equalsIgnoreCase(this.getProp("noTryBlocks", "false"));
    }

    public void setNoTryBlocks(boolean bl) {
        boolean bl2 = this.isNoTryBlocks();
        this.setProp("noTryBlocks", "" + bl);
        if (bl2 != bl) {
            this.firePropertyChange("noTryBlocks", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isPrecompile() {
        boolean bl = "true".equalsIgnoreCase(this.getProp("precompile", "false"));
        return bl;
    }

    public void setPrecompile(boolean bl) {
        boolean bl2 = this.isPrecompile();
        this.setProp("precompile", "" + bl);
        if (bl2 != bl) {
            this.firePropertyChange("precompile", new Boolean(bl2), new Boolean(bl));
        }
    }

    public boolean isPrecompileContinue() {
        boolean bl = "true".equalsIgnoreCase(this.getProp("precompileContinue", "false"));
        return bl;
    }

    public void setPrecompileContinue(boolean bl) {
        boolean bl2 = this.isPrecompileContinue();
        this.setProp("precompileContinue", "" + bl);
        if (bl2 != bl) {
            this.firePropertyChange("precompileContinue", new Boolean(bl2), new Boolean(bl));
        }
    }

    public boolean isExactMapping() {
        boolean bl = "true".equalsIgnoreCase(this.getProp("exactMapping", "true"));
        return bl;
    }

    public void setExactMapping(boolean bl) {
        boolean bl2 = this.isExactMapping();
        this.setProp("exactMapping", "" + bl);
        if (bl != bl2) {
            this.firePropertyChange("exactMapping", new Boolean(bl2), new Boolean(bl));
        }
    }

    public String getSuperclass() {
        return this.getProp("superclass", "weblogic.servlet.jsp.JspBase");
    }

    public void setSuperclass(String string) {
        String string2 = this.getSuperclass();
        this.setProp("superclass", string);
        if (!WLJspDescriptor.comp(string2, string)) {
            this.firePropertyChange("superclass", string2, string);
        }
    }

    public String getCompileCommand() {
        return this.getProp("compileCommand", null);
    }

    public void setCompileCommand(String string) {
        String string2 = this.getCompileCommand();
        this.setProp("compileCommand", string);
        if (!WLJspDescriptor.comp(string2, string)) {
            this.firePropertyChange("compileCommand", string2, string);
        }
    }

    public String getCompileFlags() {
        return this.getProp("compileFlags", null);
    }

    public void setCompileFlags(String string) {
        String string2 = this.getCompileFlags();
        this.setProp("compileFlags", string);
        if (!WLJspDescriptor.comp(string2, string)) {
            this.firePropertyChange("compileFlags", string2, string);
        }
    }

    public String getCompilerClass() {
        return this.getProp("compilerclass", null);
    }

    public void setCompilerClass(String string) {
        String string2 = this.getCompilerClass();
        this.setProp("compilerclass", string);
        if (!WLJspDescriptor.comp(string2, string)) {
            this.firePropertyChange("compilerclass", string2, string);
        }
    }

    public String getWorkingDir() {
        return this.getProp("workingDir", null);
    }

    public void setWorkingDir(String string) {
        if (string != null && (string = string.trim()).length() > 0) {
            String string2 = this.getWorkingDir();
            this.setProp("workingDir", string);
            if (!WLJspDescriptor.comp(string2, string)) {
                this.firePropertyChange("workingDir", string2, string);
            }
        }
    }

    public String getEncoding() {
        return this.getProp("encoding", null);
    }

    public void setEncoding(String string) {
        if (string != null && (string = string.trim()).length() > 0) {
            String string2 = this.getEncoding();
            this.setProp("encoding", string);
            if (!WLJspDescriptor.comp(string2, string)) {
                this.firePropertyChange("encoding", string2, string);
            }
        }
    }

    public boolean getCompilerSupportsEncoding() {
        return !"false".equalsIgnoreCase(this.getProp("compilerSupportsEncoding", "true"));
    }

    public void setCompilerSupportsEncoding(boolean bl) {
        boolean bl2 = this.getCompilerSupportsEncoding();
        this.setProp("compilerSupportsEncoding", "" + bl);
        if (bl != bl2) {
            this.firePropertyChange("compilerSupportsEncoding", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean getVerbose() {
        return this.isVerbose();
    }

    public boolean isVerbose() {
        return !"false".equalsIgnoreCase(this.getProp("verbose", "true"));
    }

    public void setVerbose(boolean bl) {
        boolean bl2 = this.isVerbose();
        this.setProp("verbose", "" + bl);
        if (bl2 != bl) {
            this.firePropertyChange("verbose", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean getKeepgenerated() {
        return this.isKeepgenerated();
    }

    public boolean isKeepgenerated() {
        return "true".equalsIgnoreCase(this.getProp("keepgenerated", "false"));
    }

    public void setKeepgenerated(boolean bl) {
        boolean bl2 = this.isKeepgenerated();
        this.setProp("keepgenerated", "" + bl);
        if (bl2 != bl) {
            this.firePropertyChange("keepgenerated", new Boolean(!bl), new Boolean(bl));
        }
    }

    public int getPageCheckSeconds() {
        String string = this.getProp("pageCheckSeconds", "1");
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }

    public void setPageCheckSeconds(int n) {
        int n2 = this.getPageCheckSeconds();
        this.setProp("pageCheckSeconds", "" + n);
        if (n2 != n) {
            this.firePropertyChange("pageCheckSeconds", new Integer(n2), new Integer(n));
        }
    }

    public String getPackagePrefix() {
        return this.getProp("packagePrefix", "jsp_servlet");
    }

    public void setPackagePrefix(String string) {
        if (string != null && (string = string.trim()).length() > 0) {
            String string2 = this.getPackagePrefix();
            this.setProp("packagePrefix", string);
            if (!WLJspDescriptor.comp(string2, string)) {
                this.firePropertyChange("packagePrefix", string2, string);
            }
        }
    }

    public void setDebugEnabled(boolean bl) {
        if (bl != this.isDebugEnabled()) {
            this.setProp("debug", "" + bl);
            this.firePropertyChange("debug", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isDebugEnabled() {
        return "true".equalsIgnoreCase(this.getProp("debug", "false"));
    }

    public boolean getDebugEnabled() {
        return this.isDebugEnabled();
    }

    public void setBackwardCompatible(boolean bl) {
        if (bl != this.isBackwardCompatible()) {
            this.setProp("backwardCompatible", "" + bl);
            this.firePropertyChange("backwardCompatible", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isBackwardCompatible() {
        return "true".equalsIgnoreCase(this.getProp("backwardCompatible", "false"));
    }

    public boolean getBackwardCompatible() {
        return this.isBackwardCompatible();
    }

    public void setPrintNulls(boolean bl) {
        if (bl != this.getPrintNulls()) {
            this.setProp("printNulls", "" + bl);
            this.firePropertyChange("printNulls", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean getPrintNulls() {
        return !"false".equalsIgnoreCase(this.getProp("printNulls", "true"));
    }

    public String getJspServlet() {
        return this.getProp("jspServlet", "");
    }

    public void setJspServlet(String string) {
        String string2 = this.getJspServlet();
        this.setProp("jspServlet", string);
        if (!WLJspDescriptor.comp(string2, string)) {
            this.firePropertyChange("jspServlet", string2, string);
        }
    }

    public String getJspPrecompiler() {
        return this.getProp("jspPrecompiler", "");
    }

    public void setJspPrecompiler(String string) {
        String string2 = this.getJspPrecompiler();
        this.setProp("jspPrecompiler", string);
        if (!WLJspDescriptor.comp(string2, string)) {
            this.firePropertyChange("jspPrecompiler", string2, string);
        }
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    private void setProp(String string, String string2) {
        for (ParameterDescriptor parameterDescriptor : this.jspParams) {
            if (!string.equalsIgnoreCase(parameterDescriptor.getParamName())) continue;
            if (string2 == null) {
                this.jspParams.remove(parameterDescriptor);
            } else {
                parameterDescriptor.setParamName(string);
                parameterDescriptor.setParamValue(string2);
            }
            return;
        }
        if (string2 != null) {
            ParameterDescriptor parameterDescriptor;
            parameterDescriptor = new ParameterDescriptor();
            parameterDescriptor.setParamName(string);
            parameterDescriptor.setParamValue(string2);
            this.jspParams.add(parameterDescriptor);
        }
    }

    private String getProp(String string, String string2) {
        for (ParameterDescriptor parameterDescriptor : this.jspParams) {
            if (!string.equalsIgnoreCase(parameterDescriptor.getParamName())) continue;
            parameterDescriptor.setParamName(string);
            return parameterDescriptor.getParamValue();
        }
        if (string2 != null && string2.length() > 0) {
            ParameterDescriptor parameterDescriptor;
            parameterDescriptor = new ParameterDescriptor();
            parameterDescriptor.setParamName(string);
            parameterDescriptor.setParamValue(string2);
            this.jspParams.add(parameterDescriptor);
        }
        return string2;
    }

    public String toXML(int n) {
        String string = "";
        boolean bl = false;
        if (this.jspParams != null && this.jspParams.size() > 0) {
            for (ParameterDescriptor parameterDescriptor : this.jspParams) {
                if (WLJspDescriptor.isDefaultValue(parameterDescriptor.getParamName(), parameterDescriptor.getParamValue())) continue;
                if (!bl) {
                    string = string + this.indentStr(n) + "<jsp-descriptor>\n";
                    n += 2;
                    bl = true;
                }
                string = string + this.indentStr(n) + "<jsp-param>\n";
                string = string + this.indentStr(n += 2) + "<param-name>" + parameterDescriptor.getParamName() + "</param-name>\n";
                string = string + this.indentStr(n) + "<param-value>" + parameterDescriptor.getParamValue() + "</param-value>\n";
                string = string + this.indentStr(n -= 2) + "</jsp-param>\n";
            }
            if (bl) {
                string = string + this.indentStr(n -= 2) + "</jsp-descriptor>\n";
            }
        }
        return string;
    }
}

