/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.ServletMBean;
import weblogic.management.descriptors.webappext.ServletDescriptorMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.WebAppDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class WLServletDescriptor
extends BaseServletDescriptor
implements ServletDescriptorMBean {
    private static final String SERVLET_DESCRIPTOR = "servlet-descriptor";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String RUN_AS_PRINCIPAL_NAME = "run-as-principal-name";
    private static final String INIT_AS_PRINCIPAL_NAME = "init-as-principal-name";
    private static final String DESTROY_AS_PRINCIPAL_NAME = "destroy-as-principal-name";
    private static final String DISPATCH_POLICY = "dispatch-policy";
    private String servletName = null;
    private String runAsPrincipalName = null;
    private String initAsPrincipalName = null;
    private String destroyAsPrincipalName = null;
    private String dispatchPolicy = null;
    private WebAppDescriptor wad = null;
    private ServletMBean servlet = null;

    public WLServletDescriptor() {
    }

    public WLServletDescriptor(WebAppDescriptor webAppDescriptor, Element element) throws DOMProcessingException {
        this.wad = webAppDescriptor;
        this.setServletName(DOMUtils.getValueByTagName(element, SERVLET_NAME));
        this.setRunAsPrincipalName(DOMUtils.getOptionalValueByTagName(element, RUN_AS_PRINCIPAL_NAME));
        this.setInitAsPrincipalName(DOMUtils.getOptionalValueByTagName(element, INIT_AS_PRINCIPAL_NAME));
        this.setDestroyAsPrincipalName(DOMUtils.getOptionalValueByTagName(element, DESTROY_AS_PRINCIPAL_NAME));
        this.setDispatchPolicy(DOMUtils.getOptionalValueByTagName(element, DISPATCH_POLICY));
    }

    public WLServletDescriptor(WebAppDescriptor webAppDescriptor, String string) throws DOMProcessingException {
        this.wad = webAppDescriptor;
        this.setServletName(string);
    }

    public void setServletName(String string) throws DOMProcessingException {
        ServletMBean[] servletMBeanArray;
        String string2 = this.servletName;
        this.servletName = string;
        if (!WLServletDescriptor.comp(string2, string)) {
            this.firePropertyChange("servletName", string2, string);
        }
        if ((servletMBeanArray = this.wad.getServlets()) == null) {
            HTTPLogger.logServletNotFound((String)string);
            throw new DOMProcessingException("Servlet with name " + string + " not defined in web.xml");
        }
        for (int i = 0; i < servletMBeanArray.length; ++i) {
            if (servletMBeanArray[i] == null || !string.equals(servletMBeanArray[i].getServletName())) continue;
            this.servlet = servletMBeanArray[i];
            break;
        }
        if (this.servlet == null) {
            HTTPLogger.logServletNotFound((String)string);
            throw new DOMProcessingException("Servlet with name " + string + " not defined in web.xml");
        }
        this.servlet.setServletDescriptor(this);
    }

    public String getServletName() {
        if (this.servlet != null) {
            return this.servlet.getServletName();
        }
        return this.servletName;
    }

    public void setServlet(ServletMBean servletMBean) {
        this.servlet = servletMBean;
        this.servletName = servletMBean.getServletName();
        servletMBean.setServletDescriptor(this);
    }

    public ServletMBean getServlet() {
        return this.servlet;
    }

    public void setRunAsPrincipalName(String string) {
        String string2 = this.runAsPrincipalName;
        this.runAsPrincipalName = string;
        if (!WLServletDescriptor.comp(string2, string)) {
            this.firePropertyChange("runAsPrincipalName", string2, string);
        }
    }

    public String getRunAsPrincipalName() {
        return this.runAsPrincipalName;
    }

    public void setInitAsPrincipalName(String string) {
        String string2 = this.initAsPrincipalName;
        this.initAsPrincipalName = string;
        if (!WLServletDescriptor.comp(string2, string)) {
            this.firePropertyChange("initAsPrincipalName", string2, string);
        }
    }

    public String getInitAsPrincipalName() {
        return this.initAsPrincipalName;
    }

    public void setDestroyAsPrincipalName(String string) {
        String string2 = this.destroyAsPrincipalName;
        this.destroyAsPrincipalName = string;
        if (!WLServletDescriptor.comp(string2, string)) {
            this.firePropertyChange("destroyAsPrincipalName", string2, string);
        }
    }

    public String getDestroyAsPrincipalName() {
        return this.destroyAsPrincipalName;
    }

    public void setDispatchPolicy(String string) {
        String string2 = this.dispatchPolicy;
        this.dispatchPolicy = string;
        if (!WLServletDescriptor.comp(string2, string)) {
            this.firePropertyChange("dispatchPolicy", string2, string);
        }
    }

    public String getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public String toString() {
        return this.getServletName();
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        string = string + this.indentStr(n) + "<" + SERVLET_DESCRIPTOR + ">\n";
        string = string + this.indentStr(n += 2) + "<" + SERVLET_NAME + ">" + this.getServletName() + "</" + SERVLET_NAME + ">\n";
        if (this.getRunAsPrincipalName() != null) {
            string = string + this.indentStr(n) + "<" + RUN_AS_PRINCIPAL_NAME + ">" + this.getRunAsPrincipalName() + "</" + RUN_AS_PRINCIPAL_NAME + ">\n";
        }
        if (this.getInitAsPrincipalName() != null) {
            string = string + this.indentStr(n) + "<" + INIT_AS_PRINCIPAL_NAME + ">" + this.getInitAsPrincipalName() + "</" + INIT_AS_PRINCIPAL_NAME + ">\n";
        }
        if (this.getDestroyAsPrincipalName() != null) {
            string = string + this.indentStr(n) + "<" + DESTROY_AS_PRINCIPAL_NAME + ">" + this.getDestroyAsPrincipalName() + "</" + DESTROY_AS_PRINCIPAL_NAME + ">\n";
        }
        if (this.getDispatchPolicy() != null) {
            string = string + this.indentStr(n) + "<" + DISPATCH_POLICY + ">" + this.getDispatchPolicy() + "</" + DISPATCH_POLICY + ">\n";
        }
        string = string + this.indentStr(n -= 2) + "</" + SERVLET_DESCRIPTOR + ">\n";
        return string;
    }
}

