/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webappext.SessionDescriptorMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ParameterDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class WLSessionDescriptor
extends BaseServletDescriptor
implements ToXML,
SessionDescriptorMBean {
    private static final long serialVersionUID = 6160172527197013767L;
    private static final String SESSION_PARAM = "session-param";
    private List sessionParams;
    public static final String IDLEN = new Integer(52).toString();
    public static final String SESS_TIMEOUT = new Integer(3600).toString();
    public static final String INV_INTERVAL_SECS = new Integer(60).toString();

    public WLSessionDescriptor() {
        this.sessionParams = new ArrayList();
    }

    public WLSessionDescriptor(List list) {
        this.sessionParams = list;
    }

    public WLSessionDescriptor(SessionDescriptorMBean sessionDescriptorMBean) {
        this();
        if (sessionDescriptorMBean != null) {
            this.setURLRewritingEnabled(sessionDescriptorMBean.isURLRewritingEnabled());
            this.setIDLength(sessionDescriptorMBean.getIDLength());
            this.setCacheSize(sessionDescriptorMBean.getCacheSize());
            this.setCookieComment(sessionDescriptorMBean.getCookieComment());
            this.setCookieDomain(sessionDescriptorMBean.getCookieDomain());
            this.setCookieMaxAgeSecs(sessionDescriptorMBean.getCookieMaxAgeSecs());
            this.setCookieName(sessionDescriptorMBean.getCookieName());
            this.setEncodeSessionIdInQueryParams(sessionDescriptorMBean.isEncodeSessionIdInQueryParams());
            this.setCacheSessionCookie(sessionDescriptorMBean.isCacheSessionCookie());
            this.setCookiePath(sessionDescriptorMBean.getCookiePath());
            this.setInvalidationIntervalSecs(sessionDescriptorMBean.getInvalidationIntervalSecs());
            this.setJDBCConnectionTimeoutSecs(sessionDescriptorMBean.getJDBCConnectionTimeoutSecs());
            this.setPersistentStoreCookieName(sessionDescriptorMBean.getPersistentStoreCookieName());
            this.setPersistentStoreDir(sessionDescriptorMBean.getPersistentStoreDir());
            this.setPersistentStorePool(sessionDescriptorMBean.getPersistentStorePool());
            this.setPersistentStoreType(sessionDescriptorMBean.getPersistentStoreType());
            this.setPersistentStoreTable(sessionDescriptorMBean.getPersistentStoreTable());
            this.setPersistentDataSourceJNDIName(sessionDescriptorMBean.getPersistentDataSourceJNDIName());
            this.setJDBCColumnName_MaxInactiveInterval(sessionDescriptorMBean.getJDBCColumnName_MaxInactiveInterval());
            this.setCookiesEnabled(sessionDescriptorMBean.isCookiesEnabled());
            this.setCookieSecure(sessionDescriptorMBean.isCookieSecure());
            this.setTrackingEnabled(sessionDescriptorMBean.isTrackingEnabled());
            this.setPersistentStoreShared(sessionDescriptorMBean.isPersistentStoreShared());
            this.setSwapIntervalSecs(sessionDescriptorMBean.getSwapIntervalSecs());
            this.setTimeoutSecs(sessionDescriptorMBean.getTimeoutSecs());
            this.setConsoleMainAttribute(sessionDescriptorMBean.getConsoleMainAttribute());
            if (!this.checkMinIDLength(this.getIDLength())) {
                this.setIDLength(8);
            }
        }
    }

    public WLSessionDescriptor(Element element) throws DOMProcessingException {
        List list = DOMUtils.getOptionalElementsByTagName(element, SESSION_PARAM);
        Iterator iterator = list.iterator();
        this.sessionParams = new ArrayList(list.size());
        while (iterator.hasNext()) {
            ParameterDescriptor parameterDescriptor = new ParameterDescriptor((Element)iterator.next());
            String string = parameterDescriptor.getParamName();
            if (WLSessionDescriptor.isValidParam(string)) {
                this.sessionParams.add(parameterDescriptor);
                continue;
            }
            if (WLSessionDescriptor.isDeprecatedParam(string)) {
                HTTPLogger.logDeprecatedSessionParamName((String)string);
                continue;
            }
            if (string != null && string.length() == 0) {
                HTTPLogger.logEmptySessionParamName();
            } else {
                HTTPLogger.logInvalidSessionParamName((String)string);
            }
            throw new DOMProcessingException();
        }
        if (!this.checkMinIDLength(this.getIDLength())) {
            this.setIDLength(8);
        }
    }

    private static boolean isValidParam(String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("CacheSize") || string.equalsIgnoreCase("ConsoleMainAttribute") || string.equalsIgnoreCase("CookieComment") || string.equalsIgnoreCase("CookieDomain") || string.equalsIgnoreCase("CookieMaxAgeSecs") || string.equalsIgnoreCase("CookieName") || string.equalsIgnoreCase("EncodeSessionIdInQueryParams") || string.equalsIgnoreCase("CacheSessionCookie") || string.equalsIgnoreCase("CookiePath") || string.equalsIgnoreCase("CookiesEnabled") || string.equalsIgnoreCase("CookieSecure") || string.equalsIgnoreCase("IDLength") || string.equalsIgnoreCase("InvalidationIntervalSecs") || string.equalsIgnoreCase("JDBCConnectionTimeoutSecs") || string.equalsIgnoreCase("JDBCColumnName_MaxInactiveInterval") || string.equalsIgnoreCase("PersistentStoreCookieName") || string.equalsIgnoreCase("PersistentStoreDir") || string.equalsIgnoreCase("PersistentStorePool") || string.equalsIgnoreCase("PersistentDataSourceJNDIName") || string.equalsIgnoreCase("PersistentStoreTable") || string.equalsIgnoreCase("PersistentStoreType") || string.equalsIgnoreCase("SessionDebuggable") || string.equalsIgnoreCase("SwapIntervalSecs") || string.equalsIgnoreCase("TimeoutSecs") || string.equalsIgnoreCase("TrackingEnabled") || string.equalsIgnoreCase("URLRewritingEnabled");
    }

    private static boolean isDefaultValue(String string, String string2) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("CacheSize") && string2.equals("SessionConstants.DEFAULT_CACHE_SIZE") || string.equalsIgnoreCase("CookieComment") && string2.equals("WebLogic Server Session Tracking Cookie") || string.equalsIgnoreCase("CookieMaxAgeSecs") && string2.equals("-1") || string.equalsIgnoreCase("CookieName") && string2.equals("JSESSIONID") || string.equalsIgnoreCase("CookiePath") && string2.equals("/") || string.equalsIgnoreCase("CookiesEnabled") && string2.equals("true") || string.equalsIgnoreCase("IDLength") && string2.equals(IDLEN) || string.equalsIgnoreCase("InvalidationIntervalSecs") && string2.equals(INV_INTERVAL_SECS) || string.equalsIgnoreCase("JDBCConnectionTimeoutSecs") && string2.equals("120") || string.equalsIgnoreCase("PersistentStoreCookieName") && string2.equals("WLCOOKIE") || string.equalsIgnoreCase("PersistentStoreDir") && string2.equals("session_db") || string.equalsIgnoreCase("PersistentStoreType") && string2.equals("memory") || string.equalsIgnoreCase("TimeoutSecs") && string2.equals(SESS_TIMEOUT) || string.equalsIgnoreCase("TrackingEnabled") && string2.equals("true") || string.equalsIgnoreCase("URLRewritingEnabled") && string2.equals("true");
    }

    private static boolean isDeprecatedParam(String string) {
        return string.equalsIgnoreCase("PersistentStoreShared");
    }

    public boolean isURLRewritingEnabled() {
        return "true".equalsIgnoreCase(this.getProp("URLRewritingEnabled", "true"));
    }

    public void setURLRewritingEnabled(boolean bl) {
        if (bl != this.isURLRewritingEnabled()) {
            this.setProp("URLRewritingEnabled", "" + bl);
            this.firePropertyChange("URLRewritingEnabled", new Boolean(!bl), new Boolean(bl));
        }
    }

    public String getCookiePath() {
        return this.getProp("CookiePath", "/");
    }

    public void setCookiePath(String string) {
        if ((string = WLSessionDescriptor.isNull(string)) == null) {
            return;
        }
        if (string.charAt(0) != '/') {
            string = '/' + string;
        }
        String string2 = this.getCookiePath();
        this.setProp("CookiePath", string);
        if (!WLSessionDescriptor.comp(string2, string)) {
            this.firePropertyChange("CookiePath", string2, string);
        }
    }

    public int getIDLength() {
        return this.getIntProp("IDLength", 52);
    }

    public void setIDLength(int n) {
        int n2 = this.getIDLength();
        if (n2 != n) {
            this.setProp("IDLength", "" + n);
            this.firePropertyChange("IDLength", new Integer(n2), new Integer(n));
        }
    }

    private boolean checkMinIDLength(int n) {
        if (n < 8) {
            HTTPLogger.logError((String)"ERROR", (String)"IDLength cannot be less than 8 as declared in deployment descriptor. Initializing with minimum value 8.");
            return false;
        }
        return true;
    }

    public int getCacheSize() {
        return this.getIntProp("CacheSize", 1024);
    }

    public void setCacheSize(int n) {
        int n2 = this.getCacheSize();
        this.setProp("CacheSize", "" + n);
        if (n2 != n) {
            this.firePropertyChange("CacheSize", new Integer(n2), new Integer(n));
        }
    }

    public String getCookieComment() {
        return this.getProp("CookieComment", "WebLogic Server Session Tracking Cookie");
    }

    public void setCookieComment(String string) {
        String string2 = this.getCookieComment();
        this.setProp("CookieComment", string);
        if (!WLSessionDescriptor.comp(string2, string)) {
            this.firePropertyChange("CookieComment", string2, string);
        }
    }

    public String getCookieDomain() {
        return this.getProp("CookieDomain", null);
    }

    public void setCookieDomain(String string) {
        String string2;
        if ((string = WLSessionDescriptor.isNull(string)) != null && !WLSessionDescriptor.comp(string2 = this.getCookieDomain(), string)) {
            this.setProp("CookieDomain", string);
            this.firePropertyChange("CookieDomain", string2, string);
        }
    }

    public int getCookieMaxAgeSecs() {
        return this.getIntProp("CookieMaxAgeSecs", -1);
    }

    public void setCookieMaxAgeSecs(int n) {
        int n2 = this.getCookieMaxAgeSecs();
        if (n != n2) {
            this.setProp("CookieMaxAgeSecs", "" + n);
            this.firePropertyChange("CookieMaxAgeSecs", new Integer(n2), new Integer(n));
        }
    }

    public String getCookieName() {
        return this.getProp("CookieName", "JSESSIONID", true);
    }

    public void setCookieName(String string) {
        String string2;
        if ((string = WLSessionDescriptor.isNull(string)) == null) {
            string = "JSESSIONID";
        }
        if (!WLSessionDescriptor.comp(string2 = this.getCookieName(), string)) {
            this.setProp("CookieName", string);
            this.firePropertyChange("CookieName", string2, string);
        }
    }

    public boolean isEncodeSessionIdInQueryParams() {
        return "true".equalsIgnoreCase(this.getProp("EncodeSessionIdInQueryParams", "false"));
    }

    public void setEncodeSessionIdInQueryParams(boolean bl) {
        this.setProp("EncodeSessionIdInQueryParams", "" + bl);
    }

    public void setCacheSessionCookie(boolean bl) {
        this.setProp("CacheSessionCookie", "" + bl);
    }

    public boolean isCacheSessionCookie() {
        return "true".equalsIgnoreCase(this.getProp("CacheSessionCookie", "true"));
    }

    public void setCookieSecure(boolean bl) {
        if (bl != this.isCookieSecure()) {
            this.setProp("CookieSecure", "" + bl);
            this.firePropertyChange("CookieSecure", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isCookieSecure() {
        return "true".equalsIgnoreCase(this.getProp("CookieSecure", "false"));
    }

    public int getInvalidationIntervalSecs() {
        return this.getIntProp("InvalidationIntervalSecs", 60);
    }

    public void setInvalidationIntervalSecs(int n) {
        int n2 = this.getInvalidationIntervalSecs();
        if (n2 != n) {
            this.setProp("InvalidationIntervalSecs", "" + n);
            this.firePropertyChange("InvalidationIntervalSecs", new Integer(n2), new Integer(n));
        }
    }

    public int getJDBCConnectionTimeoutSecs() {
        return this.getIntProp("JDBCConnectionTimeoutSecs", 120);
    }

    public void setJDBCConnectionTimeoutSecs(int n) {
        int n2;
        if ((n = Math.max(n, 0)) != (n2 = this.getJDBCConnectionTimeoutSecs())) {
            this.setProp("JDBCConnectionTimeoutSecs", "" + n);
            this.firePropertyChange("JDBCConnectionTimeoutSecs", new Integer(n2), new Integer(n));
        }
    }

    public void setPersistentStoreCookieName(String string) {
        if ((string = WLSessionDescriptor.isNull(string)) != null) {
            String string2 = this.getPersistentStoreCookieName();
            this.setProp("PersistentStoreCookieName", string);
            if (!WLSessionDescriptor.comp(string2, string)) {
                this.firePropertyChange("PersistentStoreCookieName", string2, string);
            }
        }
    }

    public String getPersistentStoreCookieName() {
        return this.getProp("PersistentStoreCookieName", "WLCOOKIE", true);
    }

    public String getPersistentStoreDir() {
        return this.getProp("PersistentStoreDir", "session_db", true);
    }

    public void setPersistentStoreDir(String string) {
        if ((string = WLSessionDescriptor.isNull(string)) != null) {
            String string2 = this.getPersistentStoreDir();
            this.setProp("PersistentStoreDir", string);
            if (!WLSessionDescriptor.comp(string2, string)) {
                this.firePropertyChange("PersistentStoreDir", string2, string);
            }
        }
    }

    public String getPersistentStorePool() {
        return this.getProp("PersistentStorePool", null);
    }

    public void setPersistentStorePool(String string) {
        if ((string = WLSessionDescriptor.isNull(string)) != null) {
            String string2 = this.getPersistentStorePool();
            this.setProp("PersistentStorePool", string);
            if (!WLSessionDescriptor.comp(string2, string)) {
                this.firePropertyChange("PersistentStorePool", string2, string);
            }
        }
    }

    public String getPersistentDataSourceJNDIName() {
        return this.getProp("PersistentDataSourceJNDIName", null);
    }

    public void setPersistentDataSourceJNDIName(String string) {
        if ((string = WLSessionDescriptor.isNull(string)) != null) {
            String string2 = this.getPersistentDataSourceJNDIName();
            this.setProp("PersistentDataSourceJNDIName", string);
            if (!WLSessionDescriptor.comp(string2, string)) {
                this.firePropertyChange("PersistentDataSourceJNDIName", string2, string);
            }
        }
    }

    public String getPersistentStoreTable() {
        return this.getProp("PersistentStoreTable", "wl_servlet_sessions", true);
    }

    public void setPersistentStoreTable(String string) {
        if ((string = WLSessionDescriptor.isNull(string)) != null) {
            String string2 = this.getPersistentStoreTable();
            this.setProp("PersistentStoreTable", string);
            if (!WLSessionDescriptor.comp(string2, string)) {
                this.firePropertyChange("PersistentStoreTable", string2, string);
            }
        }
    }

    public String getJDBCColumnName_MaxInactiveInterval() {
        return this.getProp("JDBCColumnName_MaxInactiveInterval", "wl_max_inactive_interval", true);
    }

    public void setJDBCColumnName_MaxInactiveInterval(String string) {
        if ((string = WLSessionDescriptor.isNull(string)) != null) {
            this.setProp("JDBCColumnName_MaxInactiveInterval", string);
        }
    }

    public boolean isPersistentStoreShared() {
        return "true".equalsIgnoreCase(this.getProp("PersistentStoreShared", "false"));
    }

    public void setPersistentStoreShared(boolean bl) {
        if (bl != this.isPersistentStoreShared()) {
            this.setProp("PersistentStoreShared", "" + bl);
            this.firePropertyChange("PersistentStoreShared", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isDebugEnabled() {
        return "true".equalsIgnoreCase(this.getProp("SessionDebuggable", "false"));
    }

    public void setDebugEnabled(boolean bl) {
        if (bl != this.isDebugEnabled()) {
            this.setProp("SessionDebuggable", "" + bl);
            this.firePropertyChange("SessionDebuggable", new Boolean(!bl), new Boolean(bl));
        }
    }

    private static boolean validStoreType(String string) {
        return "memory".equals(string) || "file".equals(string) || "replicated".equals(string) || "replicated_if_clustered".equals(string) || "cookie".equals(string) || "jdbc".equals(string);
    }

    public String getPersistentStoreType() {
        String string = this.getProp("PersistentStoreType", "memory");
        if (!WLSessionDescriptor.validStoreType(string)) {
            return "memory";
        }
        return string;
    }

    public void setPersistentStoreType(String string) {
        if ((string = WLSessionDescriptor.isNull(string)) != null && WLSessionDescriptor.validStoreType(string)) {
            String string2 = this.getPersistentStoreType();
            this.setProp("PersistentStoreType", string);
            if (!WLSessionDescriptor.comp(string2, string)) {
                this.firePropertyChange("PersistentStoreType", string2, string);
            }
        }
    }

    public int getSwapIntervalSecs() {
        return this.getIntProp("SwapIntervalSecs", 10);
    }

    public void setSwapIntervalSecs(int n) {
        int n2 = this.getSwapIntervalSecs();
        if (n2 != n) {
            this.setProp("SwapIntervalSecs", "" + n);
            this.firePropertyChange("SwapIntervalSecs", new Integer(n2), new Integer(n));
        }
    }

    public int getTimeoutSecs() {
        return this.getIntProp("TimeoutSecs", 3600);
    }

    public void setTimeoutSecs(int n) {
        int n2 = this.getTimeoutSecs();
        if (n != n2) {
            this.setProp("TimeoutSecs", "" + n);
            this.firePropertyChange("TimeoutSecs", new Integer(n2), new Integer(n));
        }
    }

    public String getConsoleMainAttribute() {
        return this.getProp("ConsoleMainAttribute", null);
    }

    public void setConsoleMainAttribute(String string) {
        String string2;
        if ((string = WLSessionDescriptor.isNull(string)) != null && !WLSessionDescriptor.comp(string2 = this.getConsoleMainAttribute(), string)) {
            this.setProp("ConsoleMainAttribute", string);
            this.firePropertyChange("ConsoleMainAttribute", string2, string);
        }
    }

    public void setCookiesEnabled(boolean bl) {
        if (bl != this.isCookiesEnabled()) {
            this.setProp("CookiesEnabled", "" + bl);
            this.firePropertyChange("CookiesEnabled", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isCookiesEnabled() {
        return "true".equalsIgnoreCase(this.getProp("CookiesEnabled", "true"));
    }

    public void setTrackingEnabled(boolean bl) {
        if (bl != this.isTrackingEnabled()) {
            this.setProp("TrackingEnabled", "" + bl);
            this.firePropertyChange("TrackingEnabled", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isTrackingEnabled() {
        return "true".equalsIgnoreCase(this.getProp("TrackingEnabled", "true"));
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
    }

    public void register() throws ManagementException {
        super.register();
    }

    private String getProp(String string, String string2) {
        return this.getProp(string, string2, false);
    }

    private String getProp(String string, String string2, boolean bl) {
        for (ParameterDescriptor parameterDescriptor : this.sessionParams) {
            if (!string.equalsIgnoreCase(parameterDescriptor.getParamName())) continue;
            parameterDescriptor.setParamName(string);
            if (!bl) {
                return parameterDescriptor.getParamValue();
            }
            String string3 = parameterDescriptor.getParamValue();
            if ((string3 = WLSessionDescriptor.isNull(string3)) != null) {
                return string3;
            }
            if (string2 != null) {
                parameterDescriptor.setParamValue(string2);
            }
            return string2;
        }
        if (string2 != null && string2.length() > 0) {
            ParameterDescriptor parameterDescriptor;
            parameterDescriptor = new ParameterDescriptor();
            parameterDescriptor.setParamName(string);
            parameterDescriptor.setParamValue(string2);
            this.sessionParams.add(parameterDescriptor);
        }
        return string2;
    }

    private void setProp(String string, String string2) {
        ParameterDescriptor parameterDescriptor2;
        for (ParameterDescriptor parameterDescriptor2 : this.sessionParams) {
            if (!string.equalsIgnoreCase(parameterDescriptor2.getParamName())) continue;
            parameterDescriptor2.setParamName(string);
            parameterDescriptor2.setParamValue(string2);
            return;
        }
        parameterDescriptor2 = new ParameterDescriptor();
        parameterDescriptor2.setParamName(string);
        parameterDescriptor2.setParamValue(string2);
        this.sessionParams.add(parameterDescriptor2);
    }

    private int getIntProp(String string, int n) {
        try {
            String string2 = this.getProp(string, "" + n);
            string2 = string2.trim();
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private static String isNull(String string) {
        if (string == null) {
            return null;
        }
        return (string = string.trim()).length() > 0 ? string : null;
    }

    public String toXML(int n) {
        boolean bl = false;
        String string = "";
        if (this.sessionParams != null && this.sessionParams.size() > 0) {
            for (ParameterDescriptor parameterDescriptor : this.sessionParams) {
                if (WLSessionDescriptor.isDefaultValue(parameterDescriptor.getParamName(), parameterDescriptor.getParamValue())) continue;
                if (!bl) {
                    string = string + this.indentStr(n) + "<session-descriptor>\n";
                    n += 2;
                    bl = true;
                }
                string = string + this.indentStr(n) + "<session-param>\n";
                string = string + this.indentStr(n += 2) + "<param-name>" + parameterDescriptor.getParamName() + "</param-name>\n";
                string = string + this.indentStr(n) + "<param-value>" + parameterDescriptor.getParamValue() + "</param-value>\n";
                string = string + this.indentStr(n -= 2) + "</session-param>\n";
            }
            if (bl) {
                string = string + this.indentStr(n -= 2) + "</session-descriptor>\n";
            }
        }
        return string;
    }
}

