/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.WebElementMBean;
import weblogic.management.descriptors.webappext.AuthFilterMBean;
import weblogic.management.descriptors.webappext.CharsetParamsMBean;
import weblogic.management.descriptors.webappext.ContainerDescriptorMBean;
import weblogic.management.descriptors.webappext.JspDescriptorMBean;
import weblogic.management.descriptors.webappext.PreprocessorMBean;
import weblogic.management.descriptors.webappext.PreprocessorMappingMBean;
import weblogic.management.descriptors.webappext.ReferenceDescriptorMBean;
import weblogic.management.descriptors.webappext.RunAsRoleAssignmentMBean;
import weblogic.management.descriptors.webappext.SecurityPermissionMBean;
import weblogic.management.descriptors.webappext.SecurityRoleAssignmentMBean;
import weblogic.management.descriptors.webappext.ServletDescriptorMBean;
import weblogic.management.descriptors.webappext.SessionDescriptorMBean;
import weblogic.management.descriptors.webappext.URLMatchMapMBean;
import weblogic.management.descriptors.webappext.VirtualDirectoryMappingMBean;
import weblogic.management.descriptors.webappext.WebAppExtDescriptorMBean;
import weblogic.servlet.internal.dd.AuthFilter;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.CharsetParams;
import weblogic.servlet.internal.dd.ContainerDescriptor;
import weblogic.servlet.internal.dd.DescriptorConstants;
import weblogic.servlet.internal.dd.DestroyAsDescriptor;
import weblogic.servlet.internal.dd.InitAsDescriptor;
import weblogic.servlet.internal.dd.PreprocessorDescriptor;
import weblogic.servlet.internal.dd.PreprocessorMappingDescriptor;
import weblogic.servlet.internal.dd.ReferenceDescriptor;
import weblogic.servlet.internal.dd.RunAsRoleAssignment;
import weblogic.servlet.internal.dd.SecurityPermissionDescriptor;
import weblogic.servlet.internal.dd.SecurityRoleAssignment;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.internal.dd.URLMatchMapDescriptor;
import weblogic.servlet.internal.dd.VirtualDirectoryMappingDescriptor;
import weblogic.servlet.internal.dd.WLJspDescriptor;
import weblogic.servlet.internal.dd.WLServletDescriptor;
import weblogic.servlet.internal.dd.WLSessionDescriptor;
import weblogic.servlet.internal.dd.WebAppDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class WLWebAppDescriptor
extends BaseServletDescriptor
implements ToXML,
WebAppExtDescriptorMBean,
DescriptorConstants {
    private static final long serialVersionUID = -7317362224751399947L;
    private static final String CHARSET_PARAMS = "charset-params";
    private static final String CONTAINER_DESCRIPTOR = "container-descriptor";
    private static final String CONTEXT_ROOT = "context-root";
    private static final String DISPATCH_POLICY = "wl-dispatch-policy";
    private static final String DESCRIPTION = "description";
    private static final String VERSION = "weblogic-version";
    private static final String S_R_ASSIGNMENT = "security-role-assignment";
    private static final String REFERENCE = "reference-descriptor";
    private static final String SESSION = "session-descriptor";
    private static final String JSP = "jsp-descriptor";
    private static final String AUTH_FILTER = "auth-filter";
    private static final String VIRTUAL_DIRECTORY_MAPPING = "virtual-directory-mapping";
    private static final String URL_MATCH_MAP = "url-match-map";
    private static final String PREPROCESSOR = "preprocessor";
    private static final String PREPROCESSOR_MAPPING = "preprocessor-mapping";
    private static final String SECURITY_PERMISSION = "security-permission";
    private static final String INIT_AS = "init-as";
    private static final String DESTROY_AS = "destroy-as";
    private static final String SERVLET_DESCRIPTOR = "servlet-descriptor";
    private static final String RUN_AS_ROLE_ASSIGNMENT = "run-as-role-assignment";
    private String wlVersion;
    private String wlDescription;
    private SecurityRoleAssignmentMBean[] securityRoleAssignments;
    private VirtualDirectoryMappingMBean[] virtualDirectories;
    private ReferenceDescriptorMBean refDes;
    private SessionDescriptorMBean sessDes;
    private JspDescriptorMBean jspDes;
    private AuthFilterMBean wlAuthFilter;
    private URLMatchMapMBean urlMatchMap;
    private ContainerDescriptorMBean containerDescriptor;
    private CharsetParamsMBean charsetParams;
    private PreprocessorMBean[] preprocessors;
    private PreprocessorMappingMBean[] preprocessorMaps;
    private SecurityPermissionMBean securityPermission;
    private String contextRoot;
    private String dispatchPolicy;
    private ServletDescriptorMBean[] servletDescriptors;
    private ArrayList migrationServletDescriptors;
    private RunAsRoleAssignmentMBean[] runAsRoleAssignments;
    private String descriptorEncoding = null;
    private String descriptorVersion = null;

    public String getEncoding() {
        return this.descriptorEncoding;
    }

    public void setEncoding(String string) {
        this.descriptorEncoding = string;
    }

    public String getVersion() {
        return this.descriptorVersion;
    }

    public void setVersion(String string) {
        this.descriptorVersion = string;
    }

    public WLWebAppDescriptor() {
        this.jspDes = new WLJspDescriptor();
        this.sessDes = new WLSessionDescriptor();
    }

    public WLWebAppDescriptor(WebAppDescriptor webAppDescriptor, Element element) throws DOMProcessingException {
        boolean bl;
        int n;
        Element element2;
        String string;
        this.wlDescription = DOMUtils.getOptionalValueByTagName(element, DESCRIPTION);
        this.wlVersion = DOMUtils.getOptionalValueByTagName(element, VERSION);
        String string2 = DOMUtils.getOptionalValueByTagName(element, AUTH_FILTER);
        if (string2 != null && string2.trim().length() > 0) {
            this.wlAuthFilter = new AuthFilter(string2);
        }
        if ((string = DOMUtils.getOptionalValueByTagName(element, URL_MATCH_MAP)) != null && string.length() != 0) {
            this.urlMatchMap = new URLMatchMapDescriptor(string);
        }
        if ((element2 = DOMUtils.getOptionalElementByTagName(element, CONTAINER_DESCRIPTOR)) != null) {
            this.containerDescriptor = new ContainerDescriptor(element2);
        }
        if ((element2 = DOMUtils.getOptionalElementByTagName(element, SECURITY_PERMISSION)) != null) {
            this.securityPermission = new SecurityPermissionDescriptor(element2);
        }
        if ((element2 = DOMUtils.getOptionalElementByTagName(element, CHARSET_PARAMS)) != null) {
            this.charsetParams = new CharsetParams(element2);
        }
        List list = DOMUtils.getOptionalElementsByTagName(element, S_R_ASSIGNMENT);
        Iterator iterator = list.iterator();
        SecurityRoleAssignmentMBean[] securityRoleAssignmentMBeanArray = new SecurityRoleAssignmentMBean[list.size()];
        for (int i = 0; iterator.hasNext() && i < securityRoleAssignmentMBeanArray.length; ++i) {
            securityRoleAssignmentMBeanArray[i] = new SecurityRoleAssignment(webAppDescriptor, (Element)iterator.next());
        }
        this.securityRoleAssignments = securityRoleAssignmentMBeanArray;
        list = DOMUtils.getOptionalElementsByTagName(element, SERVLET_DESCRIPTOR);
        if (list.size() > 0) {
            iterator = list.iterator();
            ServletDescriptorMBean[] servletDescriptorMBeanArray = new ServletDescriptorMBean[list.size()];
            for (n = 0; n < servletDescriptorMBeanArray.length; ++n) {
                servletDescriptorMBeanArray[n] = new WLServletDescriptor(webAppDescriptor, (Element)iterator.next());
            }
            this.servletDescriptors = servletDescriptorMBeanArray;
        } else {
            this.servletDescriptors = new ServletDescriptorMBean[0];
        }
        list = DOMUtils.getOptionalElementsByTagName(element, INIT_AS);
        if (list.size() > 0) {
            iterator = list.iterator();
            for (int i = 0; i < list.size(); ++i) {
                InitAsDescriptor initAsDescriptor = new InitAsDescriptor(webAppDescriptor, (Element)iterator.next());
                bl = false;
                if (this.servletDescriptors != null) {
                    for (int j = 0; j < this.servletDescriptors.length; ++j) {
                        if (!this.servletDescriptors[j].getServletName().equals(initAsDescriptor.getServletName())) continue;
                        this.servletDescriptors[j].setInitAsPrincipalName(initAsDescriptor.getPrincipalName());
                        bl = true;
                    }
                }
                if (bl) continue;
                WLServletDescriptor wLServletDescriptor = new WLServletDescriptor(webAppDescriptor, initAsDescriptor.getServletName());
                wLServletDescriptor.setInitAsPrincipalName(initAsDescriptor.getPrincipalName());
                if (this.migrationServletDescriptors == null) {
                    this.migrationServletDescriptors = new ArrayList();
                }
                this.migrationServletDescriptors.add(wLServletDescriptor);
            }
        }
        if ((list = DOMUtils.getOptionalElementsByTagName(element, DESTROY_AS)).size() > 0) {
            iterator = list.iterator();
            for (int i = 0; i < list.size(); ++i) {
                DestroyAsDescriptor destroyAsDescriptor = new DestroyAsDescriptor(webAppDescriptor, (Element)iterator.next());
                bl = false;
                if (this.servletDescriptors != null) {
                    for (int j = 0; j < this.servletDescriptors.length; ++j) {
                        if (!this.servletDescriptors[j].getServletName().equals(destroyAsDescriptor.getServletName())) continue;
                        this.servletDescriptors[j].setDestroyAsPrincipalName(destroyAsDescriptor.getPrincipalName());
                        bl = true;
                    }
                }
                if (!bl && this.migrationServletDescriptors != null) {
                    for (ServletDescriptorMBean servletDescriptorMBean : this.migrationServletDescriptors) {
                        servletDescriptorMBean.setDestroyAsPrincipalName(destroyAsDescriptor.getPrincipalName());
                        bl = true;
                    }
                }
                if (bl) continue;
                WLServletDescriptor wLServletDescriptor = new WLServletDescriptor(webAppDescriptor, destroyAsDescriptor.getServletName());
                wLServletDescriptor.setDestroyAsPrincipalName(destroyAsDescriptor.getPrincipalName());
                if (this.migrationServletDescriptors == null) {
                    this.migrationServletDescriptors = new ArrayList();
                }
                this.migrationServletDescriptors.add(wLServletDescriptor);
            }
        }
        if ((list = DOMUtils.getOptionalElementsByTagName(element, RUN_AS_ROLE_ASSIGNMENT)).size() > 0) {
            iterator = list.iterator();
            RunAsRoleAssignmentMBean[] runAsRoleAssignmentMBeanArray = new RunAsRoleAssignmentMBean[list.size()];
            for (n = 0; iterator.hasNext() && n < runAsRoleAssignmentMBeanArray.length; ++n) {
                runAsRoleAssignmentMBeanArray[n] = new RunAsRoleAssignment(webAppDescriptor, (Element)iterator.next());
            }
            this.runAsRoleAssignments = runAsRoleAssignmentMBeanArray;
        } else {
            this.runAsRoleAssignments = null;
        }
        list = DOMUtils.getOptionalElementsByTagName(element, VIRTUAL_DIRECTORY_MAPPING);
        if (list.size() > 0) {
            iterator = list.iterator();
            VirtualDirectoryMappingMBean[] virtualDirectoryMappingMBeanArray = new VirtualDirectoryMappingMBean[list.size()];
            for (n = 0; iterator.hasNext() && n < virtualDirectoryMappingMBeanArray.length; ++n) {
                virtualDirectoryMappingMBeanArray[n] = new VirtualDirectoryMappingDescriptor((Element)iterator.next());
            }
            this.virtualDirectories = virtualDirectoryMappingMBeanArray;
        } else {
            this.virtualDirectories = null;
        }
        list = DOMUtils.getOptionalElementsByTagName(element, PREPROCESSOR);
        if (list.size() > 0) {
            iterator = list.iterator();
            PreprocessorMBean[] preprocessorMBeanArray = new PreprocessorMBean[list.size()];
            for (n = 0; iterator.hasNext() && n < preprocessorMBeanArray.length; ++n) {
                preprocessorMBeanArray[n] = new PreprocessorDescriptor((Element)iterator.next());
            }
            this.preprocessors = preprocessorMBeanArray;
        }
        if ((list = DOMUtils.getOptionalElementsByTagName(element, PREPROCESSOR_MAPPING)).size() > 0) {
            iterator = list.iterator();
            PreprocessorMappingMBean[] preprocessorMappingMBeanArray = new PreprocessorMappingMBean[list.size()];
            for (n = 0; iterator.hasNext() && n < preprocessorMappingMBeanArray.length; ++n) {
                preprocessorMappingMBeanArray[n] = new PreprocessorMappingDescriptor(this, (Element)iterator.next());
            }
            if (preprocessorMappingMBeanArray != null) {
                this.preprocessorMaps = preprocessorMappingMBeanArray;
            }
        }
        if ((element2 = DOMUtils.getOptionalElementByTagName(element, REFERENCE)) != null) {
            this.refDes = new ReferenceDescriptor(webAppDescriptor, element2);
        }
        if ((element2 = DOMUtils.getOptionalElementByTagName(element, SESSION)) != null) {
            this.sessDes = new WLSessionDescriptor(element2);
        }
        if ((element2 = DOMUtils.getOptionalElementByTagName(element, JSP)) != null) {
            this.jspDes = new WLJspDescriptor(element2);
        }
        this.contextRoot = DOMUtils.getOptionalValueByTagName(element, CONTEXT_ROOT);
        this.dispatchPolicy = DOMUtils.getOptionalValueByTagName(element, DISPATCH_POLICY);
        if (this.sessDes == null) {
            this.sessDes = new WLSessionDescriptor();
        }
        if (this.jspDes == null) {
            this.jspDes = new WLJspDescriptor();
        }
    }

    public String getWebLogicVersion() {
        return this.wlVersion;
    }

    public void setWebLogicVersion(String string) {
        String string2 = this.getWebLogicVersion();
        if (!WLWebAppDescriptor.comp(string2, string)) {
            this.wlVersion = string;
            this.firePropertyChange("wlVersion", string2, string);
        }
    }

    public AuthFilterMBean getAuthFilter() {
        return this.wlAuthFilter;
    }

    public void setAuthFilter(AuthFilterMBean authFilterMBean) {
        this.wlAuthFilter = authFilterMBean;
    }

    public URLMatchMapMBean getURLMatchMap() {
        return this.urlMatchMap;
    }

    public void setURLMatchMap(URLMatchMapMBean uRLMatchMapMBean) {
        this.urlMatchMap = uRLMatchMapMBean;
    }

    public String getDescription() {
        return this.wlDescription;
    }

    public void setDescription(String string) {
        String string2 = this.getDescription();
        if (!WLWebAppDescriptor.comp(string2, string)) {
            this.wlDescription = string;
            this.firePropertyChange(DESCRIPTION, string2, string);
        }
    }

    public ReferenceDescriptorMBean getReferenceDescriptor() {
        return this.refDes;
    }

    public void setReferenceDescriptor(ReferenceDescriptorMBean referenceDescriptorMBean) {
        this.refDes = referenceDescriptorMBean;
    }

    public SessionDescriptorMBean getSessionDescriptor() {
        return this.sessDes;
    }

    public void setSessionDescriptor(SessionDescriptorMBean sessionDescriptorMBean) {
        this.sessDes = sessionDescriptorMBean;
    }

    public JspDescriptorMBean getJspDescriptor() {
        return this.jspDes;
    }

    public void setJspDescriptor(JspDescriptorMBean jspDescriptorMBean) {
        this.jspDes = jspDescriptorMBean;
    }

    public void setSecurityRoleAssignments(SecurityRoleAssignmentMBean[] securityRoleAssignmentMBeanArray) {
        SecurityRoleAssignmentMBean[] securityRoleAssignmentMBeanArray2 = this.securityRoleAssignments;
        this.securityRoleAssignments = securityRoleAssignmentMBeanArray;
    }

    public RunAsRoleAssignmentMBean[] getRunAsRoleAssignments() {
        if (this.runAsRoleAssignments == null) {
            this.runAsRoleAssignments = new RunAsRoleAssignmentMBean[0];
        }
        return this.runAsRoleAssignments;
    }

    public void setRunAsRoleAssignments(RunAsRoleAssignmentMBean[] runAsRoleAssignmentMBeanArray) {
        this.runAsRoleAssignments = runAsRoleAssignmentMBeanArray;
    }

    public SecurityRoleAssignmentMBean[] getSecurityRoleAssignments() {
        if (this.securityRoleAssignments == null) {
            this.securityRoleAssignments = new SecurityRoleAssignmentMBean[0];
        }
        return this.securityRoleAssignments;
    }

    public void addSecurityRoleAssignment(SecurityRoleAssignmentMBean securityRoleAssignmentMBean) {
        SecurityRoleAssignmentMBean[] securityRoleAssignmentMBeanArray = this.getSecurityRoleAssignments();
        if (securityRoleAssignmentMBeanArray == null) {
            securityRoleAssignmentMBeanArray = new SecurityRoleAssignmentMBean[]{securityRoleAssignmentMBean};
            this.setSecurityRoleAssignments(securityRoleAssignmentMBeanArray);
            return;
        }
        SecurityRoleAssignmentMBean[] securityRoleAssignmentMBeanArray2 = new SecurityRoleAssignmentMBean[securityRoleAssignmentMBeanArray.length + 1];
        System.arraycopy(securityRoleAssignmentMBeanArray, 0, securityRoleAssignmentMBeanArray2, 0, securityRoleAssignmentMBeanArray.length);
        securityRoleAssignmentMBeanArray2[securityRoleAssignmentMBeanArray.length] = securityRoleAssignmentMBean;
        this.setSecurityRoleAssignments(securityRoleAssignmentMBeanArray2);
    }

    public void removeSecurityRoleAssignment(SecurityRoleAssignmentMBean securityRoleAssignmentMBean) {
        SecurityRoleAssignmentMBean[] securityRoleAssignmentMBeanArray = this.getSecurityRoleAssignments();
        if (securityRoleAssignmentMBeanArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < securityRoleAssignmentMBeanArray.length; ++i) {
            if (!securityRoleAssignmentMBeanArray[i].equals(securityRoleAssignmentMBean)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            SecurityRoleAssignmentMBean[] securityRoleAssignmentMBeanArray2 = new SecurityRoleAssignmentMBean[securityRoleAssignmentMBeanArray.length - 1];
            System.arraycopy(securityRoleAssignmentMBeanArray, 0, securityRoleAssignmentMBeanArray2, 0, n);
            System.arraycopy(securityRoleAssignmentMBeanArray, n + 1, securityRoleAssignmentMBeanArray2, n, securityRoleAssignmentMBeanArray.length - (n + 1));
            this.setSecurityRoleAssignments(securityRoleAssignmentMBeanArray2);
        }
    }

    public void setVirtualDirectoryMappings(VirtualDirectoryMappingMBean[] virtualDirectoryMappingMBeanArray) {
        VirtualDirectoryMappingMBean[] virtualDirectoryMappingMBeanArray2 = this.virtualDirectories;
        this.virtualDirectories = virtualDirectoryMappingMBeanArray;
        if (!WLWebAppDescriptor.comp(virtualDirectoryMappingMBeanArray2, virtualDirectoryMappingMBeanArray)) {
            this.firePropertyChange("virtualDirectoryMappings", virtualDirectoryMappingMBeanArray2, virtualDirectoryMappingMBeanArray);
        }
    }

    public VirtualDirectoryMappingMBean[] getVirtualDirectoryMappings() {
        if (this.virtualDirectories == null) {
            this.virtualDirectories = new VirtualDirectoryMappingMBean[0];
        }
        return this.virtualDirectories;
    }

    public void addVirtualDirectoryMapping(VirtualDirectoryMappingMBean virtualDirectoryMappingMBean) {
        VirtualDirectoryMappingMBean[] virtualDirectoryMappingMBeanArray = this.getVirtualDirectoryMappings();
        if (virtualDirectoryMappingMBeanArray == null) {
            virtualDirectoryMappingMBeanArray = new VirtualDirectoryMappingMBean[]{virtualDirectoryMappingMBean};
            this.setVirtualDirectoryMappings(virtualDirectoryMappingMBeanArray);
            return;
        }
        VirtualDirectoryMappingMBean[] virtualDirectoryMappingMBeanArray2 = new VirtualDirectoryMappingMBean[virtualDirectoryMappingMBeanArray.length + 1];
        System.arraycopy(virtualDirectoryMappingMBeanArray, 0, virtualDirectoryMappingMBeanArray2, 0, virtualDirectoryMappingMBeanArray.length);
        virtualDirectoryMappingMBeanArray2[virtualDirectoryMappingMBeanArray.length] = virtualDirectoryMappingMBean;
        this.setVirtualDirectoryMappings(virtualDirectoryMappingMBeanArray2);
    }

    public void removeVirtualDirectoryMapping(VirtualDirectoryMappingMBean virtualDirectoryMappingMBean) {
        VirtualDirectoryMappingMBean[] virtualDirectoryMappingMBeanArray = this.getVirtualDirectoryMappings();
        if (virtualDirectoryMappingMBeanArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < virtualDirectoryMappingMBeanArray.length; ++i) {
            if (!virtualDirectoryMappingMBeanArray[i].equals(virtualDirectoryMappingMBean)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            VirtualDirectoryMappingMBean[] virtualDirectoryMappingMBeanArray2 = new VirtualDirectoryMappingMBean[virtualDirectoryMappingMBeanArray.length - 1];
            System.arraycopy(virtualDirectoryMappingMBeanArray, 0, virtualDirectoryMappingMBeanArray2, 0, n);
            System.arraycopy(virtualDirectoryMappingMBeanArray, n + 1, virtualDirectoryMappingMBeanArray2, n, virtualDirectoryMappingMBeanArray.length - (n + 1));
            this.setVirtualDirectoryMappings(virtualDirectoryMappingMBeanArray2);
        }
    }

    public boolean containsServletDescriptor(ServletDescriptorMBean servletDescriptorMBean) {
        if (this.servletDescriptors == null) {
            return false;
        }
        int n = this.servletDescriptors.length;
        for (int i = 0; i < n; ++i) {
            if (servletDescriptorMBean != this.servletDescriptors[i]) continue;
            return true;
        }
        return false;
    }

    public void addServletDescriptor(ServletDescriptorMBean servletDescriptorMBean) {
        if (servletDescriptorMBean == null) {
            throw new NullPointerException("null arg");
        }
        if (this.servletDescriptors == null) {
            this.servletDescriptors = new ServletDescriptorMBean[0];
        }
        int n = this.servletDescriptors.length;
        ServletDescriptorMBean[] servletDescriptorMBeanArray = new ServletDescriptorMBean[n + 1];
        System.arraycopy(this.servletDescriptors, 0, servletDescriptorMBeanArray, 0, n);
        servletDescriptorMBeanArray[n] = servletDescriptorMBean;
        this.servletDescriptors = servletDescriptorMBeanArray;
    }

    public void removeServletDescriptor(ServletDescriptorMBean servletDescriptorMBean) {
        if (this.servletDescriptors == null || servletDescriptorMBean == null) {
            return;
        }
        ArrayList<ServletDescriptorMBean> arrayList = new ArrayList<ServletDescriptorMBean>();
        for (int i = 0; i < this.servletDescriptors.length; ++i) {
            if (this.servletDescriptors[i] == servletDescriptorMBean) continue;
            arrayList.add(this.servletDescriptors[i]);
        }
        ServletDescriptorMBean[] servletDescriptorMBeanArray = new ServletDescriptorMBean[arrayList.size()];
        arrayList.toArray(servletDescriptorMBeanArray);
        this.servletDescriptors = servletDescriptorMBeanArray;
    }

    public void setContextRoot(String string) {
        String string2 = this.contextRoot;
        this.contextRoot = string;
        if (!WLWebAppDescriptor.comp(string2, string)) {
            this.firePropertyChange("contextRoot", string2, string);
        }
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setDispatchPolicy(String string) {
        String string2 = this.dispatchPolicy;
        this.dispatchPolicy = string;
        if (!WLWebAppDescriptor.comp(string2, string)) {
            this.firePropertyChange("dispatchPolicy", string2, string);
        }
    }

    public String getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setContainerDescriptor(ContainerDescriptorMBean containerDescriptorMBean) {
        this.containerDescriptor = containerDescriptorMBean;
    }

    public ContainerDescriptorMBean getContainerDescriptor() {
        return this.containerDescriptor;
    }

    public void setCharsetParams(CharsetParamsMBean charsetParamsMBean) {
        this.charsetParams = charsetParamsMBean;
    }

    public CharsetParamsMBean getCharsetParams() {
        return this.charsetParams;
    }

    public void setSecurityPermissionMBean(SecurityPermissionMBean securityPermissionMBean) {
        this.securityPermission = securityPermissionMBean;
    }

    public SecurityPermissionMBean getSecurityPermissionMBean() {
        return this.securityPermission;
    }

    public void setPreprocessors(PreprocessorMBean[] preprocessorMBeanArray) {
        PreprocessorMBean[] preprocessorMBeanArray2 = this.preprocessors;
        this.preprocessors = preprocessorMBeanArray;
        if (!WLWebAppDescriptor.comp(preprocessorMBeanArray2, preprocessorMBeanArray)) {
            this.firePropertyChange("preprocessors", preprocessorMBeanArray2, preprocessorMBeanArray);
        }
    }

    public PreprocessorMBean[] getPreprocessors() {
        return this.preprocessors;
    }

    public void addPreprocessorMBean(PreprocessorMBean preprocessorMBean) {
        PreprocessorMBean[] preprocessorMBeanArray = this.getPreprocessors();
        if (preprocessorMBeanArray == null) {
            preprocessorMBeanArray = new PreprocessorMBean[]{preprocessorMBean};
            this.setPreprocessors(preprocessorMBeanArray);
            return;
        }
        PreprocessorMBean[] preprocessorMBeanArray2 = new PreprocessorMBean[preprocessorMBeanArray.length + 1];
        System.arraycopy(preprocessorMBeanArray, 0, preprocessorMBeanArray2, 0, preprocessorMBeanArray.length);
        preprocessorMBeanArray2[preprocessorMBeanArray.length] = preprocessorMBean;
        this.setPreprocessors(preprocessorMBeanArray2);
    }

    public void removePreprocessorMBean(PreprocessorMBean preprocessorMBean) {
        PreprocessorMBean[] preprocessorMBeanArray = this.getPreprocessors();
        if (preprocessorMBeanArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < preprocessorMBeanArray.length; ++i) {
            if (!preprocessorMBeanArray[i].equals(preprocessorMBean)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            PreprocessorMBean[] preprocessorMBeanArray2 = new PreprocessorMBean[preprocessorMBeanArray.length - 1];
            System.arraycopy(preprocessorMBeanArray, 0, preprocessorMBeanArray2, 0, n);
            System.arraycopy(preprocessorMBeanArray, n + 1, preprocessorMBeanArray2, n, preprocessorMBeanArray.length - (n + 1));
            this.setPreprocessors(preprocessorMBeanArray2);
        }
    }

    public void setPreprocessorMappings(PreprocessorMappingMBean[] preprocessorMappingMBeanArray) {
        PreprocessorMappingMBean[] preprocessorMappingMBeanArray2 = this.preprocessorMaps;
        this.preprocessorMaps = preprocessorMappingMBeanArray;
        if (!WLWebAppDescriptor.comp(preprocessorMappingMBeanArray2, preprocessorMappingMBeanArray)) {
            this.firePropertyChange("preprocessorMappings", preprocessorMappingMBeanArray2, preprocessorMappingMBeanArray);
        }
    }

    public PreprocessorMappingMBean[] getPreprocessorMappings() {
        return this.preprocessorMaps;
    }

    public void addPreprocessorMappingMBean(PreprocessorMappingMBean preprocessorMappingMBean) {
        PreprocessorMappingMBean[] preprocessorMappingMBeanArray = this.getPreprocessorMappings();
        if (preprocessorMappingMBeanArray == null) {
            preprocessorMappingMBeanArray = new PreprocessorMappingMBean[]{preprocessorMappingMBean};
            this.setPreprocessorMappings(preprocessorMappingMBeanArray);
            return;
        }
        PreprocessorMappingMBean[] preprocessorMappingMBeanArray2 = new PreprocessorMappingMBean[preprocessorMappingMBeanArray.length + 1];
        System.arraycopy(preprocessorMappingMBeanArray, 0, preprocessorMappingMBeanArray2, 0, preprocessorMappingMBeanArray.length);
        preprocessorMappingMBeanArray2[preprocessorMappingMBeanArray.length] = preprocessorMappingMBean;
        this.setPreprocessorMappings(preprocessorMappingMBeanArray2);
    }

    public void removePreprocessorMappingMBean(PreprocessorMappingMBean preprocessorMappingMBean) {
        PreprocessorMappingMBean[] preprocessorMappingMBeanArray = this.getPreprocessorMappings();
        if (preprocessorMappingMBeanArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < preprocessorMappingMBeanArray.length; ++i) {
            if (!preprocessorMappingMBeanArray[i].equals(preprocessorMappingMBean)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            PreprocessorMappingMBean[] preprocessorMappingMBeanArray2 = new PreprocessorMappingMBean[preprocessorMappingMBeanArray.length - 1];
            System.arraycopy(preprocessorMappingMBeanArray, 0, preprocessorMappingMBeanArray2, 0, n);
            System.arraycopy(preprocessorMappingMBeanArray, n + 1, preprocessorMappingMBeanArray2, n, preprocessorMappingMBeanArray.length - (n + 1));
            this.setPreprocessorMappings(preprocessorMappingMBeanArray2);
        }
    }

    public void validate() throws DescriptorValidationException {
        int n;
        this.removeDescriptorErrors();
        boolean bl = true;
        if (this.securityRoleAssignments != null) {
            for (n = 0; n < this.securityRoleAssignments.length; ++n) {
                bl &= this.check(this.securityRoleAssignments[n]);
            }
        }
        if (this.virtualDirectories != null) {
            for (n = 0; n < this.virtualDirectories.length; ++n) {
                bl &= this.check(this.virtualDirectories[n]);
            }
        }
        if (this.refDes != null) {
            bl &= this.check(this.refDes);
        }
        if (this.sessDes != null) {
            bl &= this.check(this.sessDes);
        }
        if (this.jspDes != null) {
            bl &= this.check(this.jspDes);
        }
        if (this.wlAuthFilter != null) {
            bl &= this.check(this.wlAuthFilter);
        }
        if (this.urlMatchMap != null) {
            bl &= this.check(this.urlMatchMap);
        }
        if (this.containerDescriptor != null) {
            bl &= this.check(this.containerDescriptor);
        }
        if (this.charsetParams != null) {
            bl &= this.check(this.charsetParams);
        }
        if (this.preprocessors != null) {
            for (n = 0; n < this.preprocessors.length; ++n) {
                bl &= this.check(this.preprocessors[n]);
            }
        }
        if (this.preprocessorMaps != null) {
            for (n = 0; n < this.preprocessorMaps.length; ++n) {
                bl &= this.check(this.preprocessorMaps[n]);
            }
        }
        if (!bl) {
            String[] stringArray = this.getDescriptorErrors();
            throw new DescriptorValidationException(this.arrayToString(stringArray));
        }
    }

    public String toXML(int n) {
        WebElementMBean webElementMBean2;
        int n2;
        String string = "";
        String string2 = this.getEncoding();
        if (string2 != null) {
            string = string + "<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>\n";
        }
        string = string + this.indentStr(n) + "<!DOCTYPE weblogic-web-app PUBLIC \"-//BEA Systems, Inc.//DTD Web Application 8.1//EN\" \"http://www.bea.com/servers/wls810/dtd/weblogic810-web-jar.dtd\">" + "\n";
        string = string + "\n" + this.indentStr(n) + "<weblogic-web-app>\n";
        n += 2;
        if (this.wlDescription != null) {
            string = string + "\n" + this.indentStr(n) + "<description>" + this.wlDescription + "</description>\n";
        }
        if (this.wlVersion != null) {
            string = string + "\n" + this.indentStr(n) + "<weblogic-version>" + this.wlVersion + "</weblogic-version>\n";
        }
        if (this.securityRoleAssignments != null) {
            for (n2 = 0; n2 < this.securityRoleAssignments.length; ++n2) {
                webElementMBean2 = this.securityRoleAssignments[n2];
                string = string + "\n" + webElementMBean2.toXML(n);
            }
        }
        if (this.runAsRoleAssignments != null) {
            for (n2 = 0; n2 < this.runAsRoleAssignments.length; ++n2) {
                webElementMBean2 = this.runAsRoleAssignments[n2];
                String string3 = webElementMBean2.toXML(n);
                if (string3 == null || string3.length() <= 0) continue;
                string = string + '\n' + string3;
            }
        }
        if (this.refDes != null) {
            string = string + "\n" + this.refDes.toXML(n);
        }
        if (this.sessDes != null) {
            string = string + "\n" + this.sessDes.toXML(n);
        }
        if (this.jspDes != null) {
            string = string + "\n" + this.jspDes.toXML(n);
        }
        if (this.wlAuthFilter != null) {
            string = string + "\n" + this.wlAuthFilter.toXML(n);
        }
        if (this.containerDescriptor != null) {
            string = string + "\n" + this.containerDescriptor.toXML(n);
        }
        if (this.charsetParams != null) {
            string = string + "\n" + this.charsetParams.toXML(n);
        }
        if (this.virtualDirectories != null) {
            for (n2 = 0; n2 < this.virtualDirectories.length; ++n2) {
                webElementMBean2 = this.virtualDirectories[n2];
                string = string + "\n" + webElementMBean2.toXML(n);
            }
        }
        if (this.urlMatchMap != null) {
            string = string + "\n" + this.urlMatchMap.toXML(n);
        }
        if (this.preprocessors != null) {
            for (n2 = 0; n2 < this.preprocessors.length; ++n2) {
                webElementMBean2 = this.preprocessors[n2];
                string = string + "\n" + webElementMBean2.toXML(n);
            }
        }
        if (this.preprocessorMaps != null) {
            for (n2 = 0; n2 < this.preprocessorMaps.length; ++n2) {
                webElementMBean2 = this.preprocessorMaps[n2];
                string = string + "\n" + webElementMBean2.toXML(n);
            }
        }
        if (this.securityPermission != null) {
            string = string + "\n" + this.securityPermission.toXML(n);
        }
        if (this.contextRoot != null && this.contextRoot.trim().length() > 0) {
            string = string + "\n" + this.indentStr(n) + "<context-root>" + this.contextRoot + "</context-root>";
        }
        if (this.dispatchPolicy != null && this.dispatchPolicy.trim().length() > 0) {
            string = string + "\n" + this.indentStr(n) + "<wl-dispatch-policy>" + this.dispatchPolicy + "</wl-dispatch-policy>";
        }
        if (this.servletDescriptors != null) {
            for (n2 = 0; n2 < this.servletDescriptors.length; ++n2) {
                string = string + "\n" + this.servletDescriptors[n2].toXML(n);
            }
        }
        if (this.migrationServletDescriptors != null) {
            for (WebElementMBean webElementMBean2 : this.migrationServletDescriptors) {
                string = string + "\n" + webElementMBean2.toXML(n);
            }
        }
        string = string + "\n" + this.indentStr(n -= 2) + "</weblogic-web-app>\n";
        return string;
    }
}

