/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.WebElementMBean;
import weblogic.management.descriptors.webapp.EjbRefMBean;
import weblogic.management.descriptors.webapp.EnvEntryMBean;
import weblogic.management.descriptors.webapp.ErrorPageMBean;
import weblogic.management.descriptors.webapp.FilterMBean;
import weblogic.management.descriptors.webapp.FilterMappingMBean;
import weblogic.management.descriptors.webapp.ListenerMBean;
import weblogic.management.descriptors.webapp.LoginConfigMBean;
import weblogic.management.descriptors.webapp.MimeMappingMBean;
import weblogic.management.descriptors.webapp.ParameterMBean;
import weblogic.management.descriptors.webapp.ResourceEnvRefMBean;
import weblogic.management.descriptors.webapp.ResourceRefMBean;
import weblogic.management.descriptors.webapp.SecurityConstraintMBean;
import weblogic.management.descriptors.webapp.SecurityRoleMBean;
import weblogic.management.descriptors.webapp.ServletMBean;
import weblogic.management.descriptors.webapp.ServletMappingMBean;
import weblogic.management.descriptors.webapp.SessionConfigMBean;
import weblogic.management.descriptors.webapp.TagLibMBean;
import weblogic.management.descriptors.webapp.UIMBean;
import weblogic.management.descriptors.webapp.WebAppDescriptorMBean;
import weblogic.management.descriptors.webapp.WelcomeFileListMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.DescriptorConstants;
import weblogic.servlet.internal.dd.EJBLocalReference;
import weblogic.servlet.internal.dd.EJBReference;
import weblogic.servlet.internal.dd.EnvironmentEntry;
import weblogic.servlet.internal.dd.ErrorPageDescriptor;
import weblogic.servlet.internal.dd.FilterDescriptor;
import weblogic.servlet.internal.dd.FilterMappingDescriptor;
import weblogic.servlet.internal.dd.ListenerDescriptor;
import weblogic.servlet.internal.dd.LoginDescriptor;
import weblogic.servlet.internal.dd.MimeMappingDescriptor;
import weblogic.servlet.internal.dd.ParameterDescriptor;
import weblogic.servlet.internal.dd.ResourceEnvRef;
import weblogic.servlet.internal.dd.ResourceReference;
import weblogic.servlet.internal.dd.SecurityConstraint;
import weblogic.servlet.internal.dd.SecurityRoleDescriptor;
import weblogic.servlet.internal.dd.ServletDescriptor;
import weblogic.servlet.internal.dd.ServletMappingDescriptor;
import weblogic.servlet.internal.dd.SessionDescriptor;
import weblogic.servlet.internal.dd.TaglibDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.internal.dd.UIDescriptor;
import weblogic.servlet.internal.dd.WelcomeFilesDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class WebAppDescriptor
extends BaseServletDescriptor
implements ToXML,
WebAppDescriptorMBean,
DescriptorConstants,
Comparator {
    private static final long serialVersionUID = -4056254418170227485L;
    private static final String CONTEXT_PARAM = "context-param";
    private static final String DISTRIBUTABLE = "distributable";
    private static final String SERVLET = "servlet";
    private static final String SERVLET_MAPPING = "servlet-mapping";
    private static final String SESSION_CONFIG = "session-config";
    private static final String MIME_MAPPING = "mime-mapping";
    private static final String WELCOME_FILE_LIST = "welcome-file-list";
    private static final String ERROR_PAGE = "error-page";
    private static final String RESOURCE_REF = "resource-ref";
    private static final String RESOURCE_ENV_REF = "resource-env-ref";
    private static final String ENV_ENTRY = "env-entry";
    private static final String EJB_REF = "ejb-ref";
    private static final String EJB_LOCAL_REF = "ejb-local-ref";
    private static final String TAGLIB = "taglib";
    private static final String TAGLIB_URI = "taglib-uri";
    private static final String TAGLIB_LOCATION = "taglib-location";
    private static final String SECURITY_ROLE = "security-role";
    private static final String SECURITY_CONSTRAINT = "security-constraint";
    private static final String LOGIN_CONFIG = "login-config";
    private static final String EVENT_LISTENER = "listener";
    private static final String FILTER = "filter";
    private static final String FILTER_MAPPING = "filter-mapping";
    private UIMBean uiData;
    private List contextParams;
    private List servlets;
    private List servletMaps;
    private SessionConfigMBean sessionConfig;
    private List mimeMaps;
    private WelcomeFileListMBean welcomeFiles;
    private List errorPages;
    private List resourceRefs;
    private List resourceEnvRefs;
    private List envEntries;
    private List ejbRefs;
    private List ejbLocalRefs;
    private List taglibs;
    private List secRoles;
    private List secCons;
    private List eventListeners;
    private List filters;
    private List filterMappings;
    private LoginConfigMBean login;
    private boolean distributable = false;
    private String root;
    private String deployedName;
    private boolean archived;
    private boolean deployed;
    private String descriptorEncoding = null;
    private String descriptorVersion = null;
    private static final String WL_JSP = "weblogic.jsp.";
    private static final String WL_SESSION = "weblogic.httpd.session.";
    private static final String WL_COOKIE = "weblogic.httpd.session.cookie.";

    public String getEncoding() {
        return this.descriptorEncoding;
    }

    public void setEncoding(String string) {
        this.descriptorEncoding = string;
    }

    public String getVersion() {
        return this.descriptorVersion;
    }

    public void setVersion(String string) {
        this.descriptorVersion = string;
    }

    public WebAppDescriptor() {
        this.sessionConfig = new SessionDescriptor();
    }

    public WebAppDescriptor(Element element) throws DOMProcessingException {
        this.uiData = new UIDescriptor(element);
        List list = DOMUtils.getOptionalElementsByTagName(element, DISTRIBUTABLE);
        if (list != null && list.size() > 0) {
            this.distributable = true;
        }
        list = DOMUtils.getOptionalElementsByTagName(element, CONTEXT_PARAM);
        Iterator iterator = list.iterator();
        this.contextParams = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.contextParams.add(new ParameterDescriptor((Element)iterator.next()));
        }
        list = DOMUtils.getOptionalElementsByTagName(element, EVENT_LISTENER);
        iterator = list.iterator();
        this.eventListeners = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.eventListeners.add(new ListenerDescriptor((Element)iterator.next()));
        }
        list = DOMUtils.getOptionalElementsByTagName(element, SECURITY_ROLE);
        iterator = list.iterator();
        this.secRoles = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.secRoles.add(new SecurityRoleDescriptor((Element)iterator.next()));
        }
        list = DOMUtils.getOptionalElementsByTagName(element, SERVLET);
        iterator = list.iterator();
        this.servlets = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.servlets.add(new ServletDescriptor(this, (Element)iterator.next()));
        }
        Object object = new ServletMBean[this.servlets.size()];
        this.servlets.toArray((T[])object);
        this.setServlets((ServletMBean[])object);
        list = DOMUtils.getOptionalElementsByTagName(element, SERVLET_MAPPING);
        iterator = list.iterator();
        this.servletMaps = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.servletMaps.add(new ServletMappingDescriptor(this, (Element)iterator.next()));
        }
        list = DOMUtils.getOptionalElementsByTagName(element, FILTER);
        iterator = list.iterator();
        this.filters = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.filters.add(new FilterDescriptor((Element)iterator.next()));
        }
        object = new FilterMBean[this.filters.size()];
        this.filters.toArray((T[])object);
        this.setFilters((FilterMBean[])object);
        list = DOMUtils.getOptionalElementsByTagName(element, FILTER_MAPPING);
        iterator = list.iterator();
        this.filterMappings = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.filterMappings.add(new FilterMappingDescriptor(this, (Element)iterator.next()));
        }
        Element element2 = DOMUtils.getOptionalElementByTagName(element, SESSION_CONFIG);
        this.sessionConfig = element2 != null ? new SessionDescriptor(element2) : new SessionDescriptor();
        list = DOMUtils.getOptionalElementsByTagName(element, MIME_MAPPING);
        iterator = list.iterator();
        this.mimeMaps = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.mimeMaps.add(new MimeMappingDescriptor((Element)iterator.next()));
        }
        element2 = DOMUtils.getOptionalElementByTagName(element, WELCOME_FILE_LIST);
        if (element2 != null) {
            this.welcomeFiles = new WelcomeFilesDescriptor(element2);
        }
        list = DOMUtils.getOptionalElementsByTagName(element, ERROR_PAGE);
        iterator = list.iterator();
        this.errorPages = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.errorPages.add(new ErrorPageDescriptor((Element)iterator.next()));
        }
        list = DOMUtils.getOptionalElementsByTagName(element, RESOURCE_REF);
        iterator = list.iterator();
        this.resourceRefs = new ArrayList(list.size());
        while (iterator.hasNext()) {
            object = new ResourceReference((Element)iterator.next());
            this.resourceRefs.add(object);
        }
        list = DOMUtils.getOptionalElementsByTagName(element, RESOURCE_ENV_REF);
        iterator = list.iterator();
        this.resourceEnvRefs = new ArrayList(list.size());
        while (iterator.hasNext()) {
            object = new ResourceEnvRef((Element)iterator.next());
            this.resourceEnvRefs.add(object);
        }
        list = DOMUtils.getOptionalElementsByTagName(element, ENV_ENTRY);
        iterator = list.iterator();
        this.envEntries = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.envEntries.add(new EnvironmentEntry((Element)iterator.next()));
        }
        list = DOMUtils.getOptionalElementsByTagName(element, EJB_REF);
        iterator = list.iterator();
        this.ejbRefs = new ArrayList(list.size());
        while (iterator.hasNext()) {
            object = new EJBReference((Element)iterator.next());
            this.ejbRefs.add(object);
        }
        list = DOMUtils.getOptionalElementsByTagName(element, EJB_LOCAL_REF);
        iterator = list.iterator();
        this.ejbLocalRefs = new ArrayList(list.size());
        while (iterator.hasNext()) {
            object = new EJBLocalReference((Element)iterator.next());
            this.ejbLocalRefs.add(object);
        }
        list = DOMUtils.getOptionalElementsByTagName(element, TAGLIB);
        iterator = list.iterator();
        this.taglibs = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.taglibs.add(new TaglibDescriptor((Element)iterator.next()));
        }
        list = DOMUtils.getOptionalElementsByTagName(element, SECURITY_CONSTRAINT);
        iterator = list.iterator();
        this.secCons = new ArrayList(list.size());
        while (iterator.hasNext()) {
            this.secCons.add(new SecurityConstraint(this, (Element)iterator.next()));
        }
        element2 = DOMUtils.getOptionalElementByTagName(element, LOGIN_CONFIG);
        if (element2 != null) {
            this.login = new LoginDescriptor(element2);
        }
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public void setDeployed(boolean bl) {
        this.deployed = bl;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean bl) {
        this.archived = bl;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String string) {
        this.root = string;
    }

    public String getDeployedName() {
        return this.deployedName;
    }

    public void setDeployedName(String string) {
        this.deployedName = string;
    }

    public String getDisplayName() {
        if (this.getUIData() != null) {
            return this.getUIData().getDisplayName();
        }
        return null;
    }

    public void setDisplayName(String string) {
        String string2 = this.getDisplayName();
        if (this.getUIData() != null) {
            this.getUIData().setDisplayName(string);
        }
        if (!WebAppDescriptor.comp(string2, string)) {
            this.firePropertyChange("displayName", string2, string);
        }
    }

    public UIMBean getUIData() {
        return this.uiData;
    }

    public void setUIData(UIMBean uIMBean) {
        this.uiData = uIMBean;
    }

    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean bl) {
        if (bl != this.isDistributable()) {
            this.distributable = bl;
            this.firePropertyChange(DISTRIBUTABLE, new Boolean(!bl), new Boolean(bl));
        }
    }

    public ParameterMBean[] getContextParams() {
        if (this.contextParams == null) {
            return new ParameterDescriptor[0];
        }
        ParameterMBean[] parameterMBeanArray = new ParameterDescriptor[this.contextParams.size()];
        this.contextParams.toArray(parameterMBeanArray);
        return parameterMBeanArray;
    }

    public void setContextParams(ParameterMBean[] parameterMBeanArray) {
        ParameterMBean[] parameterMBeanArray2 = this.getContextParams();
        this.contextParams = new ArrayList();
        if (parameterMBeanArray == null) {
            return;
        }
        for (int i = 0; i < parameterMBeanArray.length; ++i) {
            this.contextParams.add(parameterMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(parameterMBeanArray2, parameterMBeanArray)) {
            this.firePropertyChange("contextParams", parameterMBeanArray2, parameterMBeanArray);
        }
    }

    public void addContextParam(ParameterMBean parameterMBean) {
        ParameterMBean[] parameterMBeanArray = this.getContextParams();
        if (parameterMBeanArray == null) {
            parameterMBeanArray = new ParameterMBean[]{parameterMBean};
            this.setContextParams(parameterMBeanArray);
            return;
        }
        ParameterMBean[] parameterMBeanArray2 = new ParameterMBean[parameterMBeanArray.length + 1];
        System.arraycopy(parameterMBeanArray, 0, parameterMBeanArray2, 0, parameterMBeanArray.length);
        parameterMBeanArray2[parameterMBeanArray.length] = parameterMBean;
        this.setContextParams(parameterMBeanArray2);
    }

    public void removeContextParam(ParameterMBean parameterMBean) {
        ParameterMBean[] parameterMBeanArray = this.getContextParams();
        if (parameterMBeanArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < parameterMBeanArray.length; ++i) {
            if (!parameterMBeanArray[i].equals(parameterMBean)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            ParameterMBean[] parameterMBeanArray2 = new ParameterMBean[parameterMBeanArray.length - 1];
            System.arraycopy(parameterMBeanArray, 0, parameterMBeanArray2, 0, n);
            System.arraycopy(parameterMBeanArray, n + 1, parameterMBeanArray2, n, parameterMBeanArray.length - (n + 1));
            this.setContextParams(parameterMBeanArray2);
        }
    }

    public ListenerMBean[] getListeners() {
        if (this.eventListeners == null) {
            return new ListenerDescriptor[0];
        }
        ListenerMBean[] listenerMBeanArray = new ListenerDescriptor[this.eventListeners.size()];
        this.eventListeners.toArray(listenerMBeanArray);
        return listenerMBeanArray;
    }

    public void setListeners(ListenerMBean[] listenerMBeanArray) {
        ListenerMBean[] listenerMBeanArray2 = this.getListeners();
        this.eventListeners = new ArrayList();
        if (listenerMBeanArray == null) {
            return;
        }
        for (int i = 0; i < listenerMBeanArray.length; ++i) {
            this.eventListeners.add(listenerMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(listenerMBeanArray2, listenerMBeanArray)) {
            this.firePropertyChange("listeners", listenerMBeanArray2, listenerMBeanArray);
        }
    }

    public void addListener(ListenerMBean listenerMBean) {
        ListenerMBean[] listenerMBeanArray = this.getListeners();
        if (listenerMBeanArray == null) {
            listenerMBeanArray = new ListenerMBean[]{listenerMBean};
            this.setListeners(listenerMBeanArray);
            return;
        }
        ListenerMBean[] listenerMBeanArray2 = new ListenerMBean[listenerMBeanArray.length + 1];
        System.arraycopy(listenerMBeanArray, 0, listenerMBeanArray2, 0, listenerMBeanArray.length);
        listenerMBeanArray2[listenerMBeanArray.length] = listenerMBean;
        this.setListeners(listenerMBeanArray2);
    }

    public void removeListener(ListenerMBean listenerMBean) {
        ListenerMBean[] listenerMBeanArray = this.getListeners();
        if (listenerMBeanArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < listenerMBeanArray.length; ++i) {
            if (!listenerMBeanArray[i].equals(listenerMBean)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            ListenerMBean[] listenerMBeanArray2 = new ListenerMBean[listenerMBeanArray.length - 1];
            System.arraycopy(listenerMBeanArray, 0, listenerMBeanArray2, 0, n);
            System.arraycopy(listenerMBeanArray, n + 1, listenerMBeanArray2, n, listenerMBeanArray.length - (n + 1));
            this.setListeners(listenerMBeanArray2);
        }
    }

    public FilterMBean[] getFilters() {
        if (this.filters == null) {
            return new FilterMBean[0];
        }
        FilterMBean[] filterMBeanArray = new FilterMBean[this.filters.size()];
        this.filters.toArray(filterMBeanArray);
        return filterMBeanArray;
    }

    public void setFilters(FilterMBean[] filterMBeanArray) {
        FilterMBean[] filterMBeanArray2 = this.getFilters();
        this.filters = new ArrayList();
        if (filterMBeanArray == null) {
            return;
        }
        Arrays.sort(filterMBeanArray, this);
        for (int i = 0; i < filterMBeanArray.length; ++i) {
            this.filters.add(filterMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(filterMBeanArray2, filterMBeanArray)) {
            this.firePropertyChange("filters", filterMBeanArray2, filterMBeanArray);
        }
    }

    public void addFilter(FilterMBean filterMBean) {
        FilterMBean[] filterMBeanArray = this.getFilters();
        if (filterMBeanArray == null) {
            filterMBeanArray = new FilterMBean[1];
            filterMBeanArray[1] = filterMBean;
            this.setFilters(filterMBeanArray);
            return;
        }
        FilterMBean[] filterMBeanArray2 = new FilterMBean[filterMBeanArray.length + 1];
        System.arraycopy(filterMBeanArray, 0, filterMBeanArray2, 0, filterMBeanArray.length);
        filterMBeanArray2[filterMBeanArray.length] = filterMBean;
        this.setFilters(filterMBeanArray2);
    }

    public void removeFilter(FilterMBean filterMBean) {
        FilterMBean[] filterMBeanArray = this.getFilters();
        if (filterMBeanArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < filterMBeanArray.length; ++i) {
            if (!filterMBeanArray[i].equals(filterMBean)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            FilterMBean[] filterMBeanArray2 = new FilterMBean[filterMBeanArray.length - 1];
            System.arraycopy(filterMBeanArray, 0, filterMBeanArray2, 0, n);
            System.arraycopy(filterMBeanArray, n + 1, filterMBeanArray2, n, filterMBeanArray.length - (n + 1));
            this.setFilters(filterMBeanArray2);
        }
    }

    public FilterMappingMBean[] getFilterMappings() {
        if (this.filterMappings == null) {
            return new FilterMappingDescriptor[0];
        }
        FilterMappingMBean[] filterMappingMBeanArray = new FilterMappingDescriptor[this.filterMappings.size()];
        this.filterMappings.toArray(filterMappingMBeanArray);
        return filterMappingMBeanArray;
    }

    public void setFilterMappings(FilterMappingMBean[] filterMappingMBeanArray) {
        FilterMappingMBean[] filterMappingMBeanArray2 = this.getFilterMappings();
        this.filterMappings = new ArrayList();
        if (filterMappingMBeanArray == null) {
            return;
        }
        for (int i = 0; i < filterMappingMBeanArray.length; ++i) {
            this.filterMappings.add(filterMappingMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(filterMappingMBeanArray2, filterMappingMBeanArray)) {
            this.firePropertyChange("filterMappings", filterMappingMBeanArray2, filterMappingMBeanArray);
        }
    }

    public void addFilterMapping(FilterMappingMBean filterMappingMBean) {
        FilterMappingMBean[] filterMappingMBeanArray = this.getFilterMappings();
        if (filterMappingMBeanArray == null) {
            filterMappingMBeanArray = new FilterMappingMBean[1];
            filterMappingMBeanArray[1] = filterMappingMBean;
            this.setFilterMappings(filterMappingMBeanArray);
            return;
        }
        FilterMappingMBean[] filterMappingMBeanArray2 = new FilterMappingMBean[filterMappingMBeanArray.length + 1];
        System.arraycopy(filterMappingMBeanArray, 0, filterMappingMBeanArray2, 0, filterMappingMBeanArray.length);
        filterMappingMBeanArray2[filterMappingMBeanArray.length] = filterMappingMBean;
        this.setFilterMappings(filterMappingMBeanArray2);
    }

    public void removeFilterMapping(FilterMappingMBean filterMappingMBean) {
        FilterMappingMBean[] filterMappingMBeanArray = this.getFilterMappings();
        if (filterMappingMBeanArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < filterMappingMBeanArray.length; ++i) {
            if (!filterMappingMBeanArray[i].equals(filterMappingMBean)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            FilterMappingMBean[] filterMappingMBeanArray2 = new FilterMappingMBean[filterMappingMBeanArray.length - 1];
            System.arraycopy(filterMappingMBeanArray, 0, filterMappingMBeanArray2, 0, n);
            System.arraycopy(filterMappingMBeanArray, n + 1, filterMappingMBeanArray2, n, filterMappingMBeanArray.length - (n + 1));
            this.setFilterMappings(filterMappingMBeanArray2);
        }
    }

    public ServletMBean[] getServlets() {
        if (this.servlets == null) {
            return new ServletMBean[0];
        }
        ServletMBean[] servletMBeanArray = new ServletMBean[this.servlets.size()];
        this.servlets.toArray(servletMBeanArray);
        return servletMBeanArray;
    }

    public void setServlets(ServletMBean[] servletMBeanArray) {
        int n;
        ServletMBean[] servletMBeanArray2 = this.getServlets();
        this.servlets = new ArrayList();
        if (servletMBeanArray == null) {
            return;
        }
        for (n = 0; n < servletMBeanArray.length; ++n) {
            if (servletMBeanArray[n] != null) continue;
            throw new NullPointerException("null element " + n);
        }
        Arrays.sort(servletMBeanArray, this);
        for (n = 0; n < servletMBeanArray.length; ++n) {
            this.servlets.add(servletMBeanArray[n]);
        }
        if (!WebAppDescriptor.comp(servletMBeanArray2, servletMBeanArray)) {
            this.firePropertyChange("servlets", servletMBeanArray2, servletMBeanArray);
        }
    }

    public void addServlet(ServletMBean servletMBean) {
        if (this.servlets == null) {
            this.servlets = new ArrayList();
        }
        this.servlets.add(servletMBean);
    }

    public void removeServlet(ServletMBean servletMBean) {
        if (this.servlets != null) {
            this.servlets.remove(servletMBean);
        }
    }

    public ServletMBean getServlet(String string) {
        if (string != null && this.servlets != null) {
            for (int i = 0; i < this.servlets.size(); ++i) {
                ServletMBean servletMBean = (ServletMBean)this.servlets.get(i);
                if (!string.equals(servletMBean.getName())) continue;
                return servletMBean;
            }
        }
        return null;
    }

    public String[] getServletNames() {
        ServletDescriptor[] servletDescriptorArray = (ServletDescriptor[])this.getServlets();
        String[] stringArray = new String[servletDescriptorArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = servletDescriptorArray[i].getServletName();
        }
        return stringArray;
    }

    public ServletMappingMBean[] getServletMappings() {
        if (this.servletMaps == null) {
            return new ServletMappingDescriptor[0];
        }
        ServletMappingDescriptor[] servletMappingDescriptorArray = new ServletMappingDescriptor[this.servletMaps.size()];
        return this.servletMaps.toArray(servletMappingDescriptorArray);
    }

    public void setServletMappings(ServletMappingMBean[] servletMappingMBeanArray) {
        ServletMappingMBean[] servletMappingMBeanArray2 = this.getServletMappings();
        this.servletMaps = new ArrayList();
        if (servletMappingMBeanArray == null) {
            return;
        }
        for (int i = 0; i < servletMappingMBeanArray.length; ++i) {
            this.servletMaps.add(servletMappingMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(servletMappingMBeanArray2, servletMappingMBeanArray)) {
            this.firePropertyChange("servletMappings", servletMappingMBeanArray2, servletMappingMBeanArray);
        }
    }

    public void addServletMapping(ServletMappingMBean servletMappingMBean) {
        if (this.servletMaps == null) {
            this.servletMaps = new ArrayList();
        }
        this.servletMaps.add(servletMappingMBean);
    }

    public void removeServletMapping(ServletMappingMBean servletMappingMBean) {
        if (this.servletMaps != null) {
            this.servletMaps.remove(servletMappingMBean);
        }
    }

    public SessionConfigMBean getSessionConfig() {
        return this.sessionConfig;
    }

    public void setSessionConfig(SessionConfigMBean sessionConfigMBean) {
        this.sessionConfig = sessionConfigMBean;
    }

    public MimeMappingMBean[] getMimeMappings() {
        if (this.mimeMaps == null) {
            return new MimeMappingDescriptor[0];
        }
        MimeMappingMBean[] mimeMappingMBeanArray = new MimeMappingDescriptor[this.mimeMaps.size()];
        this.mimeMaps.toArray(mimeMappingMBeanArray);
        return mimeMappingMBeanArray;
    }

    public void setMimeMappings(MimeMappingMBean[] mimeMappingMBeanArray) {
        MimeMappingMBean[] mimeMappingMBeanArray2 = this.getMimeMappings();
        this.mimeMaps = new ArrayList();
        if (mimeMappingMBeanArray == null) {
            return;
        }
        for (int i = 0; i < mimeMappingMBeanArray.length; ++i) {
            this.mimeMaps.add(mimeMappingMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(mimeMappingMBeanArray2, mimeMappingMBeanArray)) {
            this.firePropertyChange("mimeMappings", mimeMappingMBeanArray2, mimeMappingMBeanArray);
        }
    }

    public void addMimeMapping(MimeMappingMBean mimeMappingMBean) {
        if (this.mimeMaps == null) {
            this.mimeMaps = new ArrayList();
        }
        this.mimeMaps.add(mimeMappingMBean);
    }

    public void removeMimeMapping(MimeMappingMBean mimeMappingMBean) {
        if (this.mimeMaps == null) {
            return;
        }
        this.mimeMaps.remove(mimeMappingMBean);
    }

    public WelcomeFileListMBean getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public void setWelcomeFiles(WelcomeFileListMBean welcomeFileListMBean) {
        this.welcomeFiles = welcomeFileListMBean;
    }

    public ErrorPageMBean[] getErrorPages() {
        if (this.errorPages == null) {
            return new ErrorPageDescriptor[0];
        }
        ErrorPageMBean[] errorPageMBeanArray = new ErrorPageDescriptor[this.errorPages.size()];
        this.errorPages.toArray(errorPageMBeanArray);
        return errorPageMBeanArray;
    }

    public void setErrorPages(ErrorPageMBean[] errorPageMBeanArray) {
        ErrorPageMBean[] errorPageMBeanArray2 = this.getErrorPages();
        this.errorPages = new ArrayList();
        if (errorPageMBeanArray == null) {
            return;
        }
        for (int i = 0; i < errorPageMBeanArray.length; ++i) {
            this.errorPages.add(new ErrorPageDescriptor(errorPageMBeanArray[i]));
        }
        if (!WebAppDescriptor.comp(errorPageMBeanArray2, errorPageMBeanArray)) {
            this.firePropertyChange("errorPages", errorPageMBeanArray2, errorPageMBeanArray);
        }
    }

    public void addErrorPage(ErrorPageMBean errorPageMBean) {
        if (this.errorPages == null) {
            this.errorPages = new ArrayList();
        }
        this.errorPages.add(errorPageMBean);
    }

    public void removeErrorPage(ErrorPageMBean errorPageMBean) {
        this.errorPages.remove(errorPageMBean);
    }

    public EnvEntryMBean[] getEnvironmentEntries() {
        if (this.envEntries == null) {
            return new EnvEntryMBean[0];
        }
        EnvironmentEntry[] environmentEntryArray = new EnvironmentEntry[this.envEntries.size()];
        return this.envEntries.toArray(environmentEntryArray);
    }

    public void setEnvironmentEntries(EnvEntryMBean[] envEntryMBeanArray) {
        EnvEntryMBean[] envEntryMBeanArray2 = this.getEnvironmentEntries();
        this.envEntries = new ArrayList();
        if (envEntryMBeanArray == null) {
            return;
        }
        for (int i = 0; i < envEntryMBeanArray.length; ++i) {
            this.envEntries.add(envEntryMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(envEntryMBeanArray2, envEntryMBeanArray)) {
            this.firePropertyChange("environmentEntries", envEntryMBeanArray2, envEntryMBeanArray);
        }
    }

    public void addEnvironmentEntry(EnvEntryMBean envEntryMBean) {
        if (this.envEntries == null) {
            this.envEntries = new ArrayList();
        }
        this.envEntries.add(envEntryMBean);
    }

    public void removeEnvironmentEntry(EnvEntryMBean envEntryMBean) {
        if (this.envEntries == null) {
            return;
        }
        this.envEntries.remove(envEntryMBean);
    }

    public ResourceRefMBean[] getResourceReferences() {
        if (this.resourceRefs == null) {
            return new ResourceReference[0];
        }
        ResourceReference[] resourceReferenceArray = new ResourceReference[this.resourceRefs.size()];
        return this.resourceRefs.toArray(resourceReferenceArray);
    }

    public void setResourceReferences(ResourceRefMBean[] resourceRefMBeanArray) {
        ResourceRefMBean[] resourceRefMBeanArray2 = this.getResourceReferences();
        this.resourceRefs = new ArrayList();
        if (resourceRefMBeanArray == null) {
            return;
        }
        for (int i = 0; i < resourceRefMBeanArray.length; ++i) {
            this.resourceRefs.add(resourceRefMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(resourceRefMBeanArray2, resourceRefMBeanArray)) {
            this.firePropertyChange("resourceReferences", resourceRefMBeanArray2, resourceRefMBeanArray);
        }
    }

    public void addResourceReference(ResourceRefMBean resourceRefMBean) {
        if (this.resourceRefs == null) {
            this.resourceRefs = new ArrayList();
        }
        this.resourceRefs.add(resourceRefMBean);
    }

    public void removeResourceReference(ResourceRefMBean resourceRefMBean) {
        if (this.resourceRefs != null) {
            this.resourceRefs.remove(resourceRefMBean);
        }
    }

    public ResourceReference getResourceReference(String string) {
        if (this.resourceRefs == null) {
            return null;
        }
        for (ResourceReference resourceReference : this.resourceRefs) {
            if (!string.equals(resourceReference.getRefName())) continue;
            return resourceReference;
        }
        return null;
    }

    public ResourceEnvRefMBean[] getResourceEnvRefs() {
        if (this.resourceEnvRefs == null) {
            return new ResourceEnvRefMBean[0];
        }
        ResourceEnvRef[] resourceEnvRefArray = new ResourceEnvRef[this.resourceEnvRefs.size()];
        return this.resourceEnvRefs.toArray(resourceEnvRefArray);
    }

    public void setResourceEnvRefs(ResourceEnvRefMBean[] resourceEnvRefMBeanArray) {
        ResourceEnvRefMBean[] resourceEnvRefMBeanArray2 = this.getResourceEnvRefs();
        this.resourceEnvRefs = new ArrayList();
        if (resourceEnvRefMBeanArray == null) {
            return;
        }
        for (int i = 0; i < resourceEnvRefMBeanArray.length; ++i) {
            this.resourceEnvRefs.add(resourceEnvRefMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(resourceEnvRefMBeanArray2, resourceEnvRefMBeanArray)) {
            this.firePropertyChange("resourceEnvRefs", resourceEnvRefMBeanArray2, resourceEnvRefMBeanArray);
        }
    }

    public void addResourceEnvRef(ResourceEnvRefMBean resourceEnvRefMBean) {
        if (this.resourceEnvRefs == null) {
            this.resourceEnvRefs = new ArrayList();
        }
        this.resourceEnvRefs.add(resourceEnvRefMBean);
    }

    public void removeResourceEnvRef(ResourceEnvRefMBean resourceEnvRefMBean) {
        if (this.resourceEnvRefs == null) {
            return;
        }
        this.resourceEnvRefs.remove(resourceEnvRefMBean);
    }

    public EjbRefMBean[] getEJBReferences() {
        if (this.ejbRefs == null) {
            return new EjbRefMBean[0];
        }
        EJBReference[] eJBReferenceArray = new EJBReference[this.ejbRefs.size()];
        return this.ejbRefs.toArray(eJBReferenceArray);
    }

    public void setEJBReferences(EjbRefMBean[] ejbRefMBeanArray) {
        EjbRefMBean[] ejbRefMBeanArray2 = this.getEJBReferences();
        this.ejbRefs = new ArrayList();
        if (ejbRefMBeanArray == null) {
            return;
        }
        for (int i = 0; i < ejbRefMBeanArray.length; ++i) {
            this.ejbRefs.add(ejbRefMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(ejbRefMBeanArray2, ejbRefMBeanArray)) {
            this.firePropertyChange("ejbReferences", ejbRefMBeanArray2, ejbRefMBeanArray);
        }
    }

    public void addEJBReference(EjbRefMBean ejbRefMBean) {
        if (this.ejbRefs == null) {
            this.ejbRefs = new ArrayList();
        }
        this.ejbRefs.add(ejbRefMBean);
    }

    public void removeEJBReference(EjbRefMBean ejbRefMBean) {
        if (this.ejbRefs != null) {
            this.ejbRefs.remove(ejbRefMBean);
        }
    }

    public EJBReference getEJBReference(String string) {
        if (this.ejbRefs == null) {
            return null;
        }
        for (EJBReference eJBReference : this.ejbRefs) {
            if (!string.equals(eJBReference.getEJBRefName())) continue;
            return eJBReference;
        }
        return null;
    }

    public EjbRefMBean[] getEJBLocalReferences() {
        if (this.ejbLocalRefs == null) {
            return new EjbRefMBean[0];
        }
        EjbRefMBean[] ejbRefMBeanArray = new EjbRefMBean[this.ejbLocalRefs.size()];
        return this.ejbLocalRefs.toArray(ejbRefMBeanArray);
    }

    public void setEJBLocalReferences(EjbRefMBean[] ejbRefMBeanArray) {
        EjbRefMBean[] ejbRefMBeanArray2 = this.getEJBLocalReferences();
        this.ejbLocalRefs = new ArrayList();
        if (ejbRefMBeanArray == null) {
            return;
        }
        for (int i = 0; i < ejbRefMBeanArray.length; ++i) {
            this.ejbLocalRefs.add(ejbRefMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(ejbRefMBeanArray2, ejbRefMBeanArray)) {
            this.firePropertyChange("ejbLocalReferences", ejbRefMBeanArray2, ejbRefMBeanArray);
        }
    }

    public void addEJBLocalReference(EjbRefMBean ejbRefMBean) {
        if (this.ejbLocalRefs == null) {
            this.ejbLocalRefs = new ArrayList();
        }
        this.ejbLocalRefs.add(ejbRefMBean);
    }

    public void removeEJBLocalReference(EjbRefMBean ejbRefMBean) {
        if (this.ejbLocalRefs != null) {
            this.ejbLocalRefs.remove(ejbRefMBean);
        }
    }

    public EJBLocalReference getEJBLocalReference(String string) {
        if (this.ejbLocalRefs == null) {
            return null;
        }
        for (EJBLocalReference eJBLocalReference : this.ejbLocalRefs) {
            if (!string.equals(eJBLocalReference.getEJBRefName())) continue;
            return eJBLocalReference;
        }
        return null;
    }

    public int getSessionTimeout() {
        SessionDescriptor sessionDescriptor = (SessionDescriptor)this.getSessionConfig();
        if (sessionDescriptor != null) {
            return sessionDescriptor.getSessionTimeout();
        }
        return -2;
    }

    public TagLibMBean[] getTagLibs() {
        if (this.taglibs == null) {
            return new TaglibDescriptor[0];
        }
        TaglibDescriptor[] taglibDescriptorArray = new TaglibDescriptor[this.taglibs.size()];
        return this.taglibs.toArray(taglibDescriptorArray);
    }

    public void setTagLibs(TagLibMBean[] tagLibMBeanArray) {
        TagLibMBean[] tagLibMBeanArray2 = this.getTagLibs();
        this.taglibs = new ArrayList();
        if (tagLibMBeanArray == null) {
            return;
        }
        for (int i = 0; i < tagLibMBeanArray.length; ++i) {
            this.taglibs.add(tagLibMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(tagLibMBeanArray2, tagLibMBeanArray)) {
            this.firePropertyChange("taglibs", tagLibMBeanArray2, tagLibMBeanArray);
        }
    }

    public void addTagLib(TagLibMBean tagLibMBean) {
        if (this.taglibs == null) {
            this.taglibs = new ArrayList();
        }
        this.taglibs.add(tagLibMBean);
    }

    public void removeTagLib(TagLibMBean tagLibMBean) {
        if (this.taglibs == null) {
            return;
        }
        this.taglibs.remove(tagLibMBean);
    }

    public SecurityRoleMBean[] getSecurityRoles() {
        if (this.secRoles == null) {
            return new SecurityRoleMBean[0];
        }
        SecurityRoleMBean[] securityRoleMBeanArray = new SecurityRoleMBean[this.secRoles.size()];
        return this.secRoles.toArray(securityRoleMBeanArray);
    }

    public void setSecurityRoles(SecurityRoleMBean[] securityRoleMBeanArray) {
        SecurityRoleMBean[] securityRoleMBeanArray2 = this.getSecurityRoles();
        this.secRoles = new ArrayList();
        for (int i = 0; i < securityRoleMBeanArray.length; ++i) {
            this.secRoles.add(securityRoleMBeanArray[i]);
        }
    }

    public void addSecurityRole(SecurityRoleMBean securityRoleMBean) {
        if (this.secRoles == null) {
            this.secRoles = new ArrayList();
        }
        this.secRoles.add(securityRoleMBean);
    }

    public void removeSecurityRole(SecurityRoleMBean securityRoleMBean) {
        if (this.secRoles == null) {
            return;
        }
        this.secRoles.remove(securityRoleMBean);
    }

    public String[] getSecurityRoleNames() {
        SecurityRoleDescriptor[] securityRoleDescriptorArray = (SecurityRoleDescriptor[])this.getSecurityRoles();
        String[] stringArray = new String[securityRoleDescriptorArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = securityRoleDescriptorArray[i].getRoleName();
        }
        return stringArray;
    }

    public SecurityConstraintMBean[] getSecurityConstraints() {
        if (this.secCons == null) {
            return new SecurityConstraint[0];
        }
        SecurityConstraintMBean[] securityConstraintMBeanArray = new SecurityConstraint[this.secCons.size()];
        this.secCons.toArray(securityConstraintMBeanArray);
        return securityConstraintMBeanArray;
    }

    public void setSecurityConstraints(SecurityConstraintMBean[] securityConstraintMBeanArray) {
        SecurityConstraintMBean[] securityConstraintMBeanArray2 = this.getSecurityConstraints();
        this.secCons = new ArrayList();
        if (securityConstraintMBeanArray == null) {
            return;
        }
        for (int i = 0; i < securityConstraintMBeanArray.length; ++i) {
            this.secCons.add(securityConstraintMBeanArray[i]);
        }
        if (!WebAppDescriptor.comp(securityConstraintMBeanArray2, securityConstraintMBeanArray)) {
            this.firePropertyChange("securityConstraints", securityConstraintMBeanArray2, securityConstraintMBeanArray);
        }
    }

    public void addSecurityConstraint(SecurityConstraintMBean securityConstraintMBean) {
        if (this.secCons == null) {
            this.secCons = new ArrayList();
        }
        this.secCons.add(securityConstraintMBean);
    }

    public void removeSecurityConstraint(SecurityConstraintMBean securityConstraintMBean) {
        if (this.secCons == null) {
            return;
        }
        this.secCons.remove(securityConstraintMBean);
    }

    public LoginConfigMBean getLoginConfig() {
        return this.login;
    }

    public void setLoginConfig(LoginConfigMBean loginConfigMBean) {
        this.login = loginConfigMBean;
    }

    private ParameterDescriptor getPD(String string) {
        ParameterDescriptor[] parameterDescriptorArray = (ParameterDescriptor[])this.getContextParams();
        for (int i = 0; i < parameterDescriptorArray.length; ++i) {
            if (!string.equals(parameterDescriptorArray[i].getParamName())) continue;
            return parameterDescriptorArray[i];
        }
        return null;
    }

    private boolean getBooleanPD(String string, boolean bl) {
        ParameterDescriptor parameterDescriptor = this.getPD(string);
        if (parameterDescriptor == null) {
            return bl;
        }
        return "true".equalsIgnoreCase(parameterDescriptor.getParamValue());
    }

    private String getStringPD(String string, String string2) {
        ParameterDescriptor parameterDescriptor = this.getPD(string);
        if (parameterDescriptor == null) {
            return string2;
        }
        return parameterDescriptor.getParamValue();
    }

    private int getIntPD(String string, int n) {
        ParameterDescriptor parameterDescriptor = this.getPD(string);
        if (parameterDescriptor == null) {
            return n;
        }
        String string2 = parameterDescriptor.getParamValue();
        if (string2 == null || (string2 = string2.trim()).length() == 0) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    private void addPD(String string, String string2, String string3) {
        ParameterDescriptor parameterDescriptor = new ParameterDescriptor(string, string2, string3);
        ParameterDescriptor[] parameterDescriptorArray = (ParameterDescriptor[])this.getContextParams();
        ParameterMBean[] parameterMBeanArray = new ParameterDescriptor[parameterDescriptorArray.length + 1];
        System.arraycopy(parameterDescriptorArray, 0, parameterMBeanArray, 0, parameterDescriptorArray.length);
        parameterMBeanArray[parameterDescriptorArray.length] = parameterDescriptor;
        this.setContextParams(parameterMBeanArray);
    }

    public boolean getWLJSPPrecompile() {
        return this.getBooleanPD("weblogic.jsp.precompile", false);
    }

    public void setWLJSPPrecompile(boolean bl) {
        String string = "weblogic.jsp.precompile";
        ParameterDescriptor parameterDescriptor = this.getPD(string);
        if (parameterDescriptor == null) {
            this.addPD(string, "" + bl, "Controls whether to precompile all web-app JSP's on server startup");
        } else {
            parameterDescriptor.setParamValue("" + bl);
        }
    }

    public String getWLJSPCompileCommand() {
        return this.getStringPD("weblogic.jsp.compileCommand", "javac");
    }

    public void setWLJSPCompileCommand(String string) {
        String string2 = "weblogic.jsp.compileCommand";
        ParameterDescriptor parameterDescriptor = this.getPD(string2);
        if (parameterDescriptor == null) {
            this.addPD(string2, string, "java compiler executable used to generate JSP pages");
        } else {
            parameterDescriptor.setParamValue(string);
        }
    }

    public String getWLJSPCompileClass() {
        return this.getStringPD("weblogic.jsp.compilerclass", null);
    }

    public void setWLJSPCompileClass(String string) {
        String string2 = "weblogic.jsp.compilerclass";
        ParameterDescriptor parameterDescriptor = this.getPD(string2);
        if (parameterDescriptor == null) {
            this.addPD(string2, string, "java compiler executable used to generate JSP pages");
        } else {
            parameterDescriptor.setParamValue(string);
        }
    }

    public boolean getWLJSPVerbose() {
        return this.getBooleanPD("weblogic.jsp.verbose", true);
    }

    public void setWLJSPVerbose(boolean bl) {
        String string = "weblogic.jsp.verbose";
        ParameterDescriptor parameterDescriptor = this.getPD(string);
        if (parameterDescriptor == null) {
            this.addPD(string, "" + bl, "Enables browser-friendly JSP error reporting and verbose JSP logging");
        } else {
            parameterDescriptor.setParamValue("" + bl);
        }
    }

    public String getWLJSPPackagePrefix() {
        return this.getStringPD("weblogic.jsp.packagePrefix", "jsp_servlet");
    }

    public void setWLJSPPackagePrefix(String string) {
        String string2 = "weblogic.jsp.packagePrefix";
        ParameterDescriptor parameterDescriptor = this.getPD(string2);
        if (parameterDescriptor == null) {
            this.addPD(string2, string, "java package prefix for generated JSP code");
        } else {
            parameterDescriptor.setParamValue(string);
        }
    }

    public String getWLJSPEncoding() {
        return this.getStringPD("weblogic.jsp.encoding", "");
    }

    public void setWLJSPEncoding(String string) {
        String string2 = "weblogic.jsp.encoding";
        ParameterDescriptor parameterDescriptor = this.getPD(string2);
        if (parameterDescriptor == null) {
            this.addPD(string2, string, "default i18n charset for JSP pages in this web application");
        } else {
            parameterDescriptor.setParamValue(string);
        }
    }

    public boolean getWLJSPKeepgenerated() {
        return this.getBooleanPD("weblogic.jsp.keepgenerated", false);
    }

    public void setWLJSPKeepgenerated(boolean bl) {
        String string = "weblogic.jsp.keepgenerated";
        ParameterDescriptor parameterDescriptor = this.getPD(string);
        if (parameterDescriptor == null) {
            this.addPD(string, "" + bl, "Enables saving generated JSP sources in the JSP working directory - useful for debugging");
        } else {
            parameterDescriptor.setParamValue("" + bl);
        }
    }

    public boolean getWLSessionPersistence() {
        return this.getBooleanPD("weblogic.httpd.session.persistence", false);
    }

    public void setWLSessionPersistence(boolean bl) {
        String string = "weblogic.httpd.session.persistence";
        ParameterDescriptor parameterDescriptor = this.getPD(string);
        if (parameterDescriptor == null) {
            this.addPD(string, "" + bl, "Enables one of WebLogic's persistent HTTP session stores");
        } else {
            parameterDescriptor.setParamValue("" + bl);
        }
    }

    public String getWLSessionPersistenceType() {
        return this.getStringPD("weblogic.httpd.session.persistentStoreType", "file");
    }

    public void setWLSessionPersistenceType(String string) {
        if (!("file".equals(string) || "replicated".equals(string) || "replicated_if_clustered".equals(string) || "jdbc".equals(string) || "cookie".equals(string))) {
            throw new IllegalArgumentException("persistent store type must be one of: 'memory'|'file'|'replicated'|'replicated_if_clustered'|'jdbc'|'cookie' not '" + string + "'");
        }
        String string2 = "weblogic.httpd.session.persistentStoreType";
        ParameterDescriptor parameterDescriptor = this.getPD(string2);
        if (parameterDescriptor == null) {
            this.addPD(string2, string, "Selects the type of WebLogic's persistent HTTP session stores");
        } else {
            parameterDescriptor.setParamValue(string);
        }
    }

    public boolean getWLSessionDebug() {
        return this.getBooleanPD("weblogic.httpd.session.debug", false);
    }

    public void setWLSessionDebug(boolean bl) {
        String string = "weblogic.httpd.session.debug";
        ParameterDescriptor parameterDescriptor = this.getPD(string);
        if (parameterDescriptor == null) {
            this.addPD(string, "" + bl, "Enables verbose logging of session activity for debugging");
        } else {
            parameterDescriptor.setParamValue("" + bl);
        }
    }

    public int getWLSessionIDLength() {
        return this.getIntPD("weblogic.httpd.session.IDLength", 52);
    }

    public void setWLSessionIDLength(int n) {
        String string = "weblogic.httpd.session.IDLength";
        if (n < 10 || n > 200) {
            throw new IllegalArgumentException("sessionid length must be > 10 && < 200: not " + n);
        }
        ParameterDescriptor parameterDescriptor = this.getPD(string);
        if (parameterDescriptor == null) {
            this.addPD(string, "" + n, "Specifies the length in chars of the random part of generated session IDs");
        } else {
            parameterDescriptor.setParamValue("" + n);
        }
    }

    public int getWLSessionInvalidationInterval() {
        return this.getIntPD("weblogic.httpd.session.invalidationIntervalSecs", 60);
    }

    public void setWLSessionInvalidationInterval(int n) {
        String string = "weblogic.httpd.session.invalidationIntervalSecs";
        if (n < 20) {
            throw new IllegalArgumentException("invalidation interval seconds must be > 20: not " + n);
        }
        ParameterDescriptor parameterDescriptor = this.getPD(string);
        if (parameterDescriptor == null) {
            this.addPD(string, "" + n, "Specifies the frequency in seconds where stored sessions are checked for expiration");
        } else {
            parameterDescriptor.setParamValue("" + n);
        }
    }

    public int getWLCookieAge() {
        return this.getIntPD("weblogic.httpd.session.cookie.maxAgeSecs", -1);
    }

    public void setWLCookieAge(int n) {
        String string = "weblogic.httpd.session.cookie.maxAgeSecs";
        if (n <= 0 && n != -1) {
            throw new IllegalArgumentException("cookie timeout must be >0 || == -1: not " + n);
        }
        ParameterDescriptor parameterDescriptor = this.getPD(string);
        if (parameterDescriptor == null) {
            this.addPD(string, "" + n, "Specifies in seconds the 'expires' field of HTTP cookies used for session tracking");
        } else {
            parameterDescriptor.setParamValue("" + n);
        }
    }

    public String getWLSessionPersistentStoreDir() {
        return this.getStringPD("weblogic.httpd.session.persistentStoreDir", "session_db");
    }

    public void setWLSessionPersistentStoreDir(String string) {
        String string2 = "weblogic.httpd.session.persistentStoreDir";
        ParameterDescriptor parameterDescriptor = this.getPD(string2);
        if (parameterDescriptor == null) {
            this.addPD(string2, string, "filesystem path (absolute or relative to server home) to be used for file persistence");
        } else {
            parameterDescriptor.setParamValue(string);
        }
    }

    public String getWLSessionPersistentStoreCookieName() {
        return this.getStringPD("weblogic.httpd.session.persistentStoreCookieName", "WLCOOKIE");
    }

    public void setWLSessionPersistentStoreCookieName(String string) {
        String string2 = "weblogic.httpd.session.persistentStoreCookieName";
        ParameterDescriptor parameterDescriptor = this.getPD(string2);
        if (parameterDescriptor == null) {
            this.addPD(string2, string, "Cookie name used to store the attributes for a cookie based session persistence");
        } else {
            parameterDescriptor.setParamValue(string);
        }
    }

    public void validate() throws DescriptorValidationException {
        Iterator iterator;
        this.removeDescriptorErrors();
        boolean bl = true;
        if (this.contextParams != null) {
            iterator = this.contextParams.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.servlets != null) {
            iterator = this.servlets.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.servletMaps != null) {
            iterator = this.servletMaps.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.sessionConfig != null) {
            bl &= this.check(this.sessionConfig);
        }
        if (this.mimeMaps != null) {
            iterator = this.mimeMaps.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.welcomeFiles != null) {
            bl &= this.check(this.welcomeFiles);
        }
        if (this.errorPages != null) {
            iterator = this.errorPages.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.resourceRefs != null) {
            iterator = this.resourceRefs.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.resourceEnvRefs != null) {
            iterator = this.resourceEnvRefs.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.envEntries != null) {
            iterator = this.envEntries.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.ejbRefs != null) {
            iterator = this.ejbRefs.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.taglibs != null) {
            iterator = this.taglibs.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.secRoles != null) {
            iterator = this.secRoles.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.secCons != null) {
            iterator = this.secCons.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.eventListeners != null) {
            iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.filters != null) {
            iterator = this.filters.iterator();
            while (iterator.hasNext()) {
                bl &= this.check((WebElementMBean)iterator.next());
            }
        }
        if (this.filterMappings != null) {
            for (String[] stringArray : this.filterMappings) {
                bl &= this.check((WebElementMBean)stringArray);
            }
        }
        if (this.login != null) {
            bl &= this.check(this.login);
        }
        if (!bl) {
            String[] stringArray;
            stringArray = this.getDescriptorErrors();
            throw new DescriptorValidationException(this.arrayToString(stringArray));
        }
    }

    public String toXML(int n) {
        String string = "";
        String string2 = this.getEncoding();
        if (string2 != null) {
            string = string + "<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>\n";
        }
        string = string + this.indentStr(n) + "<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\">";
        string = string + "\n" + this.indentStr(n) + "<web-app>\n";
        n += 2;
        if (this.uiData != null) {
            string = string + "\n" + this.uiData.toXML(n);
        }
        if (this.distributable) {
            string = string + "\n" + this.indentStr(n) + "<distributable/>\n";
        }
        if (this.contextParams != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.contextParams) {
                string = string + "\n" + ((ParameterDescriptor)baseServletDescriptor).toXML(n);
            }
        }
        if (this.filters != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.filters) {
                string = string + "\n" + ((FilterDescriptor)baseServletDescriptor).toXML(n);
            }
        }
        if (this.filterMappings != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.filterMappings) {
                string = string + "\n" + ((FilterMappingDescriptor)baseServletDescriptor).toXML(n);
            }
        }
        if (this.eventListeners != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.eventListeners) {
                string = string + "\n" + ((ListenerDescriptor)baseServletDescriptor).toXML(n);
            }
        }
        if (this.servlets != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.servlets) {
                string = string + "\n" + ((ServletDescriptor)baseServletDescriptor).toXML(n);
            }
        }
        if (this.servletMaps != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.servletMaps) {
                string = string + "\n" + ((ServletMappingDescriptor)baseServletDescriptor).toXML(n);
            }
        }
        if (this.sessionConfig != null) {
            string = string + "\n" + this.sessionConfig.toXML(n);
        }
        if (this.mimeMaps != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.mimeMaps) {
                string = string + "\n" + ((MimeMappingDescriptor)baseServletDescriptor).toXML(n);
            }
        }
        if (this.welcomeFiles != null) {
            string = string + "\n" + this.welcomeFiles.toXML(n);
        }
        if (this.errorPages != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.errorPages) {
                string = string + "\n" + ((ErrorPageDescriptor)baseServletDescriptor).toXML(n);
            }
        }
        if (this.taglibs != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.taglibs) {
                string = string + "\n" + ((TaglibDescriptor)baseServletDescriptor).toXML(n);
            }
        }
        if (this.resourceEnvRefs != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.resourceEnvRefs) {
                try {
                    ((ResourceEnvRef)baseServletDescriptor).validate();
                }
                catch (DescriptorValidationException descriptorValidationException) {
                    HTTPLogger.logDescriptorValidationFailure((String)"web.xml", (String)RESOURCE_ENV_REF, (Throwable)((Object)descriptorValidationException));
                    continue;
                }
                string = string + "\n" + ((ResourceEnvRef)baseServletDescriptor).toXML(n);
            }
        }
        if (this.resourceRefs != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.resourceRefs) {
                try {
                    ((ResourceReference)baseServletDescriptor).validate();
                }
                catch (DescriptorValidationException descriptorValidationException) {
                    HTTPLogger.logDescriptorValidationFailure((String)"web.xml", (String)RESOURCE_REF, (Throwable)((Object)descriptorValidationException));
                    continue;
                }
                string = string + "\n" + ((ResourceReference)baseServletDescriptor).toXML(n);
            }
        }
        if (this.secCons != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.secCons) {
                string = string + "\n" + ((SecurityConstraint)baseServletDescriptor).toXML(n);
            }
        }
        if (this.login != null) {
            string = string + "\n" + this.login.toXML(n);
        }
        if (this.secRoles != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.secRoles) {
                string = string + "\n" + ((SecurityRoleDescriptor)baseServletDescriptor).toXML(n);
            }
        }
        if (this.envEntries != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.envEntries) {
                string = string + "\n" + ((EnvironmentEntry)baseServletDescriptor).toXML(n);
            }
        }
        if (this.ejbRefs != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.ejbRefs) {
                string = string + "\n" + ((EJBReference)baseServletDescriptor).toXML(n);
            }
        }
        if (this.ejbLocalRefs != null) {
            for (BaseServletDescriptor baseServletDescriptor : this.ejbLocalRefs) {
                string = string + "\n" + ((EJBReference)baseServletDescriptor).toXML(n);
            }
        }
        string = string + "\n" + this.indentStr(n -= 2) + "</web-app>";
        return string;
    }

    public int compare(Object object, Object object2) {
        int n = 0;
        if (object instanceof ServletMBean) {
            ServletMBean servletMBean = (ServletMBean)object;
            ServletMBean servletMBean2 = (ServletMBean)object2;
            n = servletMBean.getServletName().compareTo(servletMBean2.getServletName());
        } else if (object instanceof FilterMBean) {
            FilterMBean filterMBean = (FilterMBean)object;
            FilterMBean filterMBean2 = (FilterMBean)object2;
            n = filterMBean.getFilterName().compareTo(filterMBean2.getFilterName());
        }
        return n;
    }

    public boolean equals(Object object) {
        return object == this;
    }
}

