/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.WebResourceCollectionMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class WebResourceDescriptor
extends BaseServletDescriptor
implements ToXML,
WebResourceCollectionMBean {
    private static final long serialVersionUID = -7968184076073383050L;
    private static final String WEB_RESOURCE_COLLECTION = "web-resource-collection";
    private static final String WEB_RESOURCE_NAME = "web-resource-name";
    private static final String URL_PATTERN = "url-pattern";
    private static final String HTTP_METHOD = "http-method";
    private String resourceName;
    private String description;
    private String[] urlPatterns;
    private String[] httpMethods;

    public WebResourceDescriptor() {
        this("");
    }

    public WebResourceDescriptor(String string) {
        this.resourceName = string;
    }

    public WebResourceDescriptor(WebResourceCollectionMBean webResourceCollectionMBean) {
        this.setResourceName(webResourceCollectionMBean.getResourceName());
        this.setDescription(webResourceCollectionMBean.getDescription());
        this.setUrlPatterns(webResourceCollectionMBean.getUrlPatterns());
        this.setHttpMethods(webResourceCollectionMBean.getHttpMethods());
    }

    public WebResourceDescriptor(Element element) throws DOMProcessingException {
        int n;
        Iterator iterator;
        String[] stringArray;
        List list;
        Element element2 = DOMUtils.getElementByTagName(element, WEB_RESOURCE_NAME);
        if (element2 == null) {
            throw new DOMProcessingException("You must specify '<web-resource-name>' within web-resource-collection");
        }
        this.resourceName = DOMUtils.getValueByTagName(element, WEB_RESOURCE_NAME);
        this.description = DOMUtils.getOptionalValueByTagName(element, "description");
        List list2 = DOMUtils.getOptionalElementsByTagName(element, URL_PATTERN);
        if (list2 != null && list2.size() > 0) {
            list = DOMUtils.getTextDataValues(list2);
            if (list != null) {
                stringArray = new String[list.size()];
                iterator = list.iterator();
                for (n = 0; iterator.hasNext() && n < stringArray.length; ++n) {
                    stringArray[n] = (String)iterator.next();
                    int n2 = stringArray[n].length();
                    if (n2 < 2 || stringArray[n].charAt(n2 - 1) != '*' || stringArray[n].charAt(n2 - 2) == '/') continue;
                    throw new DOMProcessingException("The <url-pattern> : \"" + stringArray[n] + "\", specified for the <" + WEB_RESOURCE_COLLECTION + "> with the <" + WEB_RESOURCE_NAME + "> : \"" + this.resourceName + "\", is an illegal non-exact pattern as per the Servlet specification.");
                }
                this.urlPatterns = stringArray;
            }
        } else {
            HTTPLogger.logUrlPatternMissingFromWebResource((String)this.resourceName);
            throw new DOMProcessingException("<url-pattern> not specified for <web-resource-name> : " + this.resourceName);
        }
        list2 = DOMUtils.getOptionalElementsByTagName(element, HTTP_METHOD);
        if (list2 != null && list2.size() > 0 && (list = DOMUtils.getTextDataValues(list2)) != null) {
            stringArray = new String[list.size()];
            iterator = list.iterator();
            for (n = 0; iterator.hasNext() && n < stringArray.length; ++n) {
                stringArray[n] = (String)iterator.next();
            }
            this.httpMethods = stringArray;
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String string) {
        String string2 = this.resourceName;
        this.resourceName = string;
        if (!WebResourceDescriptor.comp((Object)string2, (Object)string)) {
            this.firePropertyChange("resourceName", string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!WebResourceDescriptor.comp((Object)string2, (Object)this.description)) {
            this.firePropertyChange("description", string2, string);
        }
    }

    public String[] getUrlPatterns() {
        return this.urlPatterns;
    }

    public void setUrlPatterns(String[] stringArray) {
        String[] stringArray2 = this.urlPatterns;
        this.urlPatterns = stringArray;
        if (!WebResourceDescriptor.comp(stringArray2, stringArray)) {
            this.firePropertyChange("urlPatterns", stringArray2, stringArray);
        }
    }

    public void addUrlPattern(String string) {
        String[] stringArray = this.getUrlPatterns();
        if (stringArray == null) {
            stringArray = new String[]{string};
            this.setUrlPatterns(stringArray);
            return;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        this.setUrlPatterns(stringArray2);
    }

    public void removeUrlPattern(String string) {
        String[] stringArray = this.getUrlPatterns();
        if (stringArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - (n + 1));
            this.setUrlPatterns(stringArray2);
        }
    }

    public String[] getHttpMethods() {
        return this.httpMethods;
    }

    public void setHttpMethods(String[] stringArray) {
        String[] stringArray2 = this.httpMethods;
        this.httpMethods = stringArray;
        if (!WebResourceDescriptor.comp(stringArray2, stringArray)) {
            this.firePropertyChange("httpMethods", stringArray2, stringArray);
        }
    }

    public void addHttpMethod(String string) {
        String[] stringArray = this.getHttpMethods();
        if (stringArray == null) {
            stringArray = new String[]{string};
            this.setHttpMethods(stringArray);
            return;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        this.setHttpMethods(stringArray2);
    }

    public void removeHttpMethod(String string) {
        String[] stringArray = this.getHttpMethods();
        if (stringArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - (n + 1));
            this.setHttpMethods(stringArray2);
        }
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
        boolean bl = true;
        if (this.resourceName == null || (this.resourceName = this.resourceName.trim()).length() == 0) {
            this.addDescriptorError("NO_WEB_RESOURCE");
            bl = false;
        }
        if (!bl) {
            throw new DescriptorValidationException();
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        int n2;
        String string = "";
        string = string + this.indentStr(n) + "<" + WEB_RESOURCE_COLLECTION + ">\n";
        string = string + this.indentStr(n += 2) + "<web-resource-name>" + this.resourceName + "</web-resource-name>\n";
        if (this.description != null) {
            string = string + this.indentStr(n) + "<description>" + this.description + "</description>\n";
        }
        if (this.urlPatterns != null) {
            for (n2 = 0; n2 < this.urlPatterns.length; ++n2) {
                string = string + this.indentStr(n) + "<url-pattern>" + this.urlPatterns[n2] + "</url-pattern>\n";
            }
        }
        if (this.httpMethods != null) {
            for (n2 = 0; n2 < this.httpMethods.length; ++n2) {
                string = string + this.indentStr(n) + "<http-method>" + this.httpMethods[n2] + "</http-method>\n";
            }
        }
        string = string + this.indentStr(n -= 2) + "</web-resource-collection>\n";
        return string;
    }

    public String toString() {
        Object object;
        String string = "WebResourceDescriptor(";
        string = string + "description=" + this.getDescription() + ",";
        string = string + "resource=" + this.getResourceName() + ",";
        String[] stringArray = this.getHttpMethods();
        if (stringArray == null) {
            string = string + "methods=null,";
        } else {
            object = "{";
            for (int i = 0; i < stringArray.length; ++i) {
                object = (String)object + stringArray[i];
                object = i == stringArray.length - 1 ? (String)object + "}" : (String)object + ",";
            }
            string = string + "methods=" + (String)object + ",";
        }
        object = this.getUrlPatterns();
        if (object == null) {
            string = string + "UrlPatterns=null,";
        } else {
            String string2 = "{";
            for (int i = 0; i < ((String[])object).length; ++i) {
                string2 = string2 + object[i];
                string2 = i == ((String[])object).length - 1 ? string2 + "}" : string2 + ",";
            }
            string = string + "UrlPatterns=" + string2 + ",";
        }
        string = string + ")";
        return string;
    }
}

