/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd;

import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.webapp.WelcomeFileListMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class WelcomeFilesDescriptor
extends BaseServletDescriptor
implements ToXML,
WelcomeFileListMBean {
    private static final long serialVersionUID = 8641270140745843773L;
    private static final String WELCOME_FILE = "welcome-file";
    private String[] fileNames;

    public WelcomeFilesDescriptor() {
        this.fileNames = new String[0];
    }

    public WelcomeFilesDescriptor(WelcomeFileListMBean welcomeFileListMBean) {
        if (welcomeFileListMBean != null) {
            String[] stringArray = welcomeFileListMBean.getWelcomeFiles();
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            this.fileNames = stringArray2;
        } else {
            this.fileNames = new String[0];
        }
    }

    public WelcomeFilesDescriptor(Element element) throws DOMProcessingException {
        List list = DOMUtils.getValuesByTagName(element, WELCOME_FILE);
        if (list == null) {
            this.fileNames = new String[0];
        } else {
            String[] stringArray = new String[list.size()];
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = (String)iterator.next();
                ++n;
            }
            this.fileNames = stringArray;
        }
    }

    public String[] getWelcomeFiles() {
        return this.fileNames;
    }

    public void setWelcomeFiles(String[] stringArray) {
        String[] stringArray2 = this.fileNames;
        this.fileNames = stringArray == null ? new String[0] : stringArray;
        if (!WelcomeFilesDescriptor.comp(stringArray2, stringArray)) {
            this.firePropertyChange("welcomeFiles", stringArray2, stringArray);
        }
    }

    public void addWelcomeFile(String string) {
        String[] stringArray = this.getWelcomeFiles();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        this.setWelcomeFiles(stringArray2);
    }

    public void removeWelcomeFile(String string) {
        String[] stringArray = this.getWelcomeFiles();
        if (stringArray == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - (n + 1));
            this.setWelcomeFiles(stringArray2);
        }
    }

    public void validate() throws DescriptorValidationException {
        this.removeDescriptorErrors();
        String[] stringArray = this.getWelcomeFiles();
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && stringArray[i].length() != 0) continue;
            this.addDescriptorError("INVALID_WELCOME_FILE", "" + i);
            bl = false;
        }
        if (!bl) {
            throw new DescriptorValidationException("INVALID_WELCOME_FILE");
        }
    }

    public void register() throws ManagementException {
        super.register();
    }

    public String toXML(int n) {
        String string = "";
        if (this.fileNames == null || this.fileNames.length == 0) {
            return string;
        }
        string = string + this.indentStr(n) + "<welcome-file-list>\n";
        n += 2;
        for (int i = 0; i < this.fileNames.length; ++i) {
            String string2 = this.fileNames[i];
            string = string + this.indentStr(n) + "<welcome-file>" + string2 + "</welcome-file>\n";
        }
        string = string + this.indentStr(n -= 2) + "</welcome-file-list>\n";
        return string;
    }
}

