/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd.compliance;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.j2ee.descriptor.FilterBean;
import weblogic.j2ee.descriptor.FilterMappingBean;
import weblogic.j2ee.descriptor.SecurityConstraintBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.ServletMappingBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.compliance.ComplianceChecker;
import weblogic.servlet.internal.dd.compliance.ComplianceException;
import weblogic.servlet.internal.dd.compliance.DeploymentInfo;
import weblogic.servlet.internal.dd.compliance.DescriptorErrorInfo;
import weblogic.servlet.internal.dd.compliance.EJBRefsComplianceChecker;
import weblogic.servlet.internal.dd.compliance.EnvEntryComplianceChecker;
import weblogic.servlet.internal.dd.compliance.FilterComplianceChecker;
import weblogic.servlet.internal.dd.compliance.SecurityConstraintComplianceChecker;
import weblogic.servlet.internal.dd.compliance.ServletComplianceChecker;
import weblogic.servlet.internal.dd.compliance.WebAppComplianceTextFormatter;
import weblogic.servlet.internal.dd.compliance.WebAppDescriptorComplianceChecker;
import weblogic.servlet.internal.dd.compliance.WebLogicWebAppComplianceChecker;
import weblogic.tools.ui.progress.ProgressListener;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.classloaders.GenericClassLoader;

public abstract class BaseComplianceChecker
implements ComplianceChecker {
    private static final boolean debug = false;
    protected ProgressListener listener;
    protected boolean executionCancelled = false;
    protected ArrayList errorList;
    protected WebAppComplianceTextFormatter fmt = new WebAppComplianceTextFormatter();
    protected boolean verbose = false;

    public BaseComplianceChecker() {
    }

    public BaseComplianceChecker(ProgressListener progressListener) {
        this();
        this.listener = progressListener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    public void cancelExecution() {
        this.executionCancelled = true;
    }

    public void update(String string) {
        if (this.listener != null) {
            this.listener.update(string);
        } else if (this.verbose) {
            HTTPLogger.logInfo((String)"ComplianceChecker", (String)string);
        }
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void addDescriptorError(ComplianceException complianceException) {
        if (this.errorList == null) {
            this.errorList = new ArrayList();
        }
        if (complianceException != null) {
            this.errorList.add(complianceException);
        }
    }

    public void addDescriptorError(String string, DescriptorErrorInfo descriptorErrorInfo) {
        if (this.errorList == null) {
            this.errorList = new ArrayList();
        }
        if (descriptorErrorInfo == null) {
            this.errorList.add(new ComplianceException(string));
        } else {
            this.errorList.add(new ComplianceException(string, descriptorErrorInfo));
        }
    }

    public void addDescriptorError(String string) {
        this.addDescriptorError(string, null);
    }

    public List getDescriptorErrorsAsList() {
        return this.errorList;
    }

    public boolean hasErrors() {
        return this.errorList != null && !this.errorList.isEmpty();
    }

    public void checkForExceptions() throws ErrorCollectionException {
        if (this.hasErrors()) {
            ErrorCollectionException errorCollectionException = new ErrorCollectionException();
            List list = this.getDescriptorErrorsAsList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                errorCollectionException.add((Throwable)((ComplianceException)iterator.next()));
            }
            list.clear();
            throw errorCollectionException;
        }
    }

    public abstract void check(DeploymentInfo var1) throws ErrorCollectionException;

    protected boolean isClassAssignable(ClassLoader classLoader, String string, String string2, String string3) {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        try {
            clazz = classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.update(this.fmt.warning() + this.fmt.CLASS_NOT_FOUND(string, string2));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.update(this.fmt.warning() + " Error while loading class : " + string2 + noClassDefFoundError.getMessage());
        }
        catch (Exception exception) {
            this.update(this.fmt.warning() + this.fmt.CLASS_NOT_FOUND(string, string2) + StackTraceUtils.throwable2StackTrace((Throwable)exception));
        }
        if (clazz == null) {
            return false;
        }
        try {
            clazz2 = classLoader.loadClass(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.update(this.fmt.warning() + " Unable to load class '" + string3 + "' " + (classLoader instanceof GenericClassLoader ? " from the following classpath :" + ((GenericClassLoader)classLoader).getClassPath() : ""));
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            this.addDescriptorError(this.fmt.CLASS_NOT_ASSIGNABLE_FROM(string3, string, string2));
            return false;
        }
        return true;
    }

    public static ComplianceChecker[] makeComplianceCheckers(DeploymentInfo deploymentInfo) {
        ServletMappingBean[] servletMappingBeanArray;
        ArrayList<BaseComplianceChecker> arrayList = new ArrayList<BaseComplianceChecker>();
        WebAppBean webAppBean = deploymentInfo.getWebAppBean();
        if (webAppBean != null) {
            SecurityConstraintBean[] securityConstraintBeanArray;
            arrayList.add(new WebAppDescriptorComplianceChecker());
            servletMappingBeanArray = webAppBean.getServletMappings();
            ServletBean[] servletBeanArray = webAppBean.getServlets();
            if (servletMappingBeanArray != null || servletBeanArray != null) {
                arrayList.add(new ServletComplianceChecker());
            }
            FilterBean[] filterBeanArray = webAppBean.getFilters();
            FilterMappingBean[] filterMappingBeanArray = webAppBean.getFilterMappings();
            if (filterBeanArray != null || filterMappingBeanArray != null) {
                arrayList.add(new FilterComplianceChecker());
            }
            if ((securityConstraintBeanArray = webAppBean.getSecurityConstraints()) != null) {
                arrayList.add(new SecurityConstraintComplianceChecker());
            }
            if (webAppBean.getEjbRefs() != null || webAppBean.getEjbLocalRefs() != null) {
                arrayList.add(new EJBRefsComplianceChecker());
            }
            if (webAppBean.getEnvEntries() != null && webAppBean.getEnvEntries().length > 0) {
                arrayList.add(new EnvEntryComplianceChecker());
            }
        }
        if ((servletMappingBeanArray = deploymentInfo.getWeblogicWebAppBean()) != null) {
            arrayList.add(new WebLogicWebAppComplianceChecker());
        }
        if (arrayList.isEmpty()) {
            HTTPLogger.logInfo((String)"ComplianceChecker", (String)"Could not find elements to be checked for compliance, skipping compliance check");
        }
        return arrayList.toArray(new ComplianceChecker[arrayList.size()]);
    }
}

