/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd.compliance;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.internal.WebAppDescriptor;
import weblogic.servlet.internal.dd.compliance.BaseComplianceChecker;
import weblogic.servlet.internal.dd.compliance.ComplianceChecker;
import weblogic.servlet.internal.dd.compliance.DeploymentInfo;
import weblogic.tools.ui.progress.ProgressListener;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class ComplianceUtils {
    private static final boolean debug = false;

    public static void checkCompliance(DeploymentInfo deploymentInfo, ProgressListener progressListener) throws ErrorCollectionException {
        ComplianceChecker[] complianceCheckerArray = BaseComplianceChecker.makeComplianceCheckers(deploymentInfo);
        ErrorCollectionException errorCollectionException = null;
        for (int i = 0; i < complianceCheckerArray.length; ++i) {
            complianceCheckerArray[i].setProgressListener(progressListener);
            complianceCheckerArray[i].setVerbose(deploymentInfo.isVerbose());
            try {
                complianceCheckerArray[i].check(deploymentInfo);
                continue;
            }
            catch (ErrorCollectionException errorCollectionException2) {
                if (errorCollectionException == null) {
                    errorCollectionException = new ErrorCollectionException();
                }
                if (errorCollectionException2 == null || errorCollectionException2.isEmpty()) continue;
                Collection collection = errorCollectionException2.getExceptions();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    errorCollectionException.add((Throwable)iterator.next());
                }
                continue;
            }
            catch (Exception exception) {
                if (errorCollectionException == null) {
                    errorCollectionException = new ErrorCollectionException();
                }
                errorCollectionException.add((Throwable)exception);
            }
        }
        if (errorCollectionException != null && !errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkCompliance(File file, ClassLoader classLoader, ProgressListener progressListener) throws ErrorCollectionException, IOException {
        Object object;
        WeblogicWebAppBean weblogicWebAppBean;
        WebAppBean webAppBean;
        block8: {
            webAppBean = null;
            weblogicWebAppBean = null;
            VirtualJarFile virtualJarFile = null;
            ErrorCollectionException errorCollectionException = null;
            try {
                try {
                    virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
                    object = new WebAppDescriptor(virtualJarFile);
                    webAppBean = ((WebAppDescriptor)object).getWebAppBean();
                    weblogicWebAppBean = ((WebAppDescriptor)object).getWeblogicWebAppBean();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Object var9_11 = null;
                    if (virtualJarFile != null) {
                        virtualJarFile.close();
                    }
                    break block8;
                }
                catch (XMLStreamException xMLStreamException) {
                    if (errorCollectionException == null) {
                        errorCollectionException = new ErrorCollectionException();
                    }
                    errorCollectionException.add((Throwable)xMLStreamException);
                    throw errorCollectionException;
                }
                Object var9_10 = null;
                if (virtualJarFile == null) break block8;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (virtualJarFile != null) {
                    virtualJarFile.close();
                }
                throw throwable;
            }
            virtualJarFile.close();
        }
        object = new DeploymentInfo(webAppBean, weblogicWebAppBean);
        ((DeploymentInfo)object).setClassLoader(classLoader);
        ComplianceUtils.checkCompliance((DeploymentInfo)object, progressListener);
    }
}

