/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd.compliance;

import weblogic.j2ee.descriptor.EjbLocalRefBean;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.EjbReferenceDescriptionBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.j2ee.validation.ModuleValidationInfo;
import weblogic.servlet.internal.dd.compliance.BaseComplianceChecker;
import weblogic.servlet.internal.dd.compliance.DeploymentInfo;
import weblogic.utils.ErrorCollectionException;

public class EJBRefsComplianceChecker
extends BaseComplianceChecker {
    private static final String EJB_LOCAL_REF = "<ejb-local-ref>";
    private static final String EJB_REF = "<ejb-ref>";
    private static final String SESSION = "Session";
    private static final String ENTITY = "Entity";

    public void check(DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        int n;
        WebAppBean webAppBean = deploymentInfo.getWebAppBean();
        if (webAppBean == null) {
            return;
        }
        EjbRefBean[] ejbRefBeanArray = webAppBean.getEjbRefs();
        EjbLocalRefBean[] ejbLocalRefBeanArray = webAppBean.getEjbLocalRefs();
        if (ejbRefBeanArray != null) {
            for (n = 0; n < ejbRefBeanArray.length; ++n) {
                this.checkEJBRef(ejbRefBeanArray[n], deploymentInfo);
            }
        }
        if (ejbLocalRefBeanArray != null && ejbLocalRefBeanArray.length > 0) {
            for (n = 0; n < ejbLocalRefBeanArray.length; ++n) {
                this.checkEJBLocalRef(ejbLocalRefBeanArray[n], deploymentInfo);
            }
        }
        this.checkForExceptions();
    }

    private void checkEJBLocalRef(EjbLocalRefBean ejbLocalRefBean, DeploymentInfo deploymentInfo) {
        if (ejbLocalRefBean == null) {
            return;
        }
        this.validate(ejbLocalRefBean.getEjbRefName(), ejbLocalRefBean.getLocalHome(), ejbLocalRefBean.getLocal(), ejbLocalRefBean.getEjbRefType(), ejbLocalRefBean.getEjbLink(), true, deploymentInfo, true);
    }

    private void checkEJBRef(EjbRefBean ejbRefBean, DeploymentInfo deploymentInfo) {
        if (ejbRefBean == null) {
            return;
        }
        this.validate(ejbRefBean.getEjbRefName(), ejbRefBean.getHome(), ejbRefBean.getRemote(), ejbRefBean.getEjbRefType(), ejbRefBean.getEjbLink(), false, deploymentInfo, false);
    }

    private void validate(String string, String string2, String string3, String string4, String string5, boolean bl, DeploymentInfo deploymentInfo, boolean bl2) {
        ModuleValidationInfo moduleValidationInfo;
        WeblogicWebAppBean weblogicWebAppBean = deploymentInfo.getWeblogicWebAppBean();
        if (weblogicWebAppBean == null && (string5 == null || string5.length() == 0)) {
            this.addDescriptorError(this.fmt.NO_EJBLINK_AND_JNDI_NAME(bl ? EJB_LOCAL_REF : EJB_REF, string));
            return;
        }
        if (weblogicWebAppBean != null && (string5 == null || string5.length() == 0)) {
            boolean bl3 = false;
            EjbReferenceDescriptionBean[] ejbReferenceDescriptionBeanArray = null;
            ejbReferenceDescriptionBeanArray = weblogicWebAppBean.getEjbReferenceDescriptions();
            if (ejbReferenceDescriptionBeanArray != null) {
                for (int i = 0; i < ejbReferenceDescriptionBeanArray.length; ++i) {
                    if (!string.equals(ejbReferenceDescriptionBeanArray[i].getEjbRefName())) continue;
                    bl3 = true;
                    break;
                }
            }
            if (!bl3) {
                this.addDescriptorError(this.fmt.NO_EJBLINK_AND_JNDI_NAME(bl ? EJB_LOCAL_REF : EJB_REF, string));
                return;
            }
        }
        if ((moduleValidationInfo = deploymentInfo.getModuleValidationInfo()) != null && string5 != null) {
            moduleValidationInfo.addEJBRef(string, bl, string3, string2, string4, string5, bl2);
        }
    }
}

